/*
 * kanji.h -- describes several characteristics of Kanji
 *	      changing this description, you can easily make
 *	      ?term for your own language if its code system
 *	      is similar to Kanji.
 */

/*
 * Escape sequences to designate the specified code set
 * in 7bit environtent and only GL being used.
 * If you would like to customize for other languages,
 * you have to modify dotext() in charproc.c.
 * Code conversion routines should be customize, too.
 */

#define	ESC_KANJI	"\033$B"	/* KANJI */
#define	ESC_ASCII	"\033(B"	/* ASCII */
#define	ESC_KANA	"\033(I"	/* KANA */

/*
 * Description of KANJI character set
 */
#define	KANJI_1_LOW	0x21	/* lower bound of 1st byte */
#define	KANJI_1_HIGH	0x73	/* higher bound of 1st byte */
#define	KANJI_2_LOW	0x21	/* lower bound of 2nd byte */
#define	KANJI_2_HIGH	0x7e	/* higher bound of 2nd byte */
/*
 * Default character in kanji : 0x2223 (filled squire)
 */
#define	KANJI_DEF_LOW	0x22	/* 1st byte of default char */
#define	KANJI_DEF_HIGH	0x23	/* 2nd byte of default char */
#define	ASCII_MODE	0
#define	KANJI_MODE	1
#define	KANA_MODE	2
