/* grX4.c -
 *
 * Copyright 1988 Regents of the University of California.
 * Permission to use, copy, modify, and distribute this
 * software (the graphics, textio, and windows modules of the Magic
 * system) and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.  
 *
 * This file contains functions to manage the graphics tablet associated
 * with the X display.
 *
 */

/**** Modifications by Dave Durfee and Markus G. Wloka
***** Copyright (C) 1987 Brown University		
****/

/**** Modifications by Marco Papa
***** Copyright (C) 1988 University of Southern California
****/


#ifndef lint
static char sccsid[] = "@(#)grX4.c	4.8 MAGIC (Berkeley) 814/85";
#endif	not lint

#include <sgtty.h>
#include <signal.h>
#include <stdio.h>
#include "magic.h"
#include "textio.h"
#include "geometry.h"
#include "graphics.h"
#include "windows.h"
#include "graphicsInt.h"
#include "txcommands.h"
#include "grXInt.h"
#include <X11/Xlib.h>
#include "grX11.h"



/*---------------------------------------------------------
 * GrXDisableTablet:
 *	Turns off the cursor.
 *
 *	...otherwise, the cursor messes up the X primitive drawing
 *	functions.  Mouse buttons are not unQ'd since that could lose
 *	mouse clicks, or, even worse, mouse button transitions.  (In
 *	the latter case, the mouse would be hung.)
 *
 * Results:	None.
 *
 * Side Effects:    None.
 *---------------------------------------------------------
 */

Void
GrXDisableTablet ()
{
}


/*---------------------------------------------------------
 * GrXEnableTablet:
 *	This routine enables the graphics tablet.
 *
 * Results:
 *	None.
 *
 * Side Effects:
 *	Simply turn on the crosshair.
 *---------------------------------------------------------
 */

Void
GrXEnableTablet ()
{
/* not implemented */
}


/*
 * ----------------------------------------------------------------------------
 * grxGetCursorPos:
 *	Read the cursor position in magic coordinates.
 *
 * Results:
 *	TRUE is returned if the coordinates were succesfully read, FALSE
 *	otherwise.
 *
 * Side effects:
 *	The parameter is filled in with the cursor position, in the form of
 *	a point in screen coordinates.
 * ----------------------------------------------------------------------------
 */

bool
grxGetCursorPos (p)
    Point *p;		/* point to be filled in with screen coordinates */
{
    int x, y;
    Window subw;
    Window rootwin;
    int rootx, rooty;
    unsigned int mask;

    XQueryPointer(display, grCurrent.window,
		&rootwin, &subw, &rootx, &rooty, &x, &y, &mask );
    p->p_x = x;
    p->p_y = grXToMagic( y );
    return true;
}


