/*
 * windCmdIRIS.c --
 *
 * Copyright 1988 Regents of the University of California.
 * Permission to use, copy, modify, and distribute this
 * software (the graphics, textio, and windows modules of the Magic
 * system) and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.  
 *
 * Commands developed at Stanford for the IRIS
 *
 */

#ifndef lint
static char sccsid[] = "@(#)CmdLQ.c	3.35 MAGIC (Berkeley) 4/5/85";
#endif  not lint

#include <stdio.h>
#include <signal.h>
#include "magic.h"
#include "geometry.h"
#include "tile.h"
#include "database.h"
#include "windows.h"
#include "main.h"
#include "textio.h"
#include "graphics.h"
#include "txcommands.h"


/*
 * ---------------------------------------------------------------------------
 *
 * windAddPath
 *
 * Implement the "addpath" command:  append to the global cell search path.
 *
 * Usage:
 *	addpath path
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	The search path used to find cells is appended to with the first
 *	command line argument.  See CmdLQ.CmdPath for more information.
 *
 * ---------------------------------------------------------------------------
 */

    /* ARGSUSED */

int
windAddPath( w, cmd )
    Window *w;
    TxCommand *cmd;
{
#define MAXLENGTH 500
    static char path[MAXLENGTH];
    extern char *strncpy();

    if( cmd->tx_argc != 2 ) {
	TxError( "Usage: %s appended_search_path\n", cmd->tx_argv[0] );
	return( 0 );
    }

    if( ( strlen( cmd->tx_argv[ 1 ] ) + strlen( Path ) ) >= MAXLENGTH ) {
	TxError("New path too long:  truncated to %d characters.\n",
	    MAXLENGTH);
    }

    strcpy( path, Path );
    strncat( path, cmd->tx_argv[ 1 ], MAXLENGTH - strlen( Path ) - 1 );
    path[MAXLENGTH-1] = 0;
    Path = path;

    return 0;
}
#ifdef IRIS

/*----------------------------------------------------------------------------
 *
 * windShell:
 *
 * Implement the "shell" command.
 * Issue a unix command to the current shell.
 *
 * Usage:
 *	shell unix_command
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	Whatever effects caused by the command to the shell.
 *
 *----------------------------------------------------------------------------
 */

windShell (w, cmd)
    Window *w;
    TxCommand *cmd;
{
    char *shell,
    	 *getenv();
    
    if( cmd->tx_argc != 1 ) {
	TxError( "Usage: %s\n", "shell" );
	return;
    }
    if( (shell = getenv( "SHELL" ) ) == (char *) NULL ) {
        TxError( "%s\n", "Not able to find shell, sorry" );
	return;
    }
    TxPrintf( "%s %s\n", "Invoking new shell.  ",
    			 "When done, type ^d to return to Magic..." );
    /* Turn Magic textport on and let new shell use it as stdout.
     */
    GrUnQKeyboard();
    GrTextportOn();
    TxResetTerminal();
    if( system( shell ) == -1 ) {
	fprintf( stderr, "Unable to invoke new shell, sorry.\n");
    }
    TxSetTerminal();
    GrTextportOff();
    GrQKeyboard();
    TxPrintf( "%s\n", "Continuing Magic..." );
}
#endif


