/* pbmtoascii.c - read a portable bitmap and produce ASCII graphics
**
** Copyright (C) 1988 by Jef Poskanzer.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include <stdio.h>
#include "pbm.h"

main( argc, argv )
int argc;
char *argv[];
    {
    FILE *ifd;
    bit **bits;
    int rows, cols, row, col, lastcol;

    if ( argc > 2 )
	{
	fprintf( stderr, "usage:  %s [pbmfile]\n", argv[0] );
	exit( 1 );
	}

    if ( argc == 2 )
	{
        ifd = fopen( argv[1], "r" );
        if ( ifd == NULL )
	    {
	    fprintf( stderr, "%s: can't open.\n", argv[1] );
	    exit( 1 );
	    }
	}
    else
	ifd = stdin;

    bits = pbm_readpbm( ifd, &cols, &rows );

    if ( ifd != stdin )
	fclose( ifd );
    
    /* Write out rows by twos. */
    for ( row = 0; row < rows; row += 2 )
	{
	/* Find end of lines. */
	for ( lastcol = cols-1; lastcol > 0; lastcol-- )
	    {
	    if ( bits[row][lastcol] )
		break;
	    if ( row+1 < rows && bits[row+1][lastcol] )
		break;
	    }
        for ( col = 0; col <= lastcol; col++ )
	    {
	    if ( ! bits[row][col] )
		{
		if ( row+1 >= rows || ! bits[row+1][col] )
		    putchar( ' ' );
		else
		    putchar( 'o' );
		}
	    else
		{
		if ( row+1 >= rows || ! bits[row+1][col] )
		    putchar( '"' );
		else
		    putchar( '$' );
		}
	    }
	putchar( '\n' );
        }

    exit( 0 );
    }
