/* pbmtoptx.c - read a portable bitmap and produce a Printronix printer file
**
** Copyright (C) 1988 by Jef Poskanzer.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include <stdio.h>
#ifdef	OS_SYSV
#include <string.h>
#else	OS_SYSV
#include <strings.h>
#endif	OS_SYSV
#include "pbm.h"

main( argc, argv )
int argc;
char *argv[];
    {
    FILE *ifd;
    bit **bits;
    int rows, cols, row, col;
    char *usage = "usage:  %s [pbmfile]\n";

    if ( argc > 2 )
	{
	fprintf( stderr, usage, argv[0] );
	exit( 1 );
	}

    if ( argc == 2 )
	{
        ifd = fopen( argv[1], "r" );
        if ( ifd == NULL )
	    {
	    fprintf( stderr, "%s: can't open.\n", argv[1] );
	    exit( 1 );
	    }
	}
    else
	ifd = stdin;

    bits = pbm_readpbm( ifd, &cols, &rows );

    if ( ifd != stdin )
	fclose( ifd );
    
    putinit( );
    for ( row = 0; row < rows; row++ )
	{
	putchar( 5 );
        for ( col = 0; col < cols; col++ )
	    putbit( bits[row][col] );
	putrest( );
	putchar( '\n' );
        }

    exit( 0 );
    }


char item;
int bitsperitem, bitshift;

putinit( )
    {
    bitsperitem = 0;
    item = 64;
    bitshift = 0;
    }

putbit( b )
bit b;
    {
    if ( bitsperitem == 6 )
	putitem( );
    if ( b )
	item += 1 << bitshift;
    bitsperitem++;
    bitshift++;
    }

putrest( )
    {
    if ( bitsperitem > 0 )
	putitem( );
    }

putitem( )
    {
    putchar( item );
    bitsperitem = 0;
    item = 64;
    bitshift = 0;
    }
