/* pbmtox10wd.c - read a portable bitmap and produce an X10 window dump
**
** Copyright (C) 1988 by Jef Poskanzer.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include <stdio.h>
#ifdef	OS_SYSV
#include <string.h>
#else	OS_SYSV
#include <strings.h>
#endif	OS_SYSV
#include "pbm.h"
#include "x10wd.h"

main( argc, argv )
int argc;
char *argv[];
    {
    FILE *ifd;
    bit **bits;
    int rows, cols, padright, row, col;
    char name[100], *cp;

    if ( argc > 2 )
	{
	fprintf( stderr, "usage:  %s [pbmfile]\n", argv[0] );
	exit( 1 );
	}

    if ( argc == 2 )
	{
        ifd = fopen( argv[1], "r" );
        if ( ifd == NULL )
	    {
	    fprintf( stderr, "%s: can't open.\n", argv[1] );
	    exit( 1 );
	    }
	strcpy( name, argv[1] );

#ifdef	OS_SYSV
	if ( ( cp = strchr( name, '.' ) ) != 0 )
#else	OS_SYSV
	if ( ( cp = index( name, '.' ) ) != 0 )
#endif	OS_SYSV
	    *cp = '\0';
	}
    else
	{
	ifd = stdin;
	strcpy( name, "noname" );
	}

    bits = pbm_readpbm( ifd, &cols, &rows );

    if ( ifd != stdin )
	fclose( ifd );
    
    /* Compute padding to round cols up to the nearest multiple of 16. */
    padright = ( ( cols + 15 ) / 16 ) * 16 - cols;

    putinit( cols, rows, name );
    for ( row = 0; row < rows; row++ )
	{
        for ( col = 0; col < cols; col++ )
	    putbit( bits[row][col] );
	for ( col = 0; col < padright; col++ )
	    putbit( 0 );
        }
    putrest( );

    exit( 0 );
    }


short item;
int bitsperitem, bitshift;


putinit( cols, rows, name )
int cols, rows;
char *name;
    {
    X10WDFileHeader h10;

    h10.header_size = sizeof(h10) + (strlen(name) + 1) * sizeof(char);
    h10.file_version = X10WD_FILE_VERSION;
    h10.display_type = -1;		/* random number */
    h10.display_planes = 1;
    h10.pixmap_format = XYFormat;
    h10.pixmap_width = cols;
    h10.pixmap_height = rows;
    h10.window_width = cols;
    h10.window_height = rows;
    h10.window_x = 0;			/* arbitrary */
    h10.window_y = 0;			/* likewise */
    h10.window_bdrwidth = 0;
    h10.window_ncolors = 0;

    fwrite( &h10, sizeof(h10), 1, stdout );
    fwrite( name, sizeof(char), strlen(name) + 1, stdout );

    item = 0;
    bitsperitem = 0;
    bitshift = 0;
    }

putbit( b )
bit b;
    {
    if ( bitsperitem == 16 )
	putitem( );
    bitsperitem++;
    if ( ! b )
	item += 1 << bitshift;
    bitshift++;
    }

putrest( )
    {
    if ( bitsperitem > 0 )
	putitem( );
    }

putitem( )
    {
    fwrite( &item, sizeof(item), 1, stdout );
    item = 0;
    bitsperitem = 0;
    bitshift = 0;
    }
