/*
 * Copyright 1988 Anant Agarwal
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied 
 * warranty.
 *
 * Author:  Anant Agarwal, MIT Laboratory for Computer Science
 */


#include <strings.h>	
#include <stdio.h>
#include <math.h>
#include "defs.h"
#include "structs.h"

public int lineno=1;
public double CMPT;
public   graphtype graph;
/*public   curvetype curves[MAXCURVES];*/
public   curvetype *curves[MAXCURVES];
public   axistype axis[PAIR];
public 	 tictype tics[MAXTICS * MAXTICSM];
/*public   texttype text[MAXCURVES];*/
public   texttype *text[MAXCURVES];
/*public LocalObjectType obj[MAXOBJECTS];*/
public LocalObjectType *obj[MAXOBJECTS];
public int curobj;/* index to first empty object slot */
public int curcur = -1;/* index to current curve *//* start by incrementing */
public int curtext = -1;/* index to current text *//* start by incrementing */
public int curtic = 0;/* index to current ticmark */
public int Xtics = 0;/* index to current ticmark */
public boolean MinticNos;/* whether to print minor tic numbers */
public boolean ShowMinTics;/* whether to print minor tics */
public double NoConfInterval = 0.0; /* no conf interval for this point */

public int majorticfont;
public int minorticfont;
public double numberBelowXAxis;
public double titleBelowXAxis;
public double spaceBetKeys;
public double translate;
/* offset from page corner to axes intersection in pts */
public double numberLeftYAxis;
public double labelBelowXAxis;
public double labelLeftYAxis;
public double NumberBelowYMinorTic;
public double  keylinewidth;
public double icontotext;
public double dummy; 
/* defined to be one. Assigned to vars about to be scaled
		to prevent log scaling from screaming */
public double defnumints;/* def number of intervals */
/* defaults */
public double boldthickmul;
public int defGraphFont;
public double defFillGray;
public int defGraphKeyFont;
public int defSymbolSize;
public int defTextFont;
public double defGraphThick;
public int DefBarThickMul;
public double DefAxisGray;
public double DefCurFont;
public double defAxisThick;
public double defGraphXsize;
public double defGraphYsize;
public int defAxisFont;
public int SuScriptSm;
public double SupAboveText;
public double SubBelowText;
public double keySpacingMul;
public double textBelowIcon;
public double gs;/* graph font to symbol font scale */
public double xpress = 1.0;
public double ypress = 1.0;
public double xtranslate = 0.0;/*only for use by psf */
public double ytranslate = 0.0;/*only for use by psf */
public int doc = 0;
public boolean ShowXNos = TRUE;/* do not show axis nos */
public boolean ShowYNos = TRUE;
public boolean ShowXLine = TRUE;/* do not show axis Line */
public boolean ShowYLine = TRUE;
public boolean ShowAxes = TRUE;/* do not show axes, nos, tics, labels */
public boolean MirrorAxes = FALSE;
public boolean NewOrigin = FALSE;/* if true the axes must be shifted */
public double FracDownMirror = 0.35;
/* this number must be multiplied with numberBelowXAxis to get number*/
/*above Mirrored X axis. It simply removes charheight from the number. */
/* Similarly, for labelBelowXAxis */
/*Note, text in PostScript is represented bottom left corner */
public boolean MirrorAxisNumbers = FALSE;
public boolean MirrorAxisLabels = FALSE;
public boolean landscape = FALSE;
public int XView = 0;
public int IView = 0;
public int IDrawEdit = 0;
public int XGray = 1;

public char Greek[] = "Symbol";/* Greek characters */
public char ticmark[] = "|";
public char Phelvetica[] =  "Helvetica";
public char PhelveticaItalics[] =  "Helvetica-Oblique";
public char PhelveticaBold[] =  "Helvetica-Bold";
public char PhelveticaBoldItalics[] =  "Helvetica-BoldOblique";
public char Ptimesroman[] =  "Times-Roman";
public char PtimesromanItalics[] =  "Times-Italics";
public char PtimesromanBold[] =  "Times-Bold";
public char PtimesromanBoldItalics[] =  "Times-BoldItalics";

/*returns ptr to postscript font given fontnumber*/
public char *FF(fntnum)
int fntnum;
{
	if ((fntnum >= helveticamin)&&(fntnum <= helveticamax))
		return(Phelvetica);
	else if ((fntnum >= helveticabmin)&&(fntnum <= helveticabmax))
		return(PhelveticaBold);
	else if ((fntnum >= helveticaimin)&&(fntnum <= helveticaimax))
		return(PhelveticaItalics);
	else if ((fntnum >= helveticabimin)&&(fntnum <= helveticabimax))
		return(PhelveticaBoldItalics);
	else if ((fntnum >= timesromanmin)&&(fntnum <= timesromanmax))
		return(Ptimesroman);
	else if ((fntnum >= timesromanbmin)&&(fntnum <= timesromanbmax))
		return(PtimesromanBold);
	else if ((fntnum >= timesromanimin)&&(fntnum <= timesromanimax))
		return(PtimesromanItalics);
	else if ((fntnum >= timesromanbimin)&&(fntnum <= timesromanbimax))
		return(PtimesromanBoldItalics);
	else
	{
		fprintf(stderr,"splot:: Error, strange font. Using default\n");
		return(Phelvetica);
	}
}

/* ALL IN POINTS */
private int FFsizeArr[] = {
3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,
3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30
};
public int FFsize(fntnum)
int fntnum;
{
	return(FFsizeArr[fntnum % FBS]); /* %FBS gives num between 0 and 55 */
}

private double FFthickArr[] = {
.05,.1,.15,.2,.4,.6,.8,1.0,1.2,1.4,1.6,1.8,2.0,2.2,
2.4,2.6,2.8,3.0,3.2,3.4,3.6,3.8,4.0,4.2,4.4,4.6,4.8,5.0,
.1,.2,.3,.4,.8,1.2,1.6,2.0,2.4,2.8,3.2,3.6,4.0,4.4,4.8,
5.2,5.6,6.0,6.2,6.4,6.6,6.8,7.0,7.2,7.4,7.6,7.8,8.0
};
public double FFthick(fntnum)
int fntnum;
{
	return(FFthickArr[fntnum % FBS]);
}

private double FFaxisthickArr[] = {
1.0,1.0,1.0,1.0,1.0,1.0,1.0,2.0,2.0,2.0,2.0,
2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,
1.0,1.0,1.0,1.0,1.0,1.0,1.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,
2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0,2.0
};
public double FFaxisthick(fntnum)
int fntnum;
{
	return(FFaxisthickArr[fntnum % FBS]);
}

private int FFheightArr[] = {
3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,
3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30
};
public int FFheight(fntnum)
int fntnum;
{
	return(FFheightArr[fntnum % FBS]);
}

private int FFwidthArr[] = {
1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,
1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15
};
public int FFwidth(fntnum)
int fntnum;
{
	return(FFwidthArr[fntnum % FBS]);
}



FILE *fin, *fout, *fps;
String infile, outfile, psfile;
