/*
 * Copyright 1988 Anant Agarwal
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied 
 * warranty.
 *
 * Author:  Anant Agarwal, MIT Laboratory for Computer Science
 */


#include <strings.h>	
#include <stdio.h>
#include <math.h>
#include "plotio.h"
#include "defs.h"
#include "structs.h"
#include "plot.h"


extern double getdegrees(), atan(), charheight(),charwidth(),log10(),mylog();


main(argc,argv)
int argc;
char *argv[];
{
	getswitches(argc, argv);

	if ((XView == 0) && (IView == 0)) prologue();
	init();/* init all structures and global flags */
	yyparse();/* structures now filled up */
	init2();/*inits input dependent constants */
	printkey();/* typically, procedure names preceded by print are called
		only from plotmain */
	printcurves();

	/* axes and tics after curves because in fill mode we want
		the axes and tics to not be obscured by fill */
	printtics(xpt);
	printtics(ypt);
	printEnterTicsIntoObj();	
	printaxes();
	printtext();/* text put last because it must appear above
		filled curves or key blanker */

	sendobj();
	if ((XView == 0) && (IView == 0)) epilogue();
	else if (XView) x();
	else if (IView) i();
}


printcurves()
{
int c;/* current curve */

	/* first send flag that curves are starting */
	(obj[curobj])->name = objflagcurves;
	GetNewObjcurobj();


	CurveSeqStart();
	c = 0;
	while ((curves[c] != nil) && ((curves[c])->validcurve))
	{
		if ((curves[c])->include)
		{
		    switch ((curves[c])->interp)
		    {
			case smooth:
			case linearinterp: curlin(c); break;
			case lregression: regression(c); break;
			case step: curstep(c); break;
			case xhistogram: curxhis(c); break;
			case yhistogram: curyhis(c); break;
			default : fprintf(stderr,"printcurves: interpolation not known, linear used\n");
				curlin(c);break;
		    }
		    if ((curves[c])->showConf) EnterConf(c);
		}
		c++;
	}
	(obj[curobj])->name = objflag;/* curves ending */
	GetNewObjcurobj();
}



yyerror(s)
char *s;
{
	fprintf(stderr,"***splot::%s near line %d\n",s, lineno);
}


init()
{
int i;
	inithash();
	curobj = -1;
	GetNewObjcurobj();
	MinticNos = TRUE;
	ShowMinTics = TRUE;
	CMPT = 72 / 2.54;
	graphsize[xpt] = 7.0 * 2.54;
	graphsize[ypt] = 7.0 * 2.54;
	origin[xpt] = 0.0;
	origin[ypt] = 0.0;
	majorticfont = helvetica10b;
	minorticfont = helvetica7;
 	defGraphFont = helvetica12;
	defSymbolSize = 2;
	defFillGray = 0.7;
	defTextFont = helvetica10;
	defGraphKeyFont = helvetica9;
	boldthickmul = 1.2;
	keySpacingMul = 1.3; /*change in plotkey.c because of histograms */
	DefBarThickMul = 12;/*times curves[].thick gives bar thick */
	DefAxisGray = 0.0; /*black*/
	defAxisThick = 2;
	defGraphThick = 1;
	defAxisFont = helvetica10b;
	DefCurFont = helvetica10b;
	defGraphXsize = 7.0;
	defGraphYsize = 7.0;
	SuScriptSm = 4;/*fontsize 3pts smaller for subscripts */
	SupAboveText = 0.25;/*fraction of height of base char up */
	SubBelowText = -0.25;/*fraction of height of base char below */
	icontotext = 0.3;/* cms */
	keylinewidth = 1.0;/* 1cm worth of points*/
	dummy = 1.0;
}

init2()
{
/*	also try to check a little if graph is generally OK */
	numberBelowXAxis = 1.2 * charheight(axis[xpt].font);
	numberLeftYAxis =  1.0 * charwidth(axis[ypt].font);
	labelBelowXAxis =  2.5 * 0.5 * charheight(axis[xpt].font) +
		2.5 * 0.5 * charheight(graph.font);
	labelLeftYAxis =   5.5 * charwidth(axis[ypt].font) +
		0.6 * charwidth(graph.font);
	titleBelowXAxis = 4.4 * charheight(graph.font);
	spaceBetKeys = 1.0 * charheight(graph.font);
	NumberBelowYMinorTic = 0.3 * charheight(graph.font);
	textBelowIcon = 0.3 * charheight(graph.keyfont);
	gs = 0.6;

	translate = 1.0 * 72.0;
/*do not use scale[] anymore because axis[].scale itself used */
/*	scale[xpt].type = axis[xpt].scale.type;
	scale[ypt].type = axis[ypt].scale.type;
	scale[xpt].base = axis[xpt].scale.base;
	scale[ypt].base = axis[ypt].scale.base;
*/

	/* first modulo by FBS to convert to basic helvetica */
	/* this way avoid italic tics ! */
	/* the modulo operation brings any font to helvmin through helvmaxB*/
	majorticfont = (graph.font % FBS) + helveticamin;
	if (majorticfont >= helvetica9b) 
		minorticfont = majorticfont - 3;
	else if ((majorticfont <= helvetica12 )&&(majorticfont >= helvetica9))
		minorticfont = majorticfont - 3;
	else 
		minorticfont = helvetica6;


	defnumints = 10.0;/* may be reset in plotmath by CallDefLimits */
	calcmaxmin(xpt);/* interval also */
	calcmaxmin(ypt);
	Check();
}

Check()
{
int i=0;
  /* curves */
  if (limits[xpt][minval] == limits[xpt][maxval])
  {
	fprintf(stderr,
	  "splot error: Only one or less values on X, specify axis limits\n");
	limits[xpt][maxval] += 1.0;
  }
  if (limits[ypt][minval] == limits[ypt][maxval])
  {
	fprintf(stderr,
          "splot error: Only one or less values on Y, specify axis limits\n");
	limits[ypt][maxval] += 1.0;
  }
  if ((graph.size[xpt] == 0)||(graph.size[ypt] == 0))
  {
	fprintf(stderr,"splot error: Zero graph size?\n");
	if (graph.size[xpt] == 0) graph.size[xpt] = 6.0;
	if (graph.size[ypt] == 0) graph.size[ypt] = 6.0;
  }
  if (axis[xpt].interval == 0)
  {
	fprintf(stderr,
 	  "splot error: Could not choose X interval, please set it\n");
	axis[xpt].interval = 10;
  }
  if (axis[ypt].interval == 0)
  {
	fprintf(stderr,
	  "splot error: Could not choose Y interval, please set it\n");
	axis[xpt].interval = 10;
  }

  while (curves[i] != nil)
  {
 	if ((curves[i])->lastpoint == -1)
	{
	  fprintf(stderr,
	    "Splot error: No points in curve %d, label: %s\n",i+1,(curves[i])->label);
	  (curves[i])->include = FALSE;
	}
	i++;
  }
}
