/*
 * Copyright 1988 Anant Agarwal
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied 
 * warranty.
 *
 * Author:  Anant Agarwal, MIT Laboratory for Computer Science
 */

#include <strings.h>	
#include <stdio.h>
#include <math.h>
#include "plotio.h"
#include "defs.h"
#include "structs.h"
#include "plot.h"

extern double xpress, ypress, xtranslate, ytranslate;
extern boolean landscape;
extern int doc;
extern String infile, outfile, psfile;
extern FILE *fout, *fin, *fps;
extern FILE *yyin; /*lex*/
String PgName = "splot";
String defpsfile = "/usr/local/lib/splot/splot.ps";
extern double atof();

getswitches(argc, argv)
int argc;
char **argv;
{
    register int i, j;

#define USAGEMSG							   \
    {									   \
        fprintf(stderr,	"USAGE: %s [-?] [-cx scaleX] [-cy scaleY] [-tx translateX] [-ty translateY] [-d] [-L] [-o outfile.psf] [-a outfile.psf] [-d] [-x] [-i] [-e] [-g] [-p psfile] [infile]\n", PgName);  		\
	fprintf(stderr,"?: help\n");					\
	fprintf(stderr,"cx,cy: scale in X and Y\n");			\
	fprintf(stderr,"tx,ty: translate in x and y \n");		\
	fprintf(stderr,"d: include in document\n");			\
	fprintf(stderr,"x: view under X on tty\n");			\
	fprintf(stderr,"i: view under Interviews on tty\n");		\
	fprintf(stderr,"e: write Interviews edit file\n");		\
	fprintf(stderr,"g: no gray levels on tty\n");			\
	fprintf(stderr,"L: Landscape mode\n");				\
	fprintf(stderr,"o: output psf file. stdout default\n");		\
	fprintf(stderr,"a: append to psf file.\n");			\
	fprintf(stderr,"p: take specified PostScript preamble file\n");	\
	fprintf(stderr,"Input from stdin, if infile not specified\n");	\
    	exit(1);							   \
    }

#define HELPMSG								   \
    {									   \
        fprintf(stderr,	"USAGE: %s [-?] [-cx scaleX] [-cy scaleY] [-tx translateX] [-ty translateY] [-d] [-L] [-o outfile.psf] [-a outfile.psf] [-d] [-x] [[-i] [-e] -g]  [-p psfile] [infile]\n", PgName);  		\
	fprintf(stderr,"?: help\n");					\
	fprintf(stderr,"cx,cy: scale in X and Y\n");			\
	fprintf(stderr,"tx,ty: translate in x and y \n");		\
	fprintf(stderr,"d: include in document\n");			\
	fprintf(stderr,"x: view under X on tty\n");			\
	fprintf(stderr,"i: view under Interviews on tty\n");		\
	fprintf(stderr,"e: write Interviews edit file\n");		\
	fprintf(stderr,"g: no gray levels on tty\n");			\
	fprintf(stderr,"L: Landscape mode\n");				\
	fprintf(stderr,"o: output psf file. stdout default\n");		\
	fprintf(stderr,"a: append to psf file.\n");			\
	fprintf(stderr,"p: take specified PostScript preamble file\n");	\
	fprintf(stderr,"Input from stdin, if infile not specified\n");	\
    }

   xpress = 1.0;
   ypress = 1.0;
   xtranslate = 0.0;
   ytranslate = 0.0;
   doc = 0 ;
   landscape = FALSE;
   fout = stdout; /* io defaults */
   fin = stdin; yyin = fin;
   psfile = defpsfile;

    for (i = 1; i < argc; i ++)
        if (argv[i][0] == '-')
	{
	    j = 1;
	    if (argv[i][j] == '\0') USAGEMSG;
	    while(argv[i][j] != '\0')
		if (argv[i][j] == 'h')
		{
			HELPMSG;
			j++;
			continue;
		}
		else if (argv[i][j] == 'o')
		{
		    if (i >= argc - 1)
		        USAGEMSG;
		    outfile = argv[i+1];
		    if ((fout = fopen(outfile,"w")) == NULL)
		    {
			fprintf(stderr,"%s: cannot open outputfile %s\n",
				PgName, outfile);
			exit(1);
		    }
		    i ++;
		    break;
		}
		else if (argv[i][j] == 'a')
		{
		    if (i >= argc - 1)
		        USAGEMSG;
		    if ((fout = fopen(outfile,"a")) == NULL)
		    {
			fprintf(stderr,"%s: cannot open outputfile %s\n",
				PgName, argv[i+1]);
			exit(1);
		    }
		    i ++;
		    break;
		}
		else if ((argv[i][j] == 'c')&&(argv[i][j+1] == 'x'))
		{
		    if (i >= argc - 1)
		        USAGEMSG;
		    xpress = atof(argv[i+1]);
		    i ++;
		    break;
		}
		else if ((argv[i][j] == 'c')&&(argv[i][j+1] == 'y'))
		{
		    if (i >= argc - 1)
		        USAGEMSG;
		    ypress = atof(argv[i+1]);
		    i ++;
		    break;
		}
		else if ((argv[i][j] == 't')&&(argv[i][j+1] == 'x'))
		{
		    if (i >= argc - 1)
		        USAGEMSG;
		    xtranslate = atof(argv[i+1]);
		    i ++;
		    break;
		}
		else if ((argv[i][j] == 't')&&(argv[i][j+1] == 'y'))
		{
		    if (i >= argc - 1)
		        USAGEMSG;
		    ytranslate = atof(argv[i+1]);
		    i ++;
		    break;
		}
		else if (argv[i][j] == 'd')
		{
			doc = 1;
			j++;
			continue;
		}
		else if (argv[i][j] == 'x')
		{
			XView = 1;
			j++;
			continue;
		}
		else if (argv[i][j] == 'i')
		{
			IView = 1;
			j++;
			continue;
		}
		else if (argv[i][j] == 'e')
		{
			IDrawEdit = 1;
			j++;
			continue;
		}
		else if (argv[i][j] == 'g')
		{
			XGray = 0;
			j++;
			continue;
		}
		else if (argv[i][j] == 'L')
		{
			landscape = TRUE;
			j++;
			continue;
		}
		else if (argv[i][j] == 'p')
		{
		    if (i >= argc - 1)
		        USAGEMSG;
		    psfile = argv[i+1];
		    /* open file in plotproepi after checking if necessary */
		    i ++;
		    break;
		}
		else
		{
		    fprintf(stderr, "%s: Unknown flag '%c'\n",
			    PgName, argv[i][j]);
		    USAGEMSG;
		}
	}
        else /*if does not begin with -, must be inputfile */
        {
		    infile = argv[i];
		    if ((fin = fopen(infile,"r")) == NULL)
		    {
			fprintf(stderr,"%s: cannot open inputfile %s\n",
				PgName, infile);
			exit(1);
		    }
		    yyin = fin;
        }
}


