'	# month name
.tr ~\(ap
.if "\nd"0" .nr m \n(mo-1
.if "\nm"0" .ds ]m January
.if "\nm"1" .ds ]m February
.if "\nm"2" .ds ]m March
.if "\nm"3" .ds ]m April
.if "\nm"4" .ds ]m May
.if "\nm"5" .ds ]m June
.if "\nm"6" .ds ]m July
.if "\nm"7" .ds ]m August
.if "\nm"8" .ds ]m September
.if "\nm"9" .ds ]m October
.if "\nm"10" .ds ]m November
.if "\nm"11" .ds ]m December
'	# set the date
.if n \{.nr m \nm+1
.	 ie \nd .ds ]W Modified \nm/\nd/\ny
.	 el .ds ]W Printed \n(mo/\n(dy/\n(yr\}
.if t \{.ie \nd .ds ]W \*(]m \nd, 19\ny
.	 el .ds ]W \*(]m \n(dy, 19\n(yr\}
.de UC
.if t .ds ]W Stanford University
..
'	# reset the basic page layout
.de }E
.}f
.in \\n()Ru+\\n(INu
.ll \\n(LLu
..
'	# default tabs
.de DT
'ta .5i 1i 1.5i 2i 2.5i 3i 3.5i 4i 4.5i 5i 5.5i 6i 6.5i
..
'	# set type font and size
.de }f
.ps 10
.ft 1
..
'	# handle the head of the page
.de }H
.ev 1
.}C
'sp .5i
.ft 1
.ps 10
.tl @\\*(]H@\\*(]D@\\*(]H@
'sp .5i
.ev
.ns
..
'	# handle the foot of the page
.de }F
.ev 1
.ft 1
.ps 10
'sp .5i
.tl @\\*(]W@\\*(]L@%@
'bp
.ev
..
'	# the cut mark
.if n .ig
.de }C
.po .1i
.tl '-'
.po
..
'	# the final cut mark
.de }M
.}N
.wh -1p }C
.ll \\n(LLu
..
'	# no runout unless there was a .TH
.de }K
.}N
.pl 1
.ll \\n(LLu
..
.em }K
'	# section heading
.de SH
.}X 0
.nr )E 2
\&\\$1 \|\\$2 \|\\$3 \|\\$4 \|\\$5 \|\\$6
..
'	# sub section heading
.de SS
.}X \\n()Ru+\\n(INu
\&\\$1 \|\\$2 \|\\$3 \|\\$4 \|\\$5 \|\\$6
.br
..
'	# subroutine for section heading
.de }X
.}E
.ti \\$1
.sp \\n()Pu
.ne 2
.nr )R 0
.fi
.it 1 }N
.SM
.B
..
'	# end of SH (cf }X above and }N below)
.de }2
.nr )E 0
.}E
.nr )I .5i
.ns
..
'	# italic
.de I
.ft 2
.it 1 }N
.if !"\\$1"" \&\\$1 \\$2 \\$3 \\$4 \\$5 \\$6
..
'	# bold
.de B
.ft 3
.it 1 }N
.if !"\\$1"" \&\\$1 \\$2 \\$3 \\$4 \\$5 \\$6
..
'	# small
.de SM
.ps 9
.it 1 }N
.if !"\\$1"" \&\\$1 \\$2 \\$3 \\$4 \\$5 \\$6
..
'	# combinations of Roman, italic, bold
.de RI
.}S 1 2 \& "\\$1" "\\$2" "\\$3" "\\$4" "\\$5" "\\$6"
..
.de RB
.}S 1 3 \& "\\$1" "\\$2" "\\$3" "\\$4" "\\$5" "\\$6"
..
.de IR
.}S 2 1 \& "\\$1" "\\$2" "\\$3" "\\$4" "\\$5" "\\$6"
..
.de IB
.}S 2 3 \& "\\$1" "\\$2" "\\$3" "\\$4" "\\$5" "\\$6"
..
.de BR
.}S 3 1 \& "\\$1" "\\$2" "\\$3" "\\$4" "\\$5" "\\$6"
..
.de BI
.}S 3 2 \& "\\$1" "\\$2" "\\$3" "\\$4" "\\$5" "\\$6" "\\$7" "\\$8"
..
'	# make special case of shift out of italic
.de }S
.ds ]F
.if "\\$1"2" .if !"\\$5"" .ds ]F\^
.ie !"\\$4"" .}S \\$2 \\$1 "\\$3\f\\$1\\$4\\*(]F" "\\$5" "\\$6" "\\$7" "\\$8" "\\$9"
.el \\$3
.}f
..
'	# paragraph
.de LP
.PP
..
.de PP
.sp \\n()Pu
.ne 2
.}E
.nr )I .5i
.ns
..
'	# paragraph distance
.de PD
.if t .nr )P .4v
.if n .nr )P 1v
.if !"\\$1"" .nr )P \\$1v
..
'	# hanging indent
.de HP
.sp \\n()Pu
.ne 2
.if !"\\$1"" .nr )I \\$1n
.ll \\n(LLu
.in \\n()Ru+\\n(INu+\\n()Iu
.ti \\n()Ru+\\n(INu
.}f
..
'	# indented paragraph
.de IP
.TP \\$2
\&\\$1
..
'	# hanging label
.de TP
.if !"\\$1"" .nr )I \\$1n
.sp \\n()Pu
.in \\n()Ru
.nr )E 1
.ns
.it 1 }N
.di ]B
..
'	# end of TP (cf }N below)
.de }1
.ds ]X \&\\*(]B\\
.nr )E 0
.if !"\\$1"" .nr )I \\$1n
.}f
.ll \\n(LLu
.in \\n()Ru+\\n(INu+\\n()Iu
.ti \\n(INu
.ie !\\n()Iu+\\n()Ru-\w@\\*(]X@u-3p \{\\*(]X
.br\}
.el \\*(]X\h@|\\n()Iu+\\n()Ru@\c
.}f
..
'	# handle end of 1-line features
.de }N
.if \\n()E .br
.di
.if "\\n()E"0" .}f
.if "\\n()E"1" .}1
.if "\\n()E"2" .}2
.nr )E 0
..
'	# increase relative indent
.de RS
.nr ]\\n+()p \\n()I
.nr )\\n()p \\n()R
.ie !"\\$1"" .nr )R +\\$1n
.el .nr )R +\\n()I
.nr )I .5i
.}E
..
'	# decrease relative indent
.de RE
.if !"\\$1"" \{.ie "\\$1"0" .nr )p 1 1
.		el .nr )p \\$1 1\}
.ds ]i \\*(]I\\n()p
.ds ]r \\*(]R\\n()p
.nr )I \\*(]i
.nr )R \\*(]r
.if \\n()p .nr )p -1
.}E
..
.nr )p 0 1
.ds ]I \\\\n(]
.ds ]R \\\\n()
.bd S 3 3
.if t .ds R \(rg
.if n .ds R (Reg.)
.ds S \s10
.hy 14
'	# set title and heading
.de TH
.if t .ds ]W 1986 VLSI Tools Distribution
.PD
.if n .nr IN .5i
.if t .nr IN .5i
.nr LL \\n(.l
.ds ]H \\$1\|(\|\\$2\|)
.ds ]D UNIX Programmer's Manual
.wh 0 }H
.if t .wh -1i }F
.if n .wh -1.167i }F
.em }M
.if \\n(nl .bp 1
.ds ]L \\$3
.}E
.DT
.nr )I .5i
.nr )R 0
.if n .na
..
.TH SPLOT 1 1/6/86
.UC 4
.SH NAME
splot \- plot utility for PostScript and X
.PP
.SH SYNOPSIS
.B splot
[-a outfile] [-cx scaleX] [-cy scaleY] [-degiL][-o outfile] [-p psfile] 
[-tx translateX] [-ty translateY] [-x] infile
.PP
.SH DESCRIPTION
.I Splot
takes a plot command file infile, or accepts input 
commands from standard input, and writes PostScript formatted plots to 
standard output. Plots can also be previewed in the X
environment.
.PP
.I Splot 
input file format is similar to that accepted by 
.I plot
(written by Ivor Durham at CMU). 
.I Plot
files can be input to 
.I splot 
with possible minor modifications. Features of 
.I splot
are described in detail further on.
.I Splot
includes line curves of various patterns, symbols, X and Y
histograms, automatic key generation, log and linear scaled axes, 
integer, floating, scientific
and exponent axes numberstyles, curve and axes labels,
linear regression, curve smoothing, inclusion of text, basic understanding of 
subscripts, superscripts and greek text, and landscape or portrait mode.
In addition, 
.I splot
has gray levels for curves and
and painting screens  for filled
curves, log axes limits not necessarily a multiple of the interval, 
text rotation and alignment, optional
axes numbers, or minor tic numbers in log scale, options to 
help create plots with double y axes,  sophisticated default
axes limits and interval selection, graph compression or expansion, and
graph translation in X or Y.
.PP
A command of the form:
.nf
	splot infile > outfile.psf
.fi
reads a plot description from infile and writes out a PostScript file.
.nf
	splot -x infile
.fi
previews the graph under the X environment.
.PP
.SH ARGUMENTS
.I Splot
recognizes several command line options.
These can be used to change the size and scale of the plot,
change default plot options, or the output medium.
The following is a list of options that may be included on
the command line:
.TP
.BI \-a " outfile "
Append PostScript output to file outfile.
.TP
.BI \-cx " scaleX "
Compress PostScript output by 
.I scaleX
factor along X axis.
.TP
.BI \-cy " scaleY "
Compress PostScript output by 
.I scaleY
factor along Y axis.
.TP
.BI \-d 
Exclude PostScript preamble file. By inhibiting the printing 
of the PostScript preamble, PostScript output file is more 
compact. Useful if you are including this plot in a document.
Remember to include the preamble, splot.ps, if you want to
print this document.
.TP
.BI \-g
Turn off gray levels. All gray levels are "rounded" off to
either white or black. 
.TP
.BI \-L
Plot PostScript file in landscape mode.
.TP
.BI \-o " outfile "
Write PostScript output to file 
.I outfile.
Default is standard output.
.TP
.BI \-p " psfile "
Takes the specified PostScript preamble file instead of the
standard one, 
.BI splot.ps
from /usr/local/lib/splot.
.TP
.BI \-tx " translateX "
Translate by 
.I translateX
inches in X direction.
.TP
.BI \-ty " translateY "
Translate by 
.I translateY
inches in Y direction.
.TP
.BI \-x
Preview in the X environment.
.PP
.SH INPUT FILE FORMAT
A 
.BI splot
input file contains specifications for one or more curves and 
overall graph specifications, such as graph size and fonts, and axis
specifications such as axis interval.
In the following description of the input format, italicised (underlined)
text represents input substituted by the user.
Most of the specifications here are usually not needed since 
reasonable defaults are chosen in most places.
Splot is not case sensitive. Also, see examples given later.
First, general graph parameters are described, followed by curve and text
parameters, and then axes parameters.
.ns
.HP 5
.B New graph
.br
Starts a new graph. This must be the first statement in the input file.
Following this, graph specifications can be given.
.ns
.HP 5
.BI size " xsize " by " ysize "
.br
Graph size is in inches. 
.I xsize
and
.I ysize
give the x and y sizes in inches.
Note that this size does not include the 
labels or axes numbers.
Except for size, every other 
number is specified in the graph coordinates.
.ns
.HP 5
.BI ;
.br
semi-colon starts a comment line. The comment is terminated by the end-of-line.
.ns
.HP 5
.BI "graph title " " title-text " 
.br
The title appears at the bottom center of the graph. The text can include
greek text, subscripts or superscripts. See new text for details.
.ns
.HP 5
.BI "graph font " " fontname " 
.br
The graph font specification controls: symbols, title, axis labels, 
axis line thickness, and ticmark size. (For fast drawing under X use the same 
graph and axis fonts.) Available fonts are 
.I helvetica3
through 
.I helvetica30,
.I helvetica3b
through 
.I helvetica20b,
.I helvetica3i
through 
.I helvetica30i, 
.I helvetica3bi 
through 
.I helvetica30bi,
and the corresponding 
.I timesroman 
fonts.
.ns
.HP 5
.BI key  " xpos,  ypos { , icontype } { , fontname }  "
.br
Collects curve labels together with a small icon at the given 
point 
.I xpos,ypos
in graph co-ordinates (top left corner of key box )
and in the given font
.I fontname
that controls aspects of the key such as key spacing.
The icon specification is via
.I icontype,
which is
.I symbol
for displaying the curve symbol,
.I line
for showing a segment of the line type, or
.I both
to show both a symbol and a line segment.
.ns
.HP 5
.BI "graph curve  font " " fontname " 
.br
Specifies the default 
fonttype for all the curves in the graph. This is overridden by the individual
curve font commands.
.ns
.HP 5
.BI "graph text  font " " fontname " 
.br
Specifies the default 
fonttype for all the text in the graph. This is overridden by the individual
text font commands.
.ns
.HP 5
.BI exclude " graph-component "
.br
This will not show the  previously defined 
.I graph-component, 
which can be
.I curve, 
or 
.I text.

.ns
.HP 5
.B New curve
.br
Starts a new curve. Following this, curve specifications can be included.
.ns
.HP 5
.B New points
.br
Precedes the curve points list. Points are specified as 
.I x,y {~ conf-intvl}
starting on the line immediately following the above declaration. Only
one pair of points must appear on one line. The pair of points can be 
optionally followed by a non-negative
confidence interval. A vertical line of length
.I conf-intvl
is drawn above and below the point. The confidence interval is shown only if 
.I curve confidence 
is requested.
The list of points for the current
curve ends with a blankline.
.ns
.HP 5
.BI "curve confidence "
.br
Specifies that the confidence intervals be displayed for this curve.
.ns
.HP 5
.BI "curve label " " label-text " 
.br
Specifies the curve label that will be displayed in the key.
.ns
.HP 5
.BI "curve type " " type-name "
.br
The
.I type-name
specifies the type of the curve line.
Curve types can be 
.I dots, dashes, stipple, pat,
bold, none, 
and
.I fill.
.I Fill
paints the area bounded by the curve, the two axes, and the plot
boundary, with a
.I screen. If the begin and end points of the curve are the same, then
splot paints only the enclosed area. The user must supply a gray shade,
or else the area is painted solid black.
The screen design is set by default. Unlike PostScript,
an X display fills
with a flat gray shade. The fill feature is particularly
useful when you have to show incremental curves.
(Histograms can also be used to show incremental bars in like manner.
Although in histograms just gray shades appear.)
Filling is opaque, i.e., a filled curve blots out all that appears
beneath it (specified earlier in the file), with the exception of text. 
.ns
.HP 5
.BI "curve exclude " " line "
.br
For 
.I fill
curve types the line bounding the filled region appears by default.
The bounding line does not appear with the above command.
.ns
.HP 5
.BI "curve gray " " gray-level "
.br
Specifies gray level for the curve filling, or line. Also useful
for histograms. Gray levels are 0.0 (black) to 1.0 (white).
WARNING: When using gray scales,
if your X windows use shades of gray,
displaying graphs on your windows may give 
your windows a new (unattractive) look!
Log out of all your windows if
this happens. Also, use the -g option on the QVSS.
Use the -g option, which disallows grays, to avoid this problem.
.ns
.HP 5
.BI "curve mat " " frequency " , " angle " , " cross-hash "
.br
Specifies a screen type for filling. Usually splot chooses reasonable 
defaults and so this specification is not usually necessary. 
The
.I frequency
gives the number of lines per inch in the hashing design, the
.I angle
specifies the angle of the hash lines in degrees, and 
.I cross-hash
is 1 if cross hashing is desired, otherwise it is 0. (Also see caveat on
the frequency parameter.)
.ns
.HP 5
.BI "curve symbol " " symbol-type " " { Size num } "
.br
.I Symbol-types 
are 
.I triangle, diamond, plus, cross, star, circle, 
.I rectangle, 
and 
.I square (or box)
and 
.I circlefilled , trianglefilled, diamondfilled, squarefilled (or solidbox),
and 
.I rectanglefilled. 
An optional size parameter can also be specified, where 
the integer
.I num
sets the symbol size. The
default size is chosen from the graph font, and corresponds to
.I num
equal to 2, and larger integers increase the size linearly,
while smaller ones 
(including negative numbers) give smaller sizes.
.ns
.HP 5
.BI "curve font " " font-name "
.br
Specifies the curve font. See the graph font specification for available font
types. Default for all curves can be set using the graph font command.
Curve font controls curve line width, or bar thickness in a histogram.
.ns
.HP 5
.BI "curve interpolation " " interp-type "
.br
.I Interp-type
specifies the interpolation method. Allowed methods are 
.I linear, xhistogram, yhistogram, regression, step, smooth, or none.
Customized histograms can also be created by using the bar interpolation
with fill type.
Regression gives linear regression. Also see "text align center" and
"exclude axis numbers" and "exclude line" commands, 
which are useful with histograms.
.I Smooth
works only for PostScript. You can additionally use the
spline filter on your points before plotting.
.ns
.HP 5
.BI " new text " " xpos " , " ypos "
.br
Specifies the start of a new text object. Text is entered on the line 
following the new text command, and ends with a blank line.
Note that the blank line must not have any spaces or tabs, else
text will continue. Multiple lines of text may be entered.  By default, the top
left corner of the text body is positioned at 
.I xpos,ypos.
.br
    
.br
Splot supports usual alpha-numerics, greek text, subscsripts and 
superscripts, and special characters in PostScript.
Greek text is entered as  \\g{greek-text},
subscripts as  \\-{subscript-text} (or \\_{subscript-text})
and superscripts as  \\+{superscript-text} (\\^{superscript-text}).
No nesting is currently allowed.
Characters such as parentheses that postscript treats as specials must
be escaped with a back-slash. The following declarations affect the 
most recent previously-entered text.
.ns
.HP 5
.BI "text font " " font-name "
.br
Specifies the font of the text entered before this declaration.
Graph text font affects all the text unless 
overridden by a text font command.
.ns
.HP 5
.BI "text align " " how-align "
.br
The default top left corner alignment can be overridden using the align
command. 
.I How-align
can be 
.I center, left, right, 
for top-left, top-left, or top-right alignment. The 
.I center
alignment is useful with the histogram interpolation to put text
centered below (beside) the appropriate bar.
.ns
.HP 5
.BI "text angle "  " angle-spec  "
.br
Rotates the text about its alignment point by 
.I angle-spec.
The angle must be specified in degrees.
.PP
In all the following X axis commands, substitution 
of Y yields the corresponding Y parameter. The  thickness of the axis line 
is determined by the graph font specification.
.ns
.HP 5
.BI "X label " " label-text "
.br
Specifies the X-axis label. 
.ns
.HP 5
.BI "X Maximum " " max-num "
.br
.I Max-num
is the upper limit of the X axis.
.ns
.HP 5
.BI "X Minimum " " min-num "
.br
.I Min-num
is the lower limit of the X axis.
.ns
.HP 5
.BI "X Interval " " interval-num "
.br
Gives the interval between the tic marks and numbers on the X-axis.
Interval in log scale is best kept at 1, where
it specifies the interval between tic marks AFTER log scaling.
.ns
.HP 5
.BI "X scale " " scale-type "
.br
Specifies axis scaling.
Allowable scales are
.I linear, log.
Splot defaults to linear scale.
In log scale, the numbers on the
minor-tics can be shut off using the "exclude minortic numbers" command.
In log scale, the points are entered as for linear scales.
.ns
.HP 5
.BI "X logbase " " base-num "
.br
If log scale, specifies the log base. 
.ns
.HP 5
.BI "X font " " font-name "
.br
Font controls axis numbers.
.ns
.HP 5
.BI "X numberstyle "  " numstyle-type  [precision] "
.br
.I Numstyle-type
specifies how the numbers labelling the axis tic marks should appear.
The default is 
.I integer. 
Integer must not have the precision specification.
Other types are:
.I floating,
.I scientific
and
.I  exponent.
The above three are followed by an optional  number, 
.I precision,
that indicates
how many digits should follow the decimal point.
.ns
.HP 5
.BI "X  unit " " unit-num "
.br
The axis numbers on the graph appear multiplied by
.I unit-num.
Default is 1. 
Useful when, for instance, if your data is in micrometers and you want the 
numbers to appear in meters, specify the unit to be 1.e-6.
.ns
.HP 5
.B Exclude X numbers
.br
Does not print out X axis numbers.
This feature is typically used with
histograms with user defined text at the axis tic points.
Use " text align Center " to get text centered on tic.
Also, you may want to rotate text by 90 degrees. 
.ns
.HP 5
.B Mirror Axes
.br
Draws mirror images of the axes with associated labels, ticmarks, and numbers
at the top and far right of the graph. The mirror mirror axes 
option can be used to create plots with double Y axes. See notes
for further information.
plot 
.ns
.HP 5
.B Exclude mirror numbers
.br
Does not print out mirror axes numbers. 
.ns
.HP 5
.B Exclude mirror labels
.br
Does not print out mirror axes labels.
.ns
.HP 5
.BI Origin " xpos " , " ypos "
.br
Shifts the axes so that they intersect at the point
.I xpos,ypos.
.ns
.HP 5
.B Exclude Axes
.br
Does not print axes, nor does it print 
associated ticmarks, numbers and labels. You can still print
mirror axes though. This facility is useful in building plots
with dual Y axes. See notes for more information.
.ns
.HP 5
.B exclude minortic numbers
.br
If axes numbers get too crowded in log scale the minortic numbers 
can be shut off.
.ns
.HP 5
.B exclude minortics
.br
Shut off both minortic numbers and ticmarks.
.PP
.SH EXAMPLES
The minimal Splot description inputfile must contain
"new graph", "new curve", "new points", and the points.
The following is a detailed  example:
.nf
	New Graph
	;graph specs
	Size 6 by 6
	Graph title SPLOT - An Example
	Graph Font HELVETICA12
	key 4,100,both,helvetica12
	
	;text
	New text 7, 10
	This is an example of text centering and rotation.

	text align center
	text angle 45.0
	text font timesroman12

	New text 3 , 3.0
	\\g{abCdeF} Sounds like greek to me!
	Mountain \\+{Climbers} eventually \\-{come down} to sea level.
	
	The tabbed line does not end the text.

	text font timesroman14b

	;curves
	New Curve
	curve label Squares
	Curve Font HELVETICA12
	curve symbol diamondfilled size 3
	Curve Type solid
	curve gray 0.5
	new points
	1,1
	3,9
	5,25
	7,49
	9,81
	
	New Curve
	curve label Regression
	Curve Font HELVETICA12
	curve symbol triangle
	Curve Interpolation regression
	new points
	1,8.5
	3,21
	4,2.2e+1.0005
	5,48.01
	9,99
	
	X Label Xlabel
	X Font Helvetica12BI
	X Maximum 10
	X Minimum 0
	X Interval 1
	X unit 5
	
	Y Label Ylabel
	Y Font Helvetica12BI
	Y Maximum 100
	y scale log
	y logbase 10
	Y Minimum 1
	Y Interval 1
	Y numberstyle floating 1
.fi
.PP
.SH CAVEATS:
On the QVSS, run splot with the -g switch, as the gray levels do not
work. 
.PP
Greek or  rotated text will not show up properly on the screen.
.PP
If the symbols get chopped off at the plot boundaries,
extending the axis limits by a slight amount will bring them in.
.PP
If the X plot window disappears as soon as it starts plotting you have
probably specified the input file from stdin. Try using "splot -x infile"
instead.
.PP
The frequency parameter in the mat command should be greater than
20, otherwise there will most likely be a printer error due to 
excessive memory requirements of the low-frequency lines.
.PP
Parenthesis in text or labels for PostScript output must be escaped with a 
back-slash.
.SH NOTES
If the splot PostScript output file is very big then you can pipe
it through " blot " to compress it.
.PP
Splot graphs (or other PostScript figures)
can be incorporated into Tex or Scribe manuscripts as follows:
.nf
Example for inserting into tex files :
\\\fIbegin{figure}\fP
\\\fIvspace{4in}\fP
\\\fIspecial{psfile=splotpicture.psf}\fP
\\\fIend{figure}\fP
Run latex to generate foo.dvi and then run dvi2ps to convert to PostScript. 
dvi2ps allows additional scaling and translation.
Concatenate as header PostScript preamble file, splot.ps.
 
Inserting into scribe files:
.I @begin(figure)
.I @picture(size 4inches, postscript = "splotpicture.psf")
.I @caption(foo)
.I @end(figure)
Run scribe to generate foo.psf and then concatenate as header splot.ps.
.fi
.PP
To insert multiple plots into one figure translate the splot 
picture accordingly. 
.PP
Double Y axes: Double Y axes can be kludged in splot for
PostScript output. Call the axes (left-bottom X1,Y1) and (right-top X2,Y2).
First, draw
a plot with the bottom X 
axis (X1), and the left Y axis (Y1) with its associated curves
and labels. Do not use the "mirror axes" command in this first plot.
Compile this with the -d option to inhibit the page eject.
Then, draw another plot with the same X axis, but
the alternate Y axis and its associated curves
and labels. In the second plot, 
draw the mirror axes (right-top X2, Y2) using "mirror axes"
and leave out the regular axes (left-bottom) using "exclude axes".
Compile this too. Catenate splot.ps and the two postscript files, and print
to superimpose the two. The command line translations and compressions
in the first plot apply automatically to the second.
.PP
.SH FILES
.nf
/usr/local/lib/splot/splot.ps    Splot PostScript Preamble file.
.fi
.SH SEE ALSO
latex(1), scribe(1), lpr(1), dvi2ps(1), cat(1), spline(1), X(1)
.PP
.SH AUTHOR
Anant Agarwal. Contributers also include 
Arturo Salz, Steve Przybylski, and
Scott Mcfarling.
