/*
 * Copyright 1988 Anant Agarwal
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied 
 * warranty.
 *
 * Author:  Anant Agarwal, MIT Laboratory for Computer Science
 */

# define NEW 257
# define GRAPH 258
# define TITLE 259
# define SIZE 260
# define FONT 261
# define ANGLE 262
# define ALIGN 263
# define LEFT 264
# define RIGHT 265
# define CENTER 266
# define BAR 267
# define REGRESSION 268
# define STEP 269
# define XHISTOGRAM 270
# define YHISTOGRAM 271
# define SMOOTH 272
# define SPLINE 273
# define KEY 274
# define CURVE 275
# define POINTS 276
# define CONFIDENCE 277
# define LABEL 278
# define LABELS 279
# define TYPE 280
# define INTERPOLATION 281
# define GRAY 282
# define MAT 283
# define X 284
# define Y 285
# define MAXIMUM 286
# define MINIMUM 287
# define UNIT 288
# define INTERVAL 289
# define SCALE 290
# define LOGBASE 291
# define NUMBERSTYLE 292
# define TEXT 293
# define INPUT 294
# define LINE 295
# define SYMBOL 296
# define BOTH 297
# define NONE 298
# define SOLID 299
# define DASHES 300
# define STIPPLE 301
# define DOTS 302
# define PAT 303
# define FILL 304
# define BOLD 305
# define CROSS 306
# define TRIANGLE 307
# define TRIANGLEFILLED 308
# define DIAMOND 309
# define DIAMONDFILLED 310
# define SQUARE 311
# define BOX 312
# define SQUAREFILLED 313
# define SOLIDBOX 314
# define RECTANGLE 315
# define RECTANGLEFILLED 316
# define CIRCLE 317
# define CIRCLEFILLED 318
# define BULLET 319
# define PLUS 320
# define STAR 321
# define LINEAR 322
# define LOGS 323
# define UNKNOWNCMD 324
# define COMMENT 325
# define EXCLUDE 326
# define MINORTIC 327
# define MINORTICS 328
# define NUMBERS 329
# define FONTNAME 330
# define INTEGER 331
# define FLOATING 332
# define SCIENTIFIC 333
# define EXPONENT 334
# define MIRROR 335
# define ORIGIN 336
# define AXES 337

# line 87 "plot.yacc"

#include <stdio.h>
#include <strings.h>
#include "plotio.h"
#include "defs.h"
#include "structs.h"
#include "plot.h"

static double currSSfreq=30.0, currSSang = 0.0; /* for setscreen */
static int currSSfnIndex = 0;


char pstr[MAXLABEL];/*stores previous correct instring - for error reporting*/
char errorpos[MAXLABEL];/* stores prev correct text word */
double tmpfloat;
int tmpint;
pointType *ptPtr;/*temp pointer for current point in curve */
boolean intext = FALSE;
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#ifndef YYSTYPE
#define YYSTYPE int
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 892 "plot.yacc"
 

#include "lex.yy.c"


addPointsPair1()
{
	ptPtr = (pointType *)GetSp(sizeof(pointType));
	ptPtr->conf = NoConfInterval; /* initialized */
	if ((curves[curcur])->fstPtr == nil)
	{
		/*means first point in curve */
		(curves[curcur])->fstPtr = ptPtr;
		ptPtr->prvPtr = nil;
	}
	else 
	{
		ptPtr->prvPtr = (curves[curcur])->lstPtr;
		(curves[curcur])->lstPtr->nxtPtr = ptPtr;
	}
	(curves[curcur])->lstPtr = ptPtr;
	ptPtr->nxtPtr = nil;
	(curves[curcur])->lastpoint += 1;
	/* incr point count; after 1st pt is 0 */
	ptPtr->pt[xpt]= atof(yytext);
}

addPointsPair2()
{
	ptPtr->pt[ypt] = atof(yytext);
}

addPointsConf()
{
	ptPtr->conf = atof(yytext);
}

unknowncmderror()
{
	fprintf(stderr,	
		"***splot::Warning: unknown command near line %d\n", lineno);
	fprintf(stderr,"previous text: %s, ",errorpos);
	fprintf(stderr,"current text: %s\n",yytext);
}

newgraphproc()
{
	graph.includekey = FALSE;
	strcpy(graph.title,"\0");
	graph.font = defGraphFont;
	graph.keyfont = defGraphKeyFont;
	graph.key = kboth;
	graph.size[xpt] = defGraphXsize * 2.54;
	graph.size[ypt] = defGraphYsize * 2.54;
	setaxisdefs(xpt);
	setaxisdefs(ypt);
	currSSang = 0.0;
	currSSfnIndex = 0;
	currSSfreq = 30;
}

setaxisdefs(z)
int z;
{
	strcpy(axis[z].label,"\0");
	axis[z].scale.type = linear;
	axis[z].interval = 0.0;
	axis[z].axismax = BIG;
	axis[z].axismin = BIG;
	axis[z].numberstyle = floating;
	axis[z].signif = 0;
	axis[z].unit = 1.0;
	axis[z].font = defAxisFont;
}

newcurveproc()
{
	curcur++;/*go to first empty slot*/
	curves[curcur] = (curvetype *) 
		GetSp(sizeof(curvetype));  
	(curves[curcur])->validcurve = TRUE;
	strcpy((curves[curcur])->label,"\0");
	(curves[curcur])->symbol = nonesymbol;
	(curves[curcur])->symbolsize = defSymbolSize;
	(curves[curcur])->interp = linearinterp;
	(curves[curcur])->type = solid;
	(curves[curcur])->fstPtr = nil;
	(curves[curcur])->lstPtr = nil;
	(curves[curcur])->lastpoint = -1;
	(curves[curcur])->include = TRUE;
	(curves[curcur])->showConf = FALSE;
	(curves[curcur])->thick = defGraphThick;
	(curves[curcur])->gray = 0.0;
	(curves[curcur])->mat.grayset = FALSE;
	(curves[curcur])->mat.freq = 0.0;
	(curves[curcur])->mat.ang = 30.0;
	(curves[curcur])->mat.indx = 0;
	(curves[curcur])->mat.matset = FALSE;
	(curves[curcur])->mat.showline = TRUE;
	/* bounding curve appears by default */
}

handlefillproc()
{
	currSSang += 45.0; 
	/* rotate 45 degrees for each new curve */
	if (currSSang > 181.0) 
	{
		currSSang = 45.0;
		currSSfnIndex += 1;
		if (currSSfnIndex == MAXSSFNS)
		{
			currSSfnIndex = 0;
			currSSfreq += 15.0;
			if (currSSfreq > 61.0)
			{
				currSSfreq = 5.0;
			}
		}
	}
	(curves[curcur])->type = fill;
	/* bounding curve true by default */
	if ((!(curves[curcur])->mat.grayset))
		(curves[curcur])->gray = defFillGray;
	if ((!(curves[curcur])->mat.matset))
	{
	    (curves[curcur])->mat.freq = currSSfreq;
	    (curves[curcur])->mat.ang = currSSang;
	    (curves[curcur])->mat.indx= currSSfnIndex;
	}
}

nocurverr()
{
	fprintf(stderr,
		"splot error: no new curve command, near line %d\n", lineno);
}

notexterr()
{
	fprintf(stderr,
	"***splot warning: error on line %d, no text entered yet!\n", lineno);
}

newtextproc()
{
	curtext++;
	text[curtext] = (texttype *) GetSp(sizeof(texttype));
	(text[curtext])->font = defTextFont;
	(text[curtext])->angle = 0;
	(text[curtext])->include = TRUE;
	(text[curtext])->validtext = TRUE;
}
short yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 288,
	10, 99,
	-2, 97,
	};
# define YYNPROD 231
# define YYLAST 438
short yyact[]={

   4, 127, 119, 299,  75, 184, 185, 186, 187, 206,
 124, 125, 218, 168, 169, 170, 171, 203, 202, 120,
 219, 220, 221, 222, 223, 224, 225, 226, 227, 228,
 229, 230, 231, 232, 233, 234, 189, 194, 192, 174,
 158, 155, 139, 303, 190, 179, 180, 300,  90, 197,
 132, 163, 164, 122, 123, 283, 284, 285, 307, 298,
 262, 121, 151, 126,  89,  91, 304,  92,  94,  95,
  97, 193, 191, 238, 239, 237, 242, 240, 241, 198,
 133, 111,  78,  93, 305, 294, 188, 209, 210, 211,
 212, 213, 214, 215, 216, 291, 286, 282, 110,  80,
  81, 279,  82, 102,  83, 277, 112, 113, 114, 117,
 115, 116, 118,  96, 290, 276, 275,  79,  85, 274,
 101, 263, 270, 269, 268, 265, 264, 236, 103, 104,
 105, 108, 106, 107, 109, 258,  84, 141, 255, 253,
 250, 248, 207, 205, 204, 201, 199, 196, 182, 181,
 177, 176, 175, 173, 166, 165, 161, 160, 159, 157,
 153, 152, 150, 146, 138, 130, 128,  88,  87, 245,
 247, 246, 100,  98,  99, 140, 261, 267, 254, 249,
 310, 288, 200, 134,  77,  76,   2, 183,  74, 178,
 172, 167, 162, 156, 309, 296, 289, 272, 260, 136,
 280, 243, 235, 149, 266, 217, 148, 208, 147, 145,
 144, 195, 244, 154, 302, 301, 295, 287, 281, 259,
 135, 278, 273, 143, 142,  86, 137, 129, 131,  71,
  59,  58,  57,  56,  55,  54,  53,  52,  51,  50,
  49,  48,  47,  46,  45,  44,   3,  60,  61,  43,
  62,  60,  61,  42,  62,  41,  40,  39,  38,  37,
  36,  35,  34,  33,  63,  64,  32,  31,  63,  64,
  30,  29,  28,  27,  66,  67,  26,  25,  66,  67,
  24,  23,  22,  65,  21,  20,  19,  65,  18,  17,
  16,  15,  14,  13,  12,  11,  10,   9,   8,   7,
   6,   5,   1,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,  73,  72,  69,   0,  73,  72,
  69,   0,   0,   0,   0,  68,  70,   0,   0,  68,
  70,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0, 304, 297, 263,   0, 308,   0,   0, 306,
 251, 252,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0, 256, 257,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0, 292,
 293,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0, 271 };
short yypact[]={

 -10,  -6, 175, 174,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-176,-157,-126,-127,-213, -89,-158,-180,-335,-274,
-128,-1000,-129,-244, 173,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-130,-288, -86,-124,-1000,-1000,-1000,-1000,
-1000,-131,-1000,-1000,-1000,-132,-233,-133,-134,-1000,
-289,-135,-290,-136,-137,-138,-271,-139,-140,-318,
-141,-291,-142,-143,-144,-277,-145,-146,-326,-1000,
-1000,-243,-285,-1000,-257,-258,-1000,-1000,-1000,-147,
-1000,-245,-1000,-1000,-1000,-148, 172,-149,-1000,-1000,
-312,-313,-150,-151,-321,-152,-1000,-211,-286,-195,
-1000,-1000,-1000,-1000, -95,-1000,-153,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-154,
-154,-154,-155,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-156,-156,-156,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-159,-1000,-1000,-1000,-1000,
  50,-1000,-1000,-1000,-168,-169,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000, -83,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-170,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-171,-172,
-173,-1000,-1000,-1000,-1000,-1000,-1000,-175,-178,-1000,
-179,-1000,-189,-193,-1000,-1000,-1000,-197,-1000,-240,
-198, 171,-1000,-199,-199,-199,-209,-1000,-1000,  49,
-1000,-327,-1000,-1000,-1000,-228,-1000,-210,-1000,-1000,
-1000,-228,  48,-1000,-1000,-1000,-1000,-1000,-1000, 170,
-1000 };
short yypgo[]={

   0, 302, 186, 301, 300, 299, 298, 297, 296, 295,
 294, 293, 292, 291, 290, 289, 288, 286, 285, 284,
 282, 281, 280, 277, 276, 273, 272, 271, 270, 267,
 266, 263, 262, 261, 260, 259, 258, 257, 256, 255,
 253, 249, 245, 244, 243, 242, 241, 240, 239, 238,
 237, 236, 235, 234, 233, 232, 231, 230, 229, 228,
 227, 226, 225, 224, 223, 222, 221, 114, 220, 219,
 218, 217, 216,  47, 215, 214,  43, 213, 212, 211,
 210, 209, 208, 207, 206, 205, 204, 203, 202, 201,
 200, 199, 198, 176, 197, 196, 195, 194, 193, 192,
 191, 179, 190, 189, 187, 178 };
short yyr1[]={

   0,   1,   1,   1,   1,   1,   2,   2,   2,   2,
   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
   2,  55,  58,  58,  59,  59,  59,  59,  56,  56,
  60,  60,   3,   4,   4,  61,  61,   5,  62,  63,
  62,   6,   7,   8,  64,  65,   9,  66,  66,  66,
  66,  67,  67,  68,  69,  70,  11,  72,  71,  71,
  73,  73,  74,  75,  75,  76,  54,  14,  77,  15,
  78,  78,  78,  13,  42,  43,  44,  79,  45,  47,
  48,  49,  50,  51,  52,  53,  10,  46,  22,  80,
  12,  16,  16,  81,  81,  82,  17,  83,  83,  83,
  83,  83,  83,  83,  83,  84,  18,  86,  86,  85,
  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,
  85,  85,  85,  85,  85,  85,  87,  19,  88,  88,
  88,  88,  88,  88,  88,  20,  21,  89,  90,  23,
  91,  57,  92,  92,  92,  94,  95,  93,  97,  96,
  96,  24,  24,  98,  98,  25,  26,  27,  28,  29,
  99,  99,  30,  31,  32, 100, 100, 100, 100, 101,
 101,  33,  33, 102, 102,  34,  35,  36,  37,  38,
 103, 103,  39,  40,  41, 104, 104, 104, 104, 105,
 105 };
short yyr2[]={

   0,   2,   3,   2,   2,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   2,   2,   2,   1,   1,   2,   1,
   2,   1,   2,   3,   2,   2,   1,   2,   0,   0,
   4,   3,   4,   4,   0,   0,   7,   3,   3,   3,
   0,   2,   0,   0,   0,   0,   9,   0,   3,   1,
   2,   1,   2,   2,   1,   1,   2,   3,   0,   4,
   1,   1,   1,   3,   2,   3,   3,   0,   5,   3,
   2,   3,   3,   3,   3,   2,   2,   2,   2,   0,
   4,   3,   2,   2,   1,   0,   4,   1,   1,   1,
   1,   1,   1,   1,   1,   0,   5,   2,   0,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   0,   4,   1,   1,
   1,   1,   1,   1,   1,   3,   3,   0,   0,   9,
   0,   5,   2,   1,   1,   0,   0,   6,   0,   4,
   1,   3,   2,   2,   1,   3,   3,   3,   3,   3,
   1,   1,   3,   3,   3,   1,   2,   2,   2,   1,
   0,   3,   2,   2,   1,   3,   3,   3,   3,   3,
   1,   1,   3,   3,   3,   1,   2,   2,   2,   1,
   0 };
short yychk[]={

-1000,  -1,  -2, 256,  10,  -3,  -4,  -5,  -6,  -7,
  -8,  -9, -10, -11, -12, -13, -14, -15, -16, -17,
 -18, -19, -20, -21, -22, -23, -24, -25, -26, -27,
 -28, -29, -30, -31, -32, -33, -34, -35, -36, -37,
 -38, -39, -40, -41, -42, -43, -44, -45, -46, -47,
 -48, -49, -50, -51, -52, -53, -54, -55, -56, -57,
 257, 258, 260, 274, 275, 293, 284, 285, 335, 326,
 336, -58, 325, 324,  -2,  10,  10,  10, 258, 293,
 275, 276, 259, 261, 293, 275, -62, 294, 294, 277,
 261, 278, 280, 296, 281, 282, 326, 283, 262, 263,
 261, 278, 261, 286, 287, 288, 290, 291, 289, 292,
 278, 261, 286, 287, 288, 290, 291, 289, 292, 337,
 293, 335, 327, 328, 284, 285, 337, 275, 294, -60,
 294, -59, 294, 324,  10, -68, -91, -61, 294, 330,
 261, 261, -63, -64, -80, -81, 294, -82, -84, -87,
 294, 295, 294, 294, -77, 330, -98, 294, 330, 294,
 294, 294, -99, 322, 323, 294, 294,-100, 331, 332,
 333, 334,-102, 294, 330, 294, 294, 294,-103, 322,
 323, 294, 294,-104, 331, 332, 333, 334, 329, 279,
 329, 329, 295, 329, 295, -79, 294, 294, 324, 294,
  10, 294, 330, 330, 294, 294, 330, 294, -83, 298,
 299, 300, 301, 302, 303, 304, 305, -85, 298, 306,
 307, 308, 309, 310, 311, 312, 313, 314, 315, 316,
 317, 318, 319, 320, 321, -88, 322, 270, 268, 269,
 272, 273, 271, -89, -78, 264, 266, 265, 294,-101,
 294,-101,-101, 294,-105, 294,-105,-105, 294, -69,
 -92, -93,  10, 294, 294, 294, -86, 260, 294, 294,
 294, -93, -94, -65, 294, 294, 294, 294, -66, 294,
 -90, -70, 294, 295, 296, 297, 294, -71,  10, -95,
 -67, 294, -67, -67, 294, -72, -96, 294,  10, 330,
 -73, -74, -75, -76, 294, 294, -73,  10, -76, -97,
  10 };
short yydef[]={

   0,  -2,   0,   0,   5,   6,   7,   8,   9,  10,
  11,  12,  13,  14,  15,  16,  17,  18,  19,  20,
  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,
  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,
  41,  42,  43,  44,  45,  46,  47,  48,  49,  50,
  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,
   0,   0,  78,   0,   0,   0,   0,   0,   0,   0,
   0,  61,  69,  62,   0,   3,   1,   4,  72,  93,
 126, 180,  74,   0,   0,   0,  77,  79,  84, 128,
 129, 132, 135, 145, 166,   0,   0,   0,   0, 108,
   0, 192,   0,   0,   0,   0,   0,   0,   0,   0,
 212,   0,   0,   0,   0,   0,   0,   0,   0, 114,
 106,   0,   0, 120,   0,   0, 125, 127, 117,  68,
  71,  63,  66,  67,   2,   0,   0,  73,  76,  81,
   0,   0,   0,   0,   0, 131, 134,   0,   0,   0,
 175, 176, 177, 107,   0, 113, 191, 194, 195, 196,
 197, 198, 199, 200, 201, 202, 203, 204, 205, 210,
 210, 210, 211, 214, 215, 216, 217, 218, 219, 220,
 221, 222, 223, 224, 225, 230, 230, 230, 115, 116,
 119, 121, 123, 122, 124,   0,  70,  64,  65,  94,
   0,  75,  82,  83,   0,   0, 130, 133, 136, 137,
 138, 139, 140, 141, 142, 143, 144, 148, 149, 150,
 151, 152, 153, 154, 155, 156, 157, 158, 159, 160,
 161, 162, 163, 164, 165, 167, 168, 169, 170, 171,
 172, 173, 174,   0, 109, 110, 111, 112, 193, 206,
 209, 207, 208, 213, 226, 229, 227, 228,   0,   0,
 181, 183, 184, 185,  80,  85, 146,   0,   0, 118,
   0, 182,   0,  90, 147, 178,  95,   0,  86,   0,
   0,   0, 186,  92,  92,  92,   0,  96,  -2,   0,
  87,   0,  88,  89, 179,   0, 187,   0, 190,  91,
  98, 101,   0, 104, 105, 188, 100, 102, 103,   0,
 189 };
#ifndef lint
static char yaccpar_sccsid[] = "@(#)yaccpar	4.1	(Berkeley)	2/11/83";
#endif not lint

#
# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

#ifdef YYDEBUG
int yydebug = 0; /* 1 for debugging */
#endif
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

	short yys[YYMAXDEPTH];
	short yyj, yym;
	register YYSTYPE *yypvt;
	register short yystate, *yyps, yyn;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

#ifdef YYDEBUG
	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
#endif
		if( ++yyps> &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
		*yyps = yystate;
		++yypv;
		*yypv = yyval;

 yynewstate:

	yyn = yypact[yystate];

	if( yyn<= YYFLAG ) goto yydefault; /* simple state */

	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
		}

 yydefault:
	/* default state action */

	if( (yyn=yydef[yystate]) == -2 ) {
		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
		/* look through exception table */

		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
			}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( yyerrflag ){

		case 0:   /* brand new error */

			yyerror( "syntax error" );
		yyerrlab:
			++yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( yyps >= yys ) {
			   yyn = yypact[*yyps] + YYERRCODE;
			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
			      yystate = yyact[yyn];  /* simulate a shift of "error" */
			      goto yystack;
			      }
			   yyn = yypact[*yyps];

			   /* the current yyps has no shift onn "error", pop stack */

#ifdef YYDEBUG
			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
#endif
			   --yyps;
			   --yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

#ifdef YYDEBUG
			if( yydebug ) printf( "error recovery discards char %d\n", yychar );
#endif

			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production yyn */

#ifdef YYDEBUG
		if( yydebug ) printf("reduce %d\n",yyn);
#endif
		yyps -= yyr2[yyn];
		yypvt = yypv;
		yypv -= yyr2[yyn];
		yyval = yypv[1];
		yym=yyn;
			/* consult goto table to find next state */
		yyn = yyr1[yyn];
		yyj = yypgo[yyn] + *yyps + 1;
		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
		switch(yym){
			
case 4:
# line 113 "plot.yacc"
{
				fprintf(stderr,
				"***splot::error near line %d\n", lineno);
				fprintf(stderr,
				"previous text: %s, ",errorpos);
/*				fprintf(stderr,"prev: %s, ",pstr);*/
				fprintf(stderr,"current text: %s\n",yytext);
				yyerrok;
			} break;
case 62:
# line 187 "plot.yacc"
{
				unknowncmderror();
			} break;
case 63:
# line 191 "plot.yacc"
{
				unknowncmderror();
			} break;
case 72:
# line 211 "plot.yacc"
{
				newgraphproc();
			} break;
case 75:
# line 221 "plot.yacc"
{strcat(graph.title, yytext);} break;
case 76:
# line 223 "plot.yacc"
{strcat(graph.title, yytext);} break;
case 78:
# line 230 "plot.yacc"
{
				graph.size[xpt] = 6;
				graphsize[xpt] = graph.size[xpt]*2.54;
				graph.size[ypt] = 6;
				graphsize[ypt] = graph.size[ypt]*2.54;
			} break;
case 79:
# line 237 "plot.yacc"
{
				graph.size[xpt] = atof(yytext);
				graphsize[xpt] = graph.size[xpt]*2.54;
			} break;
case 80:
# line 243 "plot.yacc"
{
				graph.size[ypt] = atof(yytext);
				graphsize[ypt] = graph.size[ypt]*2.54;
			} break;
case 81:
# line 250 "plot.yacc"
{
				graph.font = yylval;
			} break;
case 82:
# line 256 "plot.yacc"
{
				defTextFont = yylval;
			} break;
case 83:
# line 262 "plot.yacc"
{
				defGraphThick = FFthick(yylval);
			} break;
case 84:
# line 268 "plot.yacc"
{
				graph.keypos[xpt] = atof(yytext);
			} break;
case 85:
# line 273 "plot.yacc"
{
				graph.keypos[ypt] = atof(yytext);
				if ((graph.keypos[xpt] != 0.0)&&
				    (graph.keypos[ypt] != 0.0))
					graph.includekey = TRUE;
			} break;
case 87:
# line 283 "plot.yacc"
{
				graph.key = ktype;
			} break;
case 88:
# line 287 "plot.yacc"
{
				graph.key = ksymbol;
			} break;
case 89:
# line 291 "plot.yacc"
{
				graph.key = kboth;
			} break;
case 91:
# line 298 "plot.yacc"
{
				graph.keyfont = yylval;
			} break;
case 93:
# line 305 "plot.yacc"
{
				newtextproc();
			} break;
case 94:
# line 309 "plot.yacc"
{
				(text[curtext])->pos[xpt] = atof(yytext);
			} break;
case 95:
# line 314 "plot.yacc"
{
				(text[curtext])->pos[ypt] = atof(yytext);
			} break;
case 97:
# line 321 "plot.yacc"
{intext = TRUE;} break;
case 98:
# line 323 "plot.yacc"
{
				 intext = FALSE;
			} break;
case 102:
# line 334 "plot.yacc"
{
				strcat((text[curtext])->label,yytext);
			} break;
case 105:
# line 344 "plot.yacc"
{
				strcat((text[curtext])->label,yytext);
			} break;
case 106:
# line 350 "plot.yacc"
{
				if (curtext == -1) notexterr();
				else (text[curtext])->include = FALSE;
			} break;
case 107:
# line 359 "plot.yacc"
{
				if (curtext == -1) notexterr();
				else
				(text[curtext])->angle = atof(yytext);
			} break;
case 108:
# line 369 "plot.yacc"
{
				if (curtext == -1) notexterr();
			} break;
case 110:
# line 376 "plot.yacc"
{
				(text[curtext])->align = left;
			} break;
case 111:
# line 380 "plot.yacc"
{
				(text[curtext])->align = center;
			} break;
case 112:
# line 384 "plot.yacc"
{
				(text[curtext])->align = right;
			} break;
case 113:
# line 393 "plot.yacc"
{
				if (curtext == -1) notexterr();
				else (text[curtext])->font = yylval;
			} break;
case 114:
# line 400 "plot.yacc"
{
				MirrorAxes = TRUE;
				MirrorAxisNumbers = TRUE;
				MirrorAxisLabels = TRUE;
			} break;
case 115:
# line 408 "plot.yacc"
{
				MirrorAxes = TRUE;
				MirrorAxisNumbers = FALSE;
			} break;
case 116:
# line 415 "plot.yacc"
{
				MirrorAxes = TRUE;
				MirrorAxisLabels = FALSE;
			} break;
case 117:
# line 422 "plot.yacc"
{
				NewOrigin = TRUE;
				origin[xpt] = atof(yytext);
			} break;
case 118:
# line 427 "plot.yacc"
{
				origin[ypt] = atof(yytext);
			} break;
case 119:
# line 433 "plot.yacc"
{
				MinticNos = FALSE;
			} break;
case 120:
# line 439 "plot.yacc"
{
				ShowMinTics = FALSE;
			} break;
case 121:
# line 445 "plot.yacc"
{
				ShowXNos = FALSE;
			} break;
case 122:
# line 451 "plot.yacc"
{
				ShowYNos = FALSE;
			} break;
case 123:
# line 457 "plot.yacc"
{
/* relic of ancient times. Not present in man page */
				ShowXLine = FALSE;
			} break;
case 124:
# line 464 "plot.yacc"
{
/* relic of ancient times. Not present in man page */
				ShowYLine = FALSE;
			} break;
case 125:
# line 471 "plot.yacc"
{
				ShowAxes = FALSE;
			} break;
case 126:
# line 477 "plot.yacc"
{	
				newcurveproc();
			 } break;
case 127:
# line 483 "plot.yacc"
{
				if (curcur < 0) nocurverr();
				(curves[curcur])->include = FALSE;
				/*may want to do curcur-1 here*/
			} break;
case 128:
# line 491 "plot.yacc"
{
				if (curcur < 0) nocurverr();
				(curves[curcur])->showConf = TRUE;
			} break;
case 129:
# line 498 "plot.yacc"
{
				if (curcur < 0) nocurverr();
			} break;
case 130:
# line 502 "plot.yacc"
{
				(curves[curcur])->thick = FFthick(yylval);
			} break;
case 131:
# line 508 "plot.yacc"
{
/*				strcpy(pstr,yytext);*/
			} break;
case 133:
# line 515 "plot.yacc"
{
				if (curcur < 0) nocurverr();
				strcat((curves[curcur])->label, yytext);
			} break;
case 134:
# line 520 "plot.yacc"
{
				if (curcur < 0) nocurverr();
				strcat((curves[curcur])->label, yytext);
			} break;
case 135:
# line 527 "plot.yacc"
{
				if (curcur < 0) nocurverr();
			} break;
case 137:
# line 534 "plot.yacc"
{(curves[curcur])->type = none;} break;
case 138:
# line 536 "plot.yacc"
{(curves[curcur])->type = solid;} break;
case 139:
# line 538 "plot.yacc"
{(curves[curcur])->type = dashes;} break;
case 140:
# line 540 "plot.yacc"
{(curves[curcur])->type = stipple;} break;
case 141:
# line 542 "plot.yacc"
{(curves[curcur])->type = dots;} break;
case 142:
# line 544 "plot.yacc"
{(curves[curcur])->type = pat;} break;
case 143:
# line 546 "plot.yacc"
{
				handlefillproc();
			} break;
case 144:
# line 550 "plot.yacc"
{
			    (curves[curcur])->type = solid;
			    (curves[curcur])->thick = 
				(curves[curcur])->thick * boldthickmul;
			} break;
case 145:
# line 559 "plot.yacc"
{
				if (curcur < 0) nocurverr();
			} break;
case 147:
# line 566 "plot.yacc"
{(curves[curcur])->symbolsize = atoi(yytext);} break;
case 149:
# line 571 "plot.yacc"
{(curves[curcur])->symbol = nonesymbol;} break;
case 150:
# line 573 "plot.yacc"
{(curves[curcur])->symbol = cross;} break;
case 151:
# line 575 "plot.yacc"
{(curves[curcur])->symbol = triangle;} break;
case 152:
# line 577 "plot.yacc"
{(curves[curcur])->symbol = trianglefilled;} break;
case 153:
# line 579 "plot.yacc"
{(curves[curcur])->symbol = diamond;} break;
case 154:
# line 581 "plot.yacc"
{(curves[curcur])->symbol = diamondfilled;} break;
case 155:
# line 583 "plot.yacc"
{(curves[curcur])->symbol = square;} break;
case 156:
# line 585 "plot.yacc"
{(curves[curcur])->symbol = square;} break;
case 157:
# line 587 "plot.yacc"
{(curves[curcur])->symbol = squarefilled;} break;
case 158:
# line 589 "plot.yacc"
{(curves[curcur])->symbol = squarefilled;} break;
case 159:
# line 591 "plot.yacc"
{(curves[curcur])->symbol = rectangle;} break;
case 160:
# line 593 "plot.yacc"
{(curves[curcur])->symbol = rectanglefilled;} break;
case 161:
# line 595 "plot.yacc"
{(curves[curcur])->symbol = circle;} break;
case 162:
# line 597 "plot.yacc"
{(curves[curcur])->symbol = circlefilled;} break;
case 163:
# line 599 "plot.yacc"
{(curves[curcur])->symbol = bullet;} break;
case 164:
# line 601 "plot.yacc"
{(curves[curcur])->symbol = plus;} break;
case 165:
# line 603 "plot.yacc"
{(curves[curcur])->symbol = star;} break;
case 166:
# line 607 "plot.yacc"
{
				if (curcur < 0) nocurverr();
			} break;
case 168:
# line 614 "plot.yacc"
{
				(curves[curcur])->interp = linearinterp;
			} break;
case 169:
# line 618 "plot.yacc"
{
				(curves[curcur])->interp = xhistogram;
				keySpacingMul = keySpacingMul ;/*  * 1.5; */
			} break;
case 170:
# line 623 "plot.yacc"
{
				(curves[curcur])->interp = lregression;
			} break;
case 171:
# line 627 "plot.yacc"
{
				(curves[curcur])->interp = step;
			} break;
case 172:
# line 631 "plot.yacc"
{
				(curves[curcur])->interp = smooth;
			} break;
case 173:
# line 635 "plot.yacc"
{
				(curves[curcur])->interp = smooth;
			} break;
case 174:
# line 639 "plot.yacc"
{
				(curves[curcur])->interp = yhistogram;
				keySpacingMul = keySpacingMul;/* * 1.5; */
			} break;
case 175:
# line 647 "plot.yacc"
{
				if (curcur < 0) nocurverr();
				(curves[curcur])->mat.grayset = TRUE;
				(curves[curcur])->gray = atof(yytext);
			} break;
case 176:
# line 655 "plot.yacc"
{
				if (curcur < 0) nocurverr();
				(curves[curcur])->mat.showline = FALSE;
			} break;
case 177:
# line 662 "plot.yacc"
{
				if (curcur < 0) nocurverr();
				(curves[curcur])->mat.matset = TRUE;
				(curves[curcur])->mat.freq = atof(yytext);
			} break;
case 178:
# line 668 "plot.yacc"
{
				(curves[curcur])->mat.ang = atof(yytext);
			} break;
case 179:
# line 672 "plot.yacc"
{
				(curves[curcur])->mat.indx = atoi(yytext);
			} break;
case 180:
# line 678 "plot.yacc"
{
				if (curcur < 0) nocurverr();
			} break;
case 185:
# line 691 "plot.yacc"
{
				addPointsPair1();
			} break;
case 186:
# line 696 "plot.yacc"
{
				addPointsPair2();
			} break;
case 188:
# line 703 "plot.yacc"
{
				addPointsConf();
			} break;
case 193:
# line 715 "plot.yacc"
{strcat(axis[xpt].label, yytext);} break;
case 194:
# line 717 "plot.yacc"
{strcat(axis[xpt].label, yytext);} break;
case 195:
# line 721 "plot.yacc"
{
				axis[xpt].font = yylval;
			} break;
case 196:
# line 727 "plot.yacc"
{
				axis[xpt].axismax = atof(yytext);
				limits[xpt][maxval] = axis[xpt].axismax;
			} break;
case 197:
# line 734 "plot.yacc"
{
				axis[xpt].axismin = atof(yytext);
				limits[xpt][minval] = axis[xpt].axismin;
			} break;
case 198:
# line 740 "plot.yacc"
{
				axis[xpt].unit = atof(yytext);
			} break;
case 200:
# line 749 "plot.yacc"
{axis[xpt].scale.type = linear;} break;
case 201:
# line 751 "plot.yacc"
{
				axis[xpt].scale.type = logstype;
				axis[xpt].scale.base = 10.0; /* def logbase */
			} break;
case 202:
# line 758 "plot.yacc"
{
				axis[xpt].scale.base = atof(yytext);
			} break;
case 203:
# line 765 "plot.yacc"
{
				axis[xpt].interval = atof(yytext);
			} break;
case 205:
# line 774 "plot.yacc"
{
				axis[xpt].numberstyle = integer;
			} break;
case 206:
# line 778 "plot.yacc"
{
				axis[xpt].numberstyle = floating;
			} break;
case 207:
# line 782 "plot.yacc"
{
				axis[xpt].numberstyle = scientific;
			} break;
case 208:
# line 786 "plot.yacc"
{
				axis[xpt].numberstyle = exponent;
			} break;
case 209:
# line 792 "plot.yacc"
{
				axis[xpt].signif = atof(yytext);
			} break;
case 210:
# line 796 "plot.yacc"
{
				axis[xpt].signif = 1;
			} break;
case 213:
# line 806 "plot.yacc"
{strcat(axis[ypt].label, yytext);} break;
case 214:
# line 808 "plot.yacc"
{strcat(axis[ypt].label, yytext);} break;
case 215:
# line 812 "plot.yacc"
{
				axis[ypt].font = yylval;
			} break;
case 216:
# line 818 "plot.yacc"
{
				axis[ypt].axismax = atof(yytext);
				limits[ypt][maxval] = axis[ypt].axismax;
			} break;
case 217:
# line 825 "plot.yacc"
{
				axis[ypt].axismin = atof(yytext);
				limits[ypt][minval] = axis[ypt].axismin;
			} break;
case 218:
# line 831 "plot.yacc"
{
				axis[ypt].unit = atof(yytext);
			} break;
case 220:
# line 840 "plot.yacc"
{axis[ypt].scale.type = linear;} break;
case 221:
# line 842 "plot.yacc"
{
				axis[ypt].scale.type = logstype;
				axis[ypt].scale.base = 10.0; /* def logbase */
			} break;
case 222:
# line 849 "plot.yacc"
{
				axis[ypt].scale.base = atof(yytext);
			} break;
case 223:
# line 855 "plot.yacc"
{
				axis[ypt].interval = atof(yytext);
			} break;
case 225:
# line 864 "plot.yacc"
{
				axis[ypt].numberstyle = integer;
			} break;
case 226:
# line 868 "plot.yacc"
{
				axis[ypt].numberstyle = floating;
			} break;
case 227:
# line 872 "plot.yacc"
{
				axis[ypt].numberstyle = scientific;
			} break;
case 228:
# line 876 "plot.yacc"
{
				axis[ypt].numberstyle = exponent;
			} break;
case 229:
# line 882 "plot.yacc"
{
				axis[ypt].signif = atof(yytext);
			} break;
case 230:
# line 886 "plot.yacc"
{
				axis[ypt].signif = 1;
			} break;
		}
		goto yystack;  /* stack new state and value */

	}
