/* $Header: spy.c,v 1.7 88/07/31 08:48:27 toddb Exp $ */
/* spy11.c -- display a region of the screen in a window with magnification.
 *            X-11 version
 */
#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/keysym.h>
#include "square.cursor"
#include "square_mask.cursor"

/* NUM_OF_BLOCKS MUST BE AN ODD NUMBER */
#define NUM_OF_BLOCKS 15
#define BORDER 5
#define SIZE_X 30
#define SIZE_Y 30
#define LIMIT (NUM_OF_BLOCKS / 2)
#define SCREEN_WIDTH  DisplayWidth(pDpy, DefaultScreen(pDpy))
#define SCREEN_HEIGHT DisplayHeight(pDpy, DefaultScreen(pDpy))
#define WWIDTH  ( SIZE_X * NUM_OF_BLOCKS)
#define WHEIGHT ( SIZE_Y * NUM_OF_BLOCKS)
#define WX (SCREEN_WIDTH  - ( WWIDTH  + ( 2 * BORDER )))
#define WY (SCREEN_HEIGHT - ( WHEIGHT + ( 2 * BORDER ))) 

typedef struct _graphics {
    int ready;			/* whether we are ready yet. */
    int info_height;		/* height of coordinate read-out region */
    int	border_width;		/* width of window border */
    int	width, height;		/* width and height of window */
    int	windowX,windowY;	/* x and y coord of window */
    int	nblocks, halfblocks;	/* number of blocks in x and y */
    int	bwidth, bheight;	/* block width, block height */
    unsigned long	*zdata;
    unsigned long	*zdatacurrent;
    int x,y;			/* coord of area to draw */
    int shownumbers;
    int oldshownumbers;
    int numplanes;
    int whitepixel;
    int blackpixel;
} GraphicsDimension;
	
GraphicsDimension	gd;

/* The defines for XK_KP_* do not appear to be correct for now
 * so we define equivalent XXK_KP_* codes.
 */

#define XXK_KP_0  72
#define XXK_KP_1  73
#define XXK_KP_2  74
#define XXK_KP_3  75
#define XXK_KP_4  76
#define XXK_KP_5  77
#define XXK_KP_6  78
#define XXK_KP_7  79
#define XXK_KP_8  80
#define XXK_KP_9  81
#define XXK_KP_Enter     68
#define XXK_KP_Separator 69
#define XXK_KP_Subtract  70
#define XXK_KP_Decimal   71


#define IsKeypadKey(keycode)	(keycode >= XXK_KP_Enter && \
		                 keycode <= XXK_KP_9)

unsigned char  Characters[16] =
 { '0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F' };
unsigned char  valueString[2];

int		interest = Button1MotionMask
			 | ButtonPressMask
			 | Button2MotionMask
			 | KeyPressMask;
unsigned char	title[30];
Display		*pDpy;
Window		wtemp,
		cursorWindow,
		graphicsWindow,
		rootW;
GC		gc;

StartConnectionToServer(argc, argv)
int     argc;
char    *argv[];
{
    char *display;
    int i, syncit = 0;

    display = NULL;
    gd.nblocks = NUM_OF_BLOCKS;
    gd.halfblocks = gd.nblocks / 2;
    for(i = 1; i < argc; i++) {
        if(index(argv[i], ':') != NULL)
            display = argv[i];
	else if (strcmp(argv[i], "-s") == 0)
		syncit = 1;
	else if (strncmp(argv[i], "-b", 2) == 0) {
	    gd.nblocks = atoi(argv[i]+2);
	    if ((gd.nblocks & 0x1) == 0)
		gd.nblocks++;
	    if (gd.nblocks == 1)
		gd.nblocks = 3;
	    gd.halfblocks = gd.nblocks / 2;
	}
    }
    if (!(pDpy = XOpenDisplay(display))) {
       perror("Cannot open display\n");
       exit(0);
    }
    if (syncit)
	XSynchronize(pDpy, 1);
}

main(argc, argv)
    int argc;
    char *argv[];
{
    XEvent	ev;

    gd.oldshownumbers = gd.shownumbers = 0;
    StartConnectionToServer(argc, argv);

    rootW = XRootWindow(pDpy,0);

    graphicsWindow = GraphicsWindow();
    cursorWindow = CursorWindow();
    gc = XCreateGC(pDpy, graphicsWindow, 0, 0);
    MakeSpyCursor();
    XFlush(pDpy);

    while(1) {
	XNextEvent(pDpy, &ev);
	gd.x = ev.xbutton.x_root;
	gd.y = ev.xbutton.y_root;
        switch (ev.type) {
	case Expose:
	    DrawGrid(&ev.xexpose);
	    break;
	case ButtonPress:
	    switch (ev.xbutton.button) {
	    case Button3: /* right button ends the program */
		exit(0);
	    case Button2:
		gd.shownumbers = 0;
		PaintBigPixels();
		break;
	    case Button1:
		gd.shownumbers = 1;
		PaintBigPixels();
		break;
	    }
	    break;
	case KeyPress:
	    if( MoveCursor( ev.xkey.keycode ) != 0)
		PaintBigPixels();
	    break;
	case MotionNotify:
	    GetLastMotionEvent(&ev);
	    gd.x = ev.xbutton.x_root;
	    gd.y = ev.xbutton.y_root;
	    PaintBigPixels();
	    break;
	}
    }
}

/*ARGSUSED*/
IsMotionEvent(pDpy, ev, dummy)
    Display	*pDpy;
    XEvent	*ev;
{
    if (ev->type == MotionNotify)
	return(1);
    return(0);
}

GetLastMotionEvent(ev)
    XEvent	*ev;
{
    XEvent	evcheck;

    while (XCheckIfEvent(pDpy, &evcheck, IsMotionEvent, 0))
	bcopy(&evcheck, ev, sizeof(XEvent));
}

EventNotTooOld(ev)
    XMotionEvent	*ev;
{
    struct timeval tv;
    static struct timeval lastTime;
    static Time	milliNow;

    if (milliNow == 0) {
	gettimeofday(&lastTime, NULL);
	milliNow = ev->time;
	return(1);
    }
    gettimeofday(&tv, NULL);
    milliNow += (tv.tv_sec - lastTime.tv_sec) * 1000;
    if (tv.tv_usec < lastTime.tv_usec)
	milliNow -= ((lastTime.tv_usec - tv.tv_usec) / 1000);
    else
	milliNow += ((tv.tv_usec - lastTime.tv_usec) / 1000);

    lastTime = tv;

    if (milliNow - ev->time < 100)
	return(1);
    return(0);
}

CursorWindow()
{
    Visual visual;
    XSetWindowAttributes xswa;
    int	wid;
    char	*windowName = "";

    xswa.event_mask = interest;
    xswa.override_redirect = 1;
    visual.visualid = CopyFromParent;
    wid = XCreateWindow(pDpy, RootWindow(pDpy, 0), 0, 0,
	SCREEN_WIDTH, SCREEN_HEIGHT,
        0, 0, InputOnly, &visual,
        CWOverrideRedirect|CWEventMask,  &xswa);

    XChangeProperty(pDpy, 
        wid, XA_WM_NAME, XA_STRING, 8, PropModeReplace,
        windowName, strlen(windowName));

    XMapWindow(pDpy, wid);
    return (wid);
}

GraphicsWindow()
{
    Visual visual;
    XSetWindowAttributes xswa;
    int	wid;
    char	*windowName = "";

    gd.numplanes  = XPlanesOfScreen(DefaultScreenOfDisplay(pDpy)),
    gd.blackpixel = 0x0;
    if(gd.numplanes == 4)
	gd.whitepixel = 0xF;
    else
	gd.whitepixel = 0x1;
    xswa.event_mask = interest | ExposureMask;
    xswa.background_pixel = gd.whitepixel;
    visual.visualid = CopyFromParent;
    wid = XCreateWindow(pDpy, RootWindow(pDpy, 0), WX, WY,
	WWIDTH, WHEIGHT,
        BORDER, DefaultDepth(pDpy, 0), InputOutput, &visual,
        CWBackPixel|CWEventMask,  &xswa);

    XChangeProperty(pDpy, 
        wid, XA_WM_NAME, XA_STRING, 8, PropModeReplace,
        windowName, strlen(windowName));

    XMapWindow(pDpy, wid);
    return (wid);
}

MakeSpyCursor()
{
    Cursor cursor;
    Pixmap bmCursorSrc,bmCursorMsk;
    XColor	whiteColor,
		blackColor;

    whiteColor.pixel = gd.whitepixel;
    whiteColor.flags = DoRed | DoGreen | DoBlue;
    blackColor.pixel = gd.blackpixel;
    blackColor.flags = DoRed | DoGreen | DoBlue;
    
    XQueryColor(pDpy, DefaultColormap(pDpy, DefaultScreen(pDpy)), &blackColor);
    XQueryColor(pDpy, DefaultColormap(pDpy, DefaultScreen(pDpy)), &whiteColor);

    bmCursorSrc = XCreateBitmapFromData(pDpy, graphicsWindow, square_bits,
				     square_width,square_height);
    bmCursorMsk = XCreateBitmapFromData(pDpy, graphicsWindow, square_mask_bits,
				     square_width,square_height);

    cursor = XCreatePixmapCursor(pDpy, bmCursorSrc,bmCursorMsk,
				&whiteColor,&blackColor,
			        square_x_hot,square_y_hot);

    XDefineCursor(pDpy, cursorWindow, cursor);
    XDefineCursor(pDpy, graphicsWindow, cursor);
}

DrawGrid(ev)
    XExposeEvent    *ev;
{
    int	i;

    if (ev->count || ev->x || ev->y)
	return;
    gd.width = ev->width;
    gd.height = ev->height;
    gd.windowX = ev->x;
    gd.windowY = ev->y;
    gd.info_height = 13;
    gd.bwidth = ev->width/gd.nblocks;
    gd.bheight = (ev->height - gd.info_height)/gd.nblocks;
    if (gd.zdata)
	free(gd.zdata);
    gd.zdata = (unsigned long *)
	malloc(gd.nblocks*gd.nblocks*sizeof(unsigned long));
    if (gd.zdatacurrent)
	free(gd.zdatacurrent);
    gd.zdatacurrent = NULL;

    gd.ready = 1;

    XSetForeground(pDpy, gc, gd.blackpixel);
    for(i = -gd.halfblocks; i < gd.halfblocks + 1  ; i++) {
		DrawLine((i+gd.halfblocks)*gd.bwidth,gd.info_height,
				(i+gd.halfblocks)*gd.bwidth,
			        gd.height);
    }
    for(i = -gd.halfblocks; i < gd.halfblocks + 1; i++) {
		DrawLine(0, (i+gd.halfblocks)*gd.bheight+gd.info_height,
				 gd.width,
			         (i+gd.halfblocks)*gd.bheight+gd.info_height);

    }
    DrawLine(gd.halfblocks*gd.bwidth-1, gd.info_height,
		      (gd.halfblocks)*gd.bwidth-1, gd.height);
    DrawLine((1+gd.halfblocks)*gd.bwidth-1, gd.info_height,
		      (1+gd.halfblocks)*gd.bwidth-1, gd.height);
    DrawLine(0, gd.halfblocks*gd.bheight-1+gd.info_height,
		     gd.width, (gd.halfblocks)*gd.bheight-1+gd.info_height);
    DrawLine(0, (1+gd.halfblocks)*gd.bheight-1+gd.info_height,
		     gd.width, (1+gd.halfblocks)*gd.bheight-1+gd.info_height);
    XFlush(pDpy);
}

DrawLine(x1, y1, x2, y2)
{
    XDrawLine(pDpy, graphicsWindow, gc,  x1,y1,x2,y2);
}

GetImage(x, y, width, height)
    int	x, y, width, height;
{
    XImage	*image;
    int	i, j, k;
    long planemsk;

    planemsk = ((unsigned long) ~0) >> (32 - gd.numplanes);

    image = XGetImage(pDpy, rootW, x, y, width, height, planemsk,
	    ZPixmap);
    for(k=j=0; j < gd.nblocks; j++) {
	for(i=0; i < gd.nblocks; i++) {
	    gd.zdata[k++] = XGetPixel(image,i,j);
	}
    }
    /* if first time, initialize everything to "different" */
    if (gd.zdatacurrent == NULL) {
	gd.zdatacurrent = (unsigned long *)
		malloc(gd.nblocks*gd.nblocks*sizeof(unsigned long));
	for(k=j=0; j < gd.nblocks; j++) {
	    for(i=0; i < gd.nblocks; i++, k++) {
		gd.zdatacurrent[k] = (~gd.zdata[k]);
	    }
	}
    }
    XDestroyImage(image);
}


PaintBigPixels()
{
    int i,j,k,c,ind,posX,posY,sizeX,sizeY,value;
    unsigned long	*ppold, *ppnew;
    XImage		*image,*pImage;
    int biasX,biasY;

    if(gd.ready == 0)
	return;

    ConstrainCursor();

    /* get the image */
    GetImage(gd.x-gd.halfblocks, gd.y-gd.halfblocks, gd.nblocks,gd.nblocks);

    ppnew = &gd.zdata[0];
    ppold = &gd.zdatacurrent[0];
    for(j = -gd.halfblocks; j < gd.halfblocks + 1; j++) {
	for( i = -gd.halfblocks; i < gd.halfblocks+1  ; i++,ppnew++,*ppold++) {
	    value = (int) *ppnew;
	    if ((value == *ppold) && (gd.oldshownumbers == gd.shownumbers))
		continue;
	    *ppold = value;
	    posX = (i+gd.halfblocks)*gd.bwidth+1;
	    posY = (j+gd.halfblocks)*gd.bheight+1+gd.info_height;
	    sizeX = gd.bwidth-2;
	    sizeY = gd.bheight-2;
	    if((i == 0) || (j == 0)) {
		posX++;
		posY++;
		sizeX -= 2;
		sizeY -= 2;
	    } else {
		if(i== 1) {
		    posX++;
		    sizeX--;
		} 
		if(i== -1) {
		    sizeX--;
		} 
		if(j== 1) {
		    posY++;
		    sizeY--;
		} 
	    }
	    XSetForeground(pDpy, gc,value);
	    XFillRectangle(pDpy, graphicsWindow, gc,posX,posY,sizeX,sizeY);
	    if(gd.shownumbers) {
		if( ((gd.numplanes == 4) && (value < 8)) ||
		    ((gd.numplanes == 8) && (value < 128)) ) {
		    XSetForeground(pDpy, gc, gd.whitepixel);
		    XSetBackground(pDpy, gc, gd.blackpixel);
		} else {
		    XSetForeground(pDpy, gc, gd.blackpixel);
		    XSetBackground(pDpy, gc, gd.whitepixel);
		}
		biasX = (sizeX - 8) >> 1;
		biasY = ((sizeY - 13) >> 1)+7;
		valueString[0] = Characters[(value >> 4) & 0xF];
		valueString[1] = Characters[value & 0xF];
		if(gd.numplanes == 4)
		    XDrawImageString(pDpy, graphicsWindow,gc,
				    posX+biasX, posY+biasY,
				    &valueString[1],1);
		else
		    XDrawImageString(pDpy, graphicsWindow,gc,
				    posX+biasX, posY+biasY,
				    valueString,2);
	    }
	}
    }
    XSetForeground(pDpy, gc, gd.blackpixel);
    XSetBackground(pDpy, gc, gd.whitepixel);
    sprintf(title,"UL %4d %4d",gd.x-7,gd.y-7);
    XDrawImageString(pDpy, graphicsWindow,gc,
			2, gd.info_height-4, title, 12);
    sprintf(title,"CN %4d %4d",gd.x,gd.y);
    XDrawImageString(pDpy, graphicsWindow,gc,
			(gd.width-12*6)>>1, gd.info_height-4, title, 12);
    sprintf(title,"LR %4d %4d",gd.x+7,gd.y+7);
    XDrawImageString(pDpy, graphicsWindow,gc,
			(gd.width-12*6-2), gd.info_height-4, title, 12);

    XSync(pDpy);
    gd.oldshownumbers = gd.shownumbers;
}

MoveCursor(keycode)
{
    int root_x_return, root_y_return;
    unsigned int	mask_return;
    Window	root_return, child_return;

    if (IsKeypadKey(keycode))   {
	XQueryPointer(pDpy, cursorWindow, &root_return,&child_return,
		  &root_x_return,&root_y_return,
		  &gd.x, &gd.y, &mask_return);
	switch (keycode)  {
	case XXK_KP_1 : gd.x--; gd.y++; break;
	case XXK_KP_2 :         gd.y++; break;
	case XXK_KP_3 : gd.x++; gd.y++; break;
	case XXK_KP_4 : gd.x--;         break;
	case XXK_KP_6 : gd.x++;         break;
	case XXK_KP_7 : gd.x--; gd.y--; break;
	case XXK_KP_8 :         gd.y--; break;
	case XXK_KP_9 : gd.x++; gd.y--; break;
	case XXK_KP_5 : gd.shownumbers = (gd.oldshownumbers == 0); break;
	case XXK_KP_Separator :
	case XXK_KP_0 :
	case XXK_KP_Decimal :
	case XXK_KP_Subtract :
	case XXK_KP_Enter:  XBell(pDpy, 100); return 0;
	}
        XWarpPointer(pDpy,None,rootW,0,0,0,0, gd.x, gd.y);
	return 1;
    }
    return 0;
}

ConstrainCursor()
{
    int	warpFlag = 0;

    if(gd.x < gd.halfblocks) {
	gd.x = gd.halfblocks;
	warpFlag = 1;
    }
    if(gd.x > SCREEN_WIDTH - 1 - gd.halfblocks) {
	gd.x = SCREEN_WIDTH - 1 - gd.halfblocks;
	warpFlag = 1;
    }
    if(gd.y < gd.halfblocks) {
	gd.y = gd.halfblocks;
	warpFlag = 1;
    }
    if(gd.y > SCREEN_HEIGHT - 1 - gd.halfblocks) {
	gd.y = SCREEN_HEIGHT - 1 - gd.halfblocks;
	warpFlag = 1;
    }
    if(warpFlag) {
	XWarpPointer(pDpy,None,rootW,0,0,0,0,gd.x,gd.y);
	/* another event will be generated so we throw this one away */
	return;
    }
}

/*
 * hack to pull in the resource manager.
 */
static hack()
{
	XGetErrorText();
}
#ifdef ZZZ
if(ImageFlag == 0) {
    pImage = XCreateImage(pDpy,	    /* display */
      DefaultVisual(pDpy, DefaultScreen(pDpy)),	    /* visual */
      4,		    /* depth */
      ZPixmap,		    /* format */
      0,		    /* offset */
      DDX,		    /* data */
      16,		    /* width */
      16,		    /* height */
      8,		    /* bitmap_pad */
      0			    /* bytes_per_line */
    );
#endif ZZZ
