/*
 * Copyright (c) 1987 University of Maryland Department of Computer Science.
 * All rights reserved.  Permission to copy for any purpose is hereby granted
 * so long as this copyright notice remains intact.
 */

#ifndef lint
static char rcsid[] = "$Header: fixfix.c,v 1.2 88/02/12 12:56:28 jim Exp $";
#endif

/*
 * fixfix - fix the number of FIXes for a particular character in
 * a particular font.
 *
 * Compilation:
 %	cc -O -o fixfix fixfix.c
 */

#include <stdio.h>

main (argc, argv)
int argc;
register char **argv;
{
	register int i, fd, newn, t;
	static char buf[4];

	if (argc != 4) {
		fprintf (stderr, "usage: fixfix font index fixes\n");
		exit (1);
	}
	if ((fd = open (argv[1], 2)) < 0) {
		perror (argv[1]);
		exit (1);
	}
	i = atoi (argv[2]);
	if (i < 0 || i > 127) {
		fprintf (stderr, "%d: invalid char index (<0 || >127)", i);
		exit (1);
	}
	newn = atoi (argv[3]);
	(void) lseek (fd, 0L, 2);
	(void) lseek (fd, -2068L + 16L*i + 12L, 1);
	if (read (fd, buf, 4) != 4) {
		perror ("read");
		exit (1);
	}
	t = get (buf);
	printf ("fixfix: char %d: old size = %d\n", i, t);
	put (newn, buf);
	(void) lseek (fd, -4L, 1);
	if (write (fd, buf, 4) != 4) {
		perror ("write");
		exit (1);
	}
	exit (0);
}

int
get (buf)
register unsigned char *buf;
{
	return (buf[0] << 24) | (buf[1] << 16) | (buf[2] << 8) | buf[3];
}

put (n, buf)
register int n;
register unsigned char *buf;
{
	buf[0] = n >> 24;
	buf[1] = n >> 16;
	buf[2] = n >> 8;
	buf[3] = n;
}
