/*
 *	$Source: /mit/eichin/xdvi/RCS/path_open.c,v $
 *	$Author: eichin $
 *	$Locker:  $
 *	$Header: path_open.c,v 1.4 88/07/28 11:47:00 eichin Exp $
 *
 *	$Log:	path_open.c,v $
 * Revision 1.4  88/07/28  11:47:00  eichin
 * fixed next_path bugs. it has been tested now.
 * 
 * Revision 1.3  88/07/28  09:59:56  eichin
 * replace execat (which was really proprietary) with next_path, which
 * although much slower, is quite clear about what it is doing. Making it
 * efficient would waste a lot of time, as other real xdvi stuff needs it
 * more.
 * 
 * Revision 1.2  88/07/28  09:48:25  eichin
 * added stuff from lcs for font subdirectories.
 * 
 * Revision 1.1  87/05/14  11:00:44  eichin
 * Initial revision
 * 
 * 
 */
#ifndef lint
static char *rcsid_path_open_c = "$Header: path_open.c,v 1.4 88/07/28 11:47:00 eichin Exp $";
#endif	lint
/*
 * path open - search for a file in a given path.
 *		-Mark Eichin...from my other random toolkits.5/14/1987
 */
#include <stdio.h>
#include <sys/types.h>
#include <sys/dir.h>

char *index(), *rindex();

/*
 * next_path
 * returns the name relative to the first component of 'path' in
 * 'fullname' and returns the path without the first component.
 */
char *next_path(path, name, fullname)
     char *path, *name, *fullname;
{
  char *scan;

  scan = index(path,':');
  if(scan)
    {
      /* not the last component of the path, only take the first one */
      strncpy(fullname, path, scan-path);
      fullname[scan-path] = '\0';
    }
  else
    {
      /* the last path component, take the whole thing */
      strcpy(fullname, path);
    }
  strcat(fullname, "/");	/* append a slash, they can be redundant */
  strcat(fullname, name);	/* and then the name */

  return(scan?(scan+1):NULL);
}

FILE *fopen_path(pathvar,name,stat)
     register char *pathvar, *name, *stat;
{
  char tname[128];
  register char *cp = index(name,'/')?"":pathvar;
  FILE *fil;

  do {
    cp=next_path(cp, name, tname);
    if((fil=fopen(tname,stat))!=NULL)
      {
	return(fil);
      }
  } while(cp);
  return(NULL);
}

FILE *fopen_font_path(pathvar,name,stat)
     register char *pathvar, *name, *stat;
{
  /* The goal here is to try to open SOMETHING, whatever it really is */
  char tname[128], family[128], *dotsplit;
  int point, mag, len;
  register char *cp = index(name,'/')?"":pathvar;
  FILE *fil;
  DIR *dirstr;
  struct direct *dirrec;
  char qf[128], bestfil[128]; int qpt, qmag;
  int delp, delm;
  int mindelp=99999999, mindelm=99999999; int bestpt, bestmag;

  do {
    cp=next_path(cp, name, tname);	/* try normal path extension */
    if((fil=fopen(tname,stat))!=NULL)
      {
	return(fil);
      }
    /*
     * Some systems store the fonts in directories by family, and then
     * each size/scale within that directory... so we strip off the
     * extension, then put the whole file name back on. This should
     * really be done with something like fontdesc files.
     * (from rgcote and shep@lcs.mit.edu, fixed and installed by
     * eichin@athena.mit.edu)
     */
    dotsplit = rindex(tname, '.');
    *dotsplit++ = '/';
    *dotsplit = '\0';
    strcat(tname, name);
    if ((fil = fopen(tname,stat)) != NULL)
      {
	return(fil);
      }
  } while(cp);

  if(index(name,'/'))
    return(NULL);		/* never try again, if absolute */
  /* if we get here, we must look real hard... */

  cp = pathvar;
  point = -1;
  mag = -1;
  (void) sscanf(name,"%[^0123456789.]%d.%d",family,&point,&mag);


  len=strlen(family);
  do {
    cp=next_path(cp,"",tname);
    dirstr=opendir(tname);
#ifdef DEBUG
    fprintf(stderr,"This dir:%s\n",tname);
    fprintf(stderr,"dirstr=%x,dir=<%s>\n",dirstr,tname);
    if(!dirstr) perror(tname);	/* for discovering too many open files. */
#endif DEBUG
    if(dirstr)
      {
	for(dirrec=readdir(dirstr); dirrec!=NULL; dirrec=readdir(dirstr))
	  {
	    if(dirrec->d_namlen>=len && !strncmp(dirrec->d_name,family,len))
	      {
#ifdef DEBUG
		fprintf(stderr,"Font:%s\n",dirrec->d_name);
#endif DEBUG
		qpt=(-1); qmag=(-1);
		(void) sscanf(dirrec->d_name,"%[^0123456789.]%d.%d",
			      qf,&qpt,&qmag);
		delp=abs(point-qpt); delm=abs(mag-qmag); /* mag from??? */
		if ((delp < mindelp) || (delp == mindelp && delm < mindelm))
		  {
		    mindelp=delp; mindelm=delm;
		    bestpt=qpt; bestmag=qmag;
		    strcpy(bestfil,tname);
		    strcat(bestfil,"/");
		    strcat(bestfil,dirrec->d_name);
#ifdef DEBUG
		    fprintf(stderr,"Current best:%s\n",bestfil);
#endif DEBUG
		  }
	      }
	  }
	closedir(dirstr);
      }
  } while(cp);
  if(mindelp==99999999) return(NULL);
  else 
    {
      fprintf(stderr,"Using <%s> instead of <%s>, continuing.\n",
	      rindex(bestfil,'/'),
	      name);
      return(fopen(bestfil,stat));
    }
}
