/*  Author: Philip R. Thompson
*   Address:  phils@athena.mit.edu, 9-514 
*   Note:  size of header is 1024 bytes
*   $Header: ImageHeader.h,v 1.2 88/08/29 11:03:23 jim Exp $
*   $Date: 88/08/29 11:03:23 $
*   $Source: /usr/expo/X/src/contrib/xim/RCS/ImageHeader.h,v $
*/

#define IMAGE_VERSION    2
#define MAX_MAP        256

typedef struct ImageHeader {
    char file_version[8];   /* header version */
    char header_size[8];    /* Size of file header (bytes)  */
    char pixmap_width[8];   /* Width of the raster image  */
    char pixmap_height[8];  /* Height of the raster imgage (lines)  */
    char num_colors[8];     /* actual number of colors in file  */
    char runlength[8];      /* runlength encoded flag */
    char num_channels[8];   /* 0 or 1(use cmap), 3(rgb) or 4(+alpha) */
    char data_size[8];      /* size of runlength data - unimplemented */
    char creator[48];       /* Name of who made it  */
    char date[32];          /* Date and time image was made  */
    char creat_program[8];  /* program that created this file  */
    char view_info[104];    /* viewing parameters for this image  */
    unsigned char c_map[256][3];  /* RGB values of the pixmap indices */
} ImageHeader;

typedef struct _run {
    unsigned short x, y;
    unsigned char length, color;
} PixelRun;

/* Note:
* - Everything is in chars to maintain easily portability across
* machines.
* - Up to 32 bits per pixel (rgb+alpha) may now be stored.
* If num_channel == 1 the colormap is used on all the buffers that 
* follow.
* If num_channel > 1 the image is assumed to have 24 or 32 bits/pixel.
* Red, green, blue and alpha channels are in the respective buffers
* that follow.
*/

/*** end ImageHeader.h ***/
