/*-
 * XCreHsbCmap.c - X11 library routine to create an HSB ramp colormaps.
 *
 * Copyright (c) 1988 by Sun Microsystems, Inc.
 *
 * Author: Patrick J. Naughton
 * naughton@wind.sun.com
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation.
 *
 */

#include <sys/types.h>
#include <X11/X.h>
#include <X11/Xos.h>
#include <X11/Xlib.h>

Status
XCreateHSBColormap(dsp, screen, cmap, h1, s1, b1, h2, s2, b2)
Display *dsp;
int screen;
Colormap *cmap;
double h1, s1, b1, h2, s2, b2;
{
u_char red[256];
u_char green[256];
u_char blue[256];
unsigned long pixel;
Status stat;

    HSBramp(h1, s1, b1, h2, s2, b2, 0, 255, red, green, blue);

    pixel = WhitePixel(dsp, screen);
    red[pixel] = green[pixel] = blue[pixel] = 0xff;

    pixel = BlackPixel(dsp, screen);
    red[pixel] = green[pixel] = blue[pixel] = 0;

    stat = XCreateDynamicColormap(dsp, screen, cmap, red, green, blue);

    return(stat);
}
