# include <X11/Intrinsic.h>
# include <X11/StringDefs.h>
# include <stdio.h>

struct widg_list {
	Widget			wl_widg;
	struct widg_list	*wl_next;
};

static struct widg_list		head;
static struct widg_list		*tail = &head;

void
fix_widths(top_form)
	Widget			top_form;
{
	struct widg_list	*wl;
	Arg			arg;
	int			biggest;

	biggest = 0;

	for (wl = head.wl_next; wl != NULL; wl = wl->wl_next) {
		XtSetArg(arg, XtNwidth, 0);
		XtGetValues(wl->wl_widg, &arg, 1);
		if (arg.value > biggest)
			biggest = arg.value;
	}

	XtUnmapWidget(top_form);

	XtSetArg(arg, XtNwidth, biggest);
	for (wl = head.wl_next; wl != NULL; wl = wl->wl_next)
		XtSetValues(wl->wl_widg, &arg, 1);

	XtMapWidget(top_form);
}

void
add_form(widg)
	Widget		widg;
{
	struct widg_list	*tmp;

	tmp = (struct widg_list *) malloc(sizeof(struct widg_list));
	if (tmp == NULL) {
		perror("malloc");
		exit(1);
	}

	tmp->wl_widg = widg;
	tmp->wl_next = NULL;

	tail->wl_next = tmp;
	tail = tmp;
}
