# include <X11/Intrinsic.h>
# include <stdio.h>

# include "globs.h"
# include "layo.h"
# include "xchange.h"
# include "xget.h"

void
main(argc, argv)
	int		argc;
	char		**argv;
{
	Widget		top_shell;
	Widget		top_form;
	layoptr		key_layo;
	layoptr		bell_layo;
	layoptr		mouse_layo;
	layoptr		screen_layo;
	layoptr		quit_layo;

	top_shell = top_shell_setup(argc, argv);
	top_form = top_form_setup(top_shell);

	/* key preferences */
	key_layo = layo_setup(top_form, (Widget) NULL, (Widget) NULL);
	key_form_setup("keyboard", key_layo);
	slider_setup("click", key_layo, set_click, get_click, 0, 100);
	toggle_setup("repeat", key_layo, set_repeat, get_repeat);

	/* bell preferences */
	bell_layo = layo_setup(top_form, (Widget) NULL, key_layo->ly_parent);
	bell_form_setup("bell", bell_layo);
	slider_setup("volume", bell_layo, set_bell_vol, get_bell_vol,
		    0, 100);
	slider_setup("pitch", bell_layo, set_bell_pitch, get_bell_pitch,
		    0, 20000);
	slider_setup("duration", bell_layo, set_bell_dur, get_bell_dur,
		    0, 1000);

	/* mouse preferences */
	mouse_layo = layo_setup(top_form, (Widget) NULL, bell_layo->ly_parent);
	mouse_form_setup("mouse", mouse_layo);
	slider_setup("accel. num.", mouse_layo, set_mouse_num,
		    get_mouse_num, 0, 90);
	slider_setup("accel. denom.", mouse_layo, set_mouse_denom,
		    get_mouse_denom, 1, 90);
	slider_setup("threshold", mouse_layo, set_mouse_thresh,
		    get_mouse_thresh, 1, 90);

	/* screen saver preferences */
	screen_layo = layo_setup(top_form, (Widget) NULL,
				 mouse_layo->ly_parent);
	screen_form_setup("screen", screen_layo);
	toggle_setup("blanking", screen_layo, set_screen_blank,
		     get_screen_blank);
	toggle_setup("exposures", screen_layo, set_screen_expose,
		     get_screen_expose);
	slider_setup("time-out", screen_layo, set_screen_timo,
		    get_screen_timo, 1, 30000);
	slider_setup("cycle", screen_layo, set_screen_cycle,
		    get_screen_cycle, 1, 30000);

	/* quit button */
	quit_layo = layo_setup(top_form, (Widget) NULL,
			       screen_layo->ly_parent);
	quit_button_setup("quit", quit_layo, top_shell);

	XtRealizeWidget(top_shell);

	fix_widths(top_form);

	XtMainLoop();
}

syntax() {
	fprintf(stderr, "usage: xsetq\n");
	exit(1);
}
