# include <X11/Intrinsic.h>
# include <stdio.h>

# include "globs.h"
# include "xchange.h"

void
set_click(percent)
	int			percent;
{
	XKeyboardControl	values;

	values.key_click_percent = percent;
	XChangeKeyboardControl(dpy, KBKeyClickPercent, &values);
}

void
set_repeat(auto_repeat_mode)
	int			auto_repeat_mode;
{
	XKeyboardControl	values;

	values.auto_repeat_mode = auto_repeat_mode;
	XChangeKeyboardControl(dpy, KBAutoRepeatMode, &values);
}

void
set_bell_vol(percent)
	int			percent;
{
	XKeyboardControl	values;

	values.bell_percent = percent;
	XChangeKeyboardControl(dpy, KBBellPercent, &values);
}

void
set_bell_pitch(pitch)
	int			pitch;
{
	XKeyboardControl	values;

	values.bell_pitch = pitch;
	XChangeKeyboardControl(dpy, KBBellPitch, &values);
}

void
set_bell_dur(duration)
	int			duration;
{
	XKeyboardControl	values;

	values.bell_duration = duration;
	XChangeKeyboardControl(dpy, KBBellDuration, &values);
}

void
set_mouse_num(acc_num)
	int	acc_num;
{
	int	acc_denom, thresh;
	int	dummy;

	XGetPointerControl(dpy, &dummy, &acc_denom, &thresh);
	XChangePointerControl(dpy, True, False, acc_num, acc_denom, thresh);
}

void
set_mouse_denom(acc_denom)
	int	acc_denom;
{
	int	acc_num, thresh;
	int	dummy;

	XGetPointerControl(dpy, &acc_num, &dummy, &thresh);
	XChangePointerControl(dpy, True, False, acc_num, acc_denom, thresh);
}

void
set_mouse_thresh(thresh)
	int	thresh;
{
	int	acc_num, acc_denom;
	int	dummy;

	XGetPointerControl(dpy, &acc_num, &acc_denom, &dummy);
	XChangePointerControl(dpy, False, True, acc_num, acc_denom, thresh);
}

void
set_screen_blank(value)
	int	value;
{
	int timo, interval, blank, expose;

	XGetScreenSaver(dpy, &timo, &interval, &blank, &expose);
	blank = value;
	XSetScreenSaver(dpy, timo, interval, blank, expose);
}

void
set_screen_expose(value)
	int	value;
{
	int timo, interval, blank, expose;

	XGetScreenSaver(dpy, &timo, &interval, &blank, &expose);
	expose = value;
	XSetScreenSaver(dpy, timo, interval, blank, expose);
}

void
set_screen_timo(value)
	int	value;
{
	int timo, interval, blank, expose;

	XGetScreenSaver(dpy, &timo, &interval, &blank, &expose);
	timo = value;
	XSetScreenSaver(dpy, timo, interval, blank, expose);
}

void
set_screen_cycle(value)
	int	value;
{
	int timo, interval, blank, expose;

	XGetScreenSaver(dpy, &timo, &interval, &blank, &expose);
	interval = value;
	XSetScreenSaver(dpy, timo, interval, blank, expose);
}
