.TH XSHELL 1 "3 February 1988" "X Version 11 release 1"
.SH NAME
xshell - X Window System, key/button command exec
.SH SYNOPSIS
.B xshell
[ \fIoptions\fP ] [ \fIhost\fP:\fIdisplay\fP ] ...
.SH DESCRIPTION
.I Xshell
is a program for starting up X applications with a single key or button
stroke.  It displays a scallop shell icon in which button and key
presses stand for different commands.  The user can bind a command string
to any key or button by inserting a line like the following in his or her 
\fI.Xdefaults\fP file:
.PP
.nf
    xshell.action.keyname:   command to be exec'ed
.fi
.PP
Keynames are simply letters, numbers, and symbols as they appear on the
keyboard (e.g. a, $, 9), or one of the following special names:
.PP
.nf

    BackSpace            Clear                Formfeed    
    Space                Linefeed             Enter   
    Tab                  Newline              Escape  
    R1                   L1                   F1
    R2                   L2                   F2
    R3                   L3                   F3
    R4                   L4                   F4
    R5                   L5                   F5
    R6                   L6                   F6
    R7                   L7                   F7
    R8                   L8                   F8
    R9                   L9                   F9
    R10                  L10                  Prior
    R11                  Home                 Next
    R12                  LeftArrow            Begin
    R13                  UpArrow              End
    R14                  RightArrow           Pause     
    R15                  DownArrow            Delete
    Select               Print                Execute   
    Insert               Undo                 Redo
    Menu                 Find                 Cancel    
    KeypadSpace          Keypad-              Keypad4
    KeypadTab            Keypad.              Keypad5
    KeypadEnter          Keypad/              Keypad6
    Keypad=              Keypad0              Keypad7
    Keypad*              Keypad1              Keypad8
    Keypad+              Keypad2              Keypad9
    Keypad,              Keypad3              Pf1               
    Pf2                  Pf3                  Pf4
    Help                 Break                ScriptSwitch
    NumLock              LeftButton           MiddleButton
    RightButton          Button4              Button5
    Colon

.fi
.PP
Thus, the following `.Xdefaults' definitions specify that the Left Button
will spawn a terminal window, the Middle Button an editor, the Right Button
a calculator, $ a Bourne shell, and # a superuser shell:
.PP
.nf
    xshell.action.LeftButton:       xterm =80x65-0+0 -fn 6x10
    xshell.action.MiddleButton:     gnuemacs -w =80x65+0-0 
    xshell.action.RightButton:      xterm =20x20-0-0 -fn 6x10 -e dc
    xshell.action.$:                xterm =80x65+0+0 -fn 6x10 -e sh
    xshell.action.#:                xterm =80x65+0+0 -fn 6x10 -e su
.fi
.PP
.I Xshell
breaks the command string up into words by removing all white space (i.e.
tabs and spaces) and uses the vfork() and execvp() system calls to spawn
off the command.  A more complicated parsing algorithm could easily be
added, but the current method is adequate (and fast and memory efficient).
.PP
One thing to keep in mind is that 
.I xshell
is NOT a window manager.  It was written to make popping up frequently used
utilities as painless as possible (how many times have you found that you
need just 1 more window....).  It might make a nice addition to some of
the more verbose window managers, but it runs quite nicely as a separate
program.

.SH ARGUMENTS
.PP
.I Xshell
is designed to be somewhat compatible with 
.I xclock
in the arguments that it takes.  However, 
.I xshell 
will allow you to abbreviate its longer flags to any length you chose.  Thus,
the \-reverse flag can be spelled out, given as \-rev, or even just \-r:
.PP
.TP 10
.B \-fg \fIcolor\fP
On color displays, determines the color of the foreground.
.PP
.TP 10
.B \-bg \fIcolor\fP
On color displays, determines the color of the background.
.PP
.TP 10
.B \-bd \fIcolor\fP
On color displays, determines the color of the border.
.PP
.TP 10
.B \-bw \fIpixels\fP
Specify the width in pixels of the border around the
.I xshell
window.
.PP
.TP 10
.B \-v\[olume\] \fIn\fP
Volume for calls to \fIXBeep\fP, used when errors (such as unbound
key) are found.
.PP
.TP 10
.B \-f\[lash\] \fIn\fP
Number of times to flash the shell window to acknowledge a button or key press.
.PP
.TP 10
.B \-d\[elay\] \fIn\fP
One-hundredths of a second to wait between flashs (default is 5).
.PP
.TP 10
.B \-r\[everse\]
Reverse video (swap foreground and background).
.PP
.TP 10
.B \+r\[everse\]
Normal video (good for over-ridding values in the .Xdefaults).
.PP
.TP 10
.B \-q\[uiet\]
Do not `beep' on errors (see volume).
.PP
.TP 10
.B \+q\[uiet\]
Do `beep' on errors (see volume).
.PP
.TP 10
.B \-s\[mall\]
Use a smaller (48x48) version of the shell icon.  The default icon is 96x96.
.PP
.TP 10
.B \+s\[mall\]
Use the larger (96x96) version of the shell icon.
.PP
.TP 10
.B =\fIgeometry\fP
By default 
.I xshell
will create a window the size of whatever icon you select; the standard X
window geometry argument will override this.
See \fIX(1)\fP for details.
.PP
.TP 10
.B \fIhost\fP:\fIdisplay\fP
specifies the display on which to put the
.I xshell
window.  This overrides the DISPLAY environment variable.

.SH X DEFAULTS
.PP
To make invoking 
.I xshell
easier, each of the flags listed above may be specified in the user's
\fI.Xdefaults\fP file:
.PP
.TP 10
.B Foreground
gives the foreground color.
.PP
.TP 10
.B Background
gives the background color.
.PP
.TP 10
.B Border
gives the border color.
.PP
.TP 10
.B BorderWidth
gives the border width.
.PP
.TP 10
.B ReverseVideo
if "on", the shell icon should be white on black instead of black on white.
.PP
.TP 10
.B Volume
gives the volume to use in calls to XBeep().
.PP
.TP 10
.B Flash
gives the number of times to flash the shell window to acknowledge key or
button presses.
.PP
.TP 10
.B Delay
gives hundredths of a second to wait in between flashes.
.PP
.TP 10
.B Quiet
prevents 
.I xshell
from beeping at you when you mistype.
.PP
.TP 10
.B IconSize
if "small", a halfsize (48x48) version of the scallopshell is used.
.PP
.TP 10
.B WindowGeometry
gives the shell window size using standard X =WxH+X+Y notation.

.SH ENVIRONMENT
.PP
.PP
.TP 10
.B DISPLAY
To get the default host and display number.

.SH SEE ALSO
wm(1), uwm(1), X(1), execl(3), vfork(2)
.SH DIAGNOSTICS
If 
.B \-quiet
is not given on the command line or
``xshell.Quiet: on''
does not appear in the user's \fI.Xdefaults\fP,
.I xshell
will `beep' if a key or button is pressed for which there is no definition
in the \fI.Xdefaults\fP file.
.SH AUTHOR
.PP
Mark D. Baushke
.PP
This work is based upon Jim Fulton's X.V10R4 version of xshell.
.SH BUGS
.I Xshell
uses the XGetDefault call to fetch the command string for a given key.  Thus,
in order to bind the colon (``:'') character to a command you must use
the Colon keyword. 
.PP
A more `user-friendly' interface could include dialog boxes that the user
could pop up to type in a command directly so that a full shell doesn't have
to be started.  Then again, it is nice and compact now and if you really 
need to do that more than once you should use a real shell.
.PP
This program along with has mostly been superceded by \fIuwm(1)\fP.
However, it is still very handy to use.
