# include <X11/Intrinsic.h>
# include <X11/StringDefs.h>
# include <ctype.h>
# include <stdio.h>

# include "globs.h"

/*
 * getline reads a line from the .xtools file and trims
 * any leading whitespace.  lines that begin with a # and
 * empty lines are skipped.
 */
char *
getline(fd)
	FILE		*fd;
{
	extern char	*index();
	static char	buf[BUFSIZ];
	char		*cp;

	for (cp = &buf[0]; cp < &buf[BUFSIZ]; cp++)
		*cp = 0;

	for (;;) {
		if (fgets(buf, sizeof(buf), fd) == NULL)
			return(NULL);

		if ((cp = index(buf, '\n')) != NULL)
			*cp = NULL;

		/* skip leading spaces */
		for (cp = &buf[0]; *cp != NULL; cp++) {
			if (! isspace(*cp))
				break;
		}

		if ((*cp != NULL) && (*cp != '#'))
			break;
	}

	return(cp);
}

# define MAXARGS	128

/*
 * getargs breaks up a space-delimited line and returns it
 * as an array of char *.
 */
char **
getargs(line)
	char		*line;
{
	static char	*args[MAXARGS];
	char		*cp;
	int		i;

	for (i = 0; i < MAXARGS; i++)
		args[i] = NULL;

	cp = line;

	for (i = 0; *cp != NULL; i++) {
		args[i] = cp;

		/* skip to end of word */
		while ((*cp != NULL) && (! isspace(*cp)))
			cp++;

		if (*cp == NULL)
			break;

		*cp++ = NULL;

		if (debug)
			(void) printf("args[%d]=%s\n", i, args[i]);

		/* skip over spaces */
		while ((*cp != NULL) && (isspace(*cp)))
			cp++;
	}

	return(args);
}
