.TH XTOOLS 1 
.SH NAME
xtools \- easy way to start X programs
.SH SYNOPSIS
xinit xtools [-display hostname:dpy] [normal Xaw options]
.SH DESCRIPTION
.I xtools
is a convenient way to start up your X applications when your system
doesn't support starting up the X window system from the getty
process.
.PP
The applications that
.I xtools
starts up are specified in a .xtools file.  You can have different
.I .xtools
files, one for each host.
.I xtools
first tries to open the file .xtools-fully.qualified.domain.name where
``fully.qualified.domain.name'' is the fully qualified domain name of
your workstation (as returned by the gethostname() system call).  If
that file doesn't exist then, starting at the right, it trims off
portions of the domain name and retries.  Using the above example
domain name, the following files would be tried in order:
.sp
.nf
 .xtools-fully.qualified.domain.name
 .xtools-fully.qualified.domain
 .xtools-fully.qualified
 .xtools-fully
 .xtools
.fi
.sp
If none of the .xtools files with a machine or domain name exist then
it uses just ``.xtools''.
.SH CONFIGURATION FILE FORMAT
The format of the .xtools file is similar to typing the commands to
the shell.  Notable differences are that csh-style tilde expansion is
not implemented, quotes don't work, input and output redirection
doesn't work; in other words, no shell metacharacters are recognized.
In particular, it is important to note that the command lines in the
.xtools file must have an ampersand (&) at the end if the command is
expected to run in the background (for example, xterm).  A bug in
.I xtools
requires you to put all of those commands that don't run in the
background first.  Here is a sample .xtools file
.sp
.nf
xrdb		.xrdb
xsetroot	-grey
xhost		yuban ovaltine bosco
xset		m 8 8 r off c 100
twm &
xterm		-i #0x0-85+100 &
xterm		-i #0x0-85+240 -e cartan -e  &
xterm		-i -C -r #0x0-85+380 &
xperfmon	=175x290-115+0 &
xclock &
xbiff &
.fi
.sp
.SH STARTING AND QUITING
Since
.I xtools
is started by
.I xinit
the DISPLAY environment variable isn't set, so you must either set it
prior to starting xinit, or you can use the -display option with
.I xtools
and
.I xtools
will propogate it down to the programs that it starts.  Here's an
example csh alias for starting the X Window System using
.I xtools
on a SUN workstation:
.sp
.nf
alias x 'xinit xtools -iconic -geo -1-100 -display ${hostname}":"0 ; \\
setkeys reset ; \\
clear'
.fi
.sp
where the hostname variable was set earlier with
.sp
.nf
set hostname = ` hostname | sed -e 's/\..*//' `
.fi
.PP
Since
.I xtools
was started by
.I xinit
you must quit
.I xtools
in order to quit the X Window System.
.I xtools
has a small window with two buttons labeled ``quit'' and ``help''.
The help button isn't implemented yet so it is dimmed.  When you click
on the quit button a confirmation box pops up; if you click on the
``yep'' button then
.I xtools
will send a kill signal to all of the programs that it started.
.SH OPTIONS
.I xtools
takes all of the standard toolkit options.  In addition, you may
specifiy an alternate configuration file by using the -file option
following it with the name of the configuration file.
.SH "X DEFAULTS"
The available names and classes for the widgets used are:
.RS
.nf
.ta 4i
NAME	CLASS

top	Shell

top.home	Shell.Form
top.home.home	Shell.Form.Label
top.home.quit	Shell.Form.Command
top.home.help	Shell.Form.Command

top.confirm	Shell.Shell
top.confirm.confirm	Shell.Shell.Form
top.confirm.confirm.confirm	Shell.Shell.Form.Label
top.confirm.confirm.yep	Shell.Shell.Form.Command
top.confirm.confirm.nope	Shell.Shell.Form.Command
.fi
.RE
.PP
These can be used to set fonts, colors, etc. tailored to the user's
needs.  As a color example:
.PP
.RS
.ta 4i
.nf
xtools*quit.Background:				mauve
xtools*confirm.yep.Background:			peach
xtools*confirm.nope.Background:			plum
xtools*geometry:				-1-100
xtools*icon:					on
xtools*home.font:				vbee-36
xtools*confirm.font:				vbee-36
.fi
.RE
.SH AUTHOR
.ta 1.2i
Rusty C. Wright
.br
	rusty@cartan.berkeley.edu
.br
	ucbvax!cartan!rusty
