/*
 *	SunTroff -  A program to display the output of Device Independent
 *		Troff as a window on a Sun Workstation.
 *
 *	Troff_draw.c - Code to do the draw the simple stuff in the page
 *		bit map.
 *
 *	Authors - The original version of this program was written by
 *			Richard L. Hyde (Purdue)
 *			David Slattengren (Berkeley)
 *		It was nearly all rewritten, cleaned up and a more elegant
 *		user interface installed by
 *			Malcolm Slaney (Schlumberger Palo Alto Research)
 *
 *	Legalese -  This command was developed as an independent project
 *		to satisfy a need of the author.  This program may contain
 *		bugs and the user is cautioned to independently verify that
 *		the program is suitable for the user's intended purpose.
 *		The program is made available on an ``as is'' basis with
 *		all faults and without any implied or expressed warranties
 *		or support from either the author, Malcolm Slaney, or
 *		Schlumberger Palo Alto Research Laboratory.
 *
 *		I am putting this program in the public domain.  You are
 *		free to use it as you wish.  In return I ask two things.
 *		First, that you do not remove the names of the authors
 *		from this work.  Secondly, if you make changes or
 *		improvements to this program that you pass these back to
 *		the author so that everybody can benefit from the
 *		improvements.
 *
 *					Malcolm Slaney  (December 1986)
 *					Schlumberger Palo Alto Research
 *					3340 Hillview Avenue
 *					Palo Alto, CA 94304
 *					(415) 496-4669
 *					spar!malcolm@decwrl.dec.com
 *					malcolm@ecn.purdue.edu
 *					malcolm@spar.slb.com (Someday)
 */

#include	"suntroff.h"
#include	<sys/types.h>
#ifdef SUNTOOLS
#include	<suntool/sunview.h>
#include	<suntool/panel.h>
#include	<suntool/canvas.h>
#include	<suntool/scrollbar.h>

extern	Frame	BaseFrame;		/* Top Level Window Frame */
extern	Canvas	DrawingCanvas;		/* Main Drawing Window for Text */
extern	Menu	MainMenu;		/* Top Level User Menu */
#else SUNTOOLS
#include <X11/Xlib.h>
extern Window DrawingCanvas;
extern Display *dpy;
extern GC gc;
extern GC cleargc;
extern Pixmap PagePixRect;
extern int ViewTop, ViewLeft, ViewHeight, ViewWidth;
#endif SUNTOOLS
extern	int	DisplayOutput;		/* Display the output for user? */

#define	FastScale(x)	(((x) * SUNRES) / UserTypesetter->Device.res)

Scale(x)
int	x;
{
	return(((x) * SUNRES) / UserTypesetter->Device.res);
}

ClearPage(){
#ifdef DEBUG
	printf("clearing page\n");
#endif
#ifdef SUNTOOLS
	extern struct pixrect *PagePixRect;

	pr_rop(PagePixRect,0,0,1000000,1000000,PIX_CLR,NULL,0,0);
#else SUNTOOLS
	XFillRectangle(dpy, PagePixRect, cleargc, 0, 0, 
	 PAGE_PIXEL_WIDTH, PAGE_PIXEL_HEIGHT);
	XFlush(dpy);
#endif SUNTOOLD
}

RefreshPage(){
#ifdef DEBUG
	printf("refreshing page\n");
#endif
#ifdef SUNTOOLS
	RepaintCanvas(DrawingCanvas,canvas_pixwin(DrawingCanvas),0);	
#else
	RepaintCanvas(DrawingCanvas, (caddr_t) NULL, (XEvent *) NULL);
#endif 
}

DrawCharacter(x,y,c,cwidth)
int	x, y, c, cwidth;
{
#ifdef SUNTOOLS
	struct pr_prpos where;
	char	Text[2];
	extern struct pixrect *PagePixRect;

	if (!CurrentFont){
		fatal("Don't have a Current Font.\n");
	}

	if (!CurrentFont->Bits){
		fatal("Don't have the bits for the Current Font.\n");
	}

	where.pos.x = FastScale(x);
	where.pos.y = FastScale(y);
	where.pr = PagePixRect;

	Text[0] = c;
	Text[1] = 0;

	if (DisplayOutput)
		pf_text(where,PIX_SRC|PIX_DST,CurrentFont->Bits,Text);
#else
	static char s[2] = " ";
	int dx = 0;
	int lbear;
	
	if (!CurrentFont){
		fatal("Don't have a Current Font.\n");
	}

	if (!CurrentFont->Bits){
		fatal("Don't have the bits for the Current Font.\n");
	}

	if (DisplayOutput) {
		s[0] = c;
#ifndef NOADJUST
		/* 
		 *  This kludge tries to centre the X char within the
		 *  troff char space. Looks a bit better. Thanks to Dave
		 *  Blythe, U of Toronto.
		 */
		dx = (CurrentFont->Bits->per_char)? 
		 CurrentFont->Bits->per_char[c-1].width : 
		 CurrentFont->Bits->min_bounds.width;
		dx = (FastScale(cwidth) - dx)/2;
#ifdef FONTDEBUG
		printf("char \"%c\"(0x%x), dx = %d, xwid = %d (lb,rb = %d,%d), cwid = %d (%d scaled)\n",
		 c, c, dx, CurrentFont->Bits->per_char[c-1].width,
		 CurrentFont->Bits->per_char[c-1].lbearing,
		 CurrentFont->Bits->per_char[c-1].rbearing,
		 cwidth, FastScale(cwidth));
#endif
#endif NOADJUST
		XDrawString(dpy, PagePixRect, gc, 
		 FastScale(x) + dx, 
		 FastScale(y), s, 1);
		XFlush(dpy);
	}
#endif
}


DrawLine(x,y)
{
	if (DisplayOutput)
#ifdef SUNTOOLS
		pr_vector(PagePixRect,
			  FastScale(HorizontalPosition),
			  FastScale(VerticalPosition),
			  FastScale(HorizontalPosition+x),
			  FastScale(VerticalPosition+y),
			  PIX_SET,1);
#else
#ifdef DEBUG
		printf("Drawline to %d, %d\n", FastScale(HorizontalPosition + x), FastScale(VerticalPosition + y));
#endif
		XDrawLine(dpy, PagePixRect, gc, 
			  FastScale(HorizontalPosition),
			  FastScale(VerticalPosition),
			  FastScale(HorizontalPosition+x),
			  FastScale(VerticalPosition+y));
	XFlush(dpy);
#endif
	HorizontalPosition += x;
	VerticalPosition += y;
}

point(x,y)
int	x, y;
{
	if (DisplayOutput)
#ifdef SUNTOOLS
		pr_put(PagePixRect,x,y,1);
#else
		XDrawPoint(dpy, PagePixRect, gc, x, y);
		XFlush(dpy);
#endif
}
