/* 
 * $Locker:  $ 
 */ 
static char	*rcsid = "$Header: main.c,v 1.5 88/09/04 20:07:46 rws Exp $";
#define MAINMODULE 1

/***********************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/
#include "paint.h"

/* DEBUGGING HACKS */

#define XClear(w) XClearArea(dpy, w, 0, 0, 9999, 9999, FALSE)
/* #define XSetClipRectangles(a, b, c, d, e, f)*/

Display *dpy;

int save_func, save_width;

HandleKey(event)
  XEvent *event;
{
    XGCValues gcvalues;
    int code;
    char c;
    static int arg = 0;
    static int argval = 1;
    static int sgn = 0;
    KeySym k;
    char b[2];

    (void) XLookupString(event, b, 2, &k, NULL);
    c = b[0];
    if (IsModifierKey(k))
	return;

    switch (c) {
      case 'C':
	XClearWindow(dpy, window);
	for (; firstimage ; firstimage = firstimage->next) {
	    free(firstimage->points);
	    free(firstimage);
	}
	image = firstimage = lastimage = NULL;
	break;
      case 'l':
	stat.mode = line;
	break;
      case 'r':
	stat.mode = rect;
	break;
      case 'R':
	stat.mode = filledrect;
	break;
      case 'p':
	stat.mode = polygon;
	break;
      case 'P':
	stat.mode = filledpolygon;
	break;
      case 'a':
	stat.mode = arc;
	break;
      case 'A':
	stat.mode = filledarc;
	break;
      case 'f':
	if ((stat.func = arg) < GXclear || arg > GXset)
	    stat.func = GXinvert;
	break;
      case '<':
      case ',':
	stat.angle1 = arg * 64;
	break;
      case '>':
      case '.':
	stat.angle2 = arg * 64;
	break;
      case '-':
	sgn = -1;
	if (arg != argval) argval = -1;
	else argval = arg = abs(arg) * sgn;
	return;
      case '1':
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
      case '8':
      case '9':
      case '0':
	if (sgn == 0) sgn = 1;
	argval = arg = sgn * (abs(arg) * 10 + c - '0');
	return;
      case 't':
	stat.thickness = argval;
	break;
      case 'q':
	exit(0);
      default:
	XBell(dpy, 50);
	printf("Unknown code %d (%c)\n", event->xkey.keycode, c);
	return;
    }
    DisplayMode();
    arg = 0;
    argval = 1;
    sgn = 1;
}

DisplayMode()
{
    char str[500], *p;
    sprintf(str, "Mode %s, Thickness %d, Function %s",
	StringForMode(stat.mode), stat.thickness, StringForFunction(stat.func));
    if (stat.mode == arc || stat.mode == filledarc) {
	p = str + strlen(str);
	sprintf(p, ", angle1 %g, angle2 %g",
	    stat.angle1 / 64.0, stat.angle2 / 64.0);
    } else
	strcat(str, "                          "); /* to erase angles string */
    XDrawImageString(dpy, window, gc, 5, 10, str, strlen(str));
}

ImagePtr NewImage()
{
    ImagePtr image;
    image = (ImagePtr) calloc((unsigned)1, sizeof(ImageRec));
    image->stat = stat;
    image->npoints = 0;
    image->points = (XPoint *) malloc(1);
    return image;
}

StuffPoint(image, x, y)
  ImagePtr image;
  int x, y;
{
    image->npoints++;
    image->points = (XPoint *)
	realloc(image->points, sizeof(XPoint) * image->npoints);
    image->points[image->npoints - 1].x = x;
    image->points[image->npoints - 1].y = y;
}

DrawImage(image, append)
  ImagePtr image;
{
    XGCValues gcvalues;
    int x1, x2, y1, y2, x, y, width, height;

    gcvalues.function = image->stat.func;
    gcvalues.line_width = image->stat.thickness;
    XChangeGC(dpy, gc, GCFunction | GCLineWidth, &gcvalues);
    if (append) {
	if (lastimage)
	    lastimage->next = image;
	else
	    firstimage = image;
	lastimage = image;
    }
    if (image->npoints == 2) {
	x1 = image->points[0].x;
	x2 = image->points[1].x;
	y1 = image->points[0].y;
	y2 = image->points[1].y;
	x = min(x1, x2);
	y = min(y1, y2);
	width = x1 + x2 - x - x;
	height = y1 + y2 - y - y;
    }
    switch (image->stat.mode) {
      case line:
	XDrawLine(dpy, window, gc, x1, y1, x2, y2);
	break;
      case rect:
	XDrawRectangle(dpy, window, gc, x, y, width, height);
	break;
      case filledrect:
	XFillRectangle(dpy, window, gc, x, y, width, height);
	break;
      case arc:
        XDrawArc(dpy, window, gc, x, y, width, height,
	     image->stat.angle1, image->stat.angle2);
        break;
      case filledarc:
        XFillArc(dpy, window, gc, x, y, width, height,
		 image->stat.angle1, image->stat.angle2);
        break;
      case polygon:
	XDrawLines(dpy, window, gc, image->points, image->npoints,
		CoordModeOrigin);
	break;
      case filledpolygon:
	XFillPolygon(dpy, window, gc, image->points, image->npoints, Complex,
		     CoordModeOrigin);
	break;
    }
}

HandleButtonDown(event)
  XEvent *event;
{
    XGCValues gcvalues;

    curx = event->xbutton.x;
    cury = event->xbutton.y;
    save_func = stat.func;
    save_width = stat.thickness;
    gcvalues.function = stat.func = GXxor;
    gcvalues.line_width = stat.thickness = 1;
    XChangeGC(dpy, gc, GCFunction | GCLineWidth, &gcvalues);
}

ButtonMove(event)
XEvent *event;
{
    int newx, newy;
    newx = event->xbutton.x;
    newy = event->xbutton.y;
    switch (stat.mode) {
      case line:
      case rect:
      case filledrect:
      case arc:
      case filledarc:
	if (!image) {
	    image = NewImage();
	    StuffPoint(image, curx, cury);
	    StuffPoint(image, newx, newy);
	} else {
	    DrawImage(image, FALSE); /* erase old image */
	    image->points[1].x = newx;
	    image->points[1].y = newy;
	}
	DrawImage(image, FALSE);
	break;
      case polygon:
      case filledpolygon:
	if (image == NULL) {
	    image = NewImage();
	    StuffPoint(image, curx, cury);
	}
	StuffPoint(image, newx, newy);
	/* build line piece by piece, don't rerender the whole polyline */
	XDrawLine(dpy, window, gc, curx, cury, newx, newy);
	curx = newx;
	cury = newy;
    }
}

HandleButtonUp(event)
XEvent *event;
{
    int newx, newy;
    newx = event->xbutton.x;
    newy = event->xbutton.y;
    if (image) {
	if (stat.mode == filledpolygon)
	    image->stat.mode = polygon;
	DrawImage(image, FALSE);
	if (stat.mode == filledpolygon)
	    image->stat.mode = filledpolygon;
	image->stat.func = save_func;
	image->stat.thickness = save_width;
    }
    /* change from xor/single linewidth mode to real render mode */
    stat.func = save_func;
    stat.thickness = save_width;
    if (!image) /* a single click without movement won't create an object */
	return;
    switch (stat.mode) {
      case line:
      case rect:
      case filledrect:
      case arc:
      case filledarc:
	if (image->npoints > 1) {
	    image->points[1].x = newx;
	    image->points[1].y = newy;
	    break;
	}
      case polygon:
      case filledpolygon:
	StuffPoint(image, newx, newy);
	/*
	puts("polygon points:");
	for (newx = 0; newx < image->npoints; newx++)
	    printf("%d, %d\n", image->points[newx].x, image->points[newx].y);
	*/
    }
    DrawImage(image, TRUE);
    image = NULL; /* reinitialize */
    curx = newx;
    cury = newy;
}

XRectangle rects[500];
int numrects = 0;

RepaintDisplay(event)
  XEvent *event;
{
    ImagePtr image;
    rects[numrects].x = event->xexpose.x;
    rects[numrects].y = event->xexpose.y;
    rects[numrects].width = event->xexpose.width;
    rects[numrects].height = event->xexpose.height;
    XClearArea(dpy, window, event->xexpose.x, event->xexpose.y,
	       event->xexpose.width, event->xexpose.height, FALSE);
    numrects++;
    if (! event->xexpose.count) {
	XSetClipRectangles(dpy, gc, 0, 0, rects, numrects, Unsorted);
	numrects = 0;
	for (image = firstimage; image; image = image->next)
	    DrawImage(image, FALSE);
	rects[0].x = 0;
	rects[0].y = 0;
	rects[0].width = 9999;
	rects[0].height = 9999;
	XSetClipRectangles(dpy, gc, 0, 0, rects, 1, Unsorted);
    }
}

main()
{
    Font font;
    XEvent event;
    Visual visual;
    XSetWindowAttributes attributes;
    XGCValues gcvalues;
    if ((dpy = XOpenDisplay(NULL)) == NULL)
	Punt("Couldn't open display!");
    windowwidth = 400;
    windowheight = 400;
    stat.thickness = 1;
    save_func = stat.func = GXinvert;
    stat.angle1 = 0;
    stat.angle2 = 360 * 64;
    background = WhitePixel(dpy, DefaultScreen(dpy));
    foreground = BlackPixel(dpy, DefaultScreen(dpy));
    font = XLoadFont(dpy, "fixed");
    visual.visualid = CopyFromParent;
    attributes.background_pixel = background;
    attributes.border_pixel = foreground;
    attributes.backing_store = Always;
    window = XCreateWindow(dpy, RootWindow(dpy, DefaultScreen(dpy)),
		20, 20, windowwidth, windowheight, 1,
		DefaultDepth(dpy, DefaultScreen(dpy)), CopyFromParent, &visual,
		CWBackPixel | CWBorderPixel /*| CWBackingStore */, &attributes);
    XChangeProperty(dpy, window, XA_WM_NAME, XA_STRING, 8, 
		    PropModeReplace, "Paint", 5);
    MyXSelectInput(dpy, window, KeyPressMask | ButtonPressMask
		   | ButtonReleaseMask | ButtonMotionMask | ExposureMask);
    XMapWindow(dpy, window);
    gcvalues.foreground = foreground;
    gcvalues.background = background;
    gcvalues.function = stat.func;
    gcvalues.line_width = stat.thickness;
    gcvalues.font = font;
/*     gcvalues.line_style = Solid; */
    gc = XCreateGC(dpy, window, GCFont | GCFunction | GCForeground
		   | GCBackground | GCLineWidth,
		   &gcvalues);
    stat.mode = line;
    image = firstimage = lastimage = NULL;
    for (;;) {
	XNextEvent(dpy, &event);
	switch(event.type) {
	  case KeyPress:
	    HandleKey(&event);
	    break;
	  case ButtonPress:
	    HandleButtonDown(&event);
	    break;
	  case ButtonRelease:
	    HandleButtonUp(&event);
	    break;
	  case MotionNotify:
	    ButtonMove(&event);
	    break;
	  case Expose:
	    RepaintDisplay(&event);
	    DisplayMode();
	    break;
	}
    }	    
}
