# include <X11/Xlib.h>
# include <stdio.h>

Display	*dpy;
int	scr;
Window	root;
char	*prog_name;

main(argc, argv)
	char		**argv;
{
	extern Pixmap	mkrand();
	char		*display_name = NULL;
	int		i;
	int		width, height;
	int		dark;

	prog_name = argv[0];
	width = 0;
	height = 0;
	dark = 0;

	for (i = 1; i < argc; i++) {
		if (!strcmp ("-display", argv[i])) {
			if (++i >= argc)
				usage();
			display_name = argv[i];
			continue;
		}

		if (!strcmp("-width", argv[i])) {
			if (++i >= argc)
				usage();
			width = atoi(argv[i]);
			continue;
		}

		if (!strcmp("-height", argv[i])) {
			if (++i >= argc)
				usage();
			height = atoi(argv[i]);
			continue;
		}

		if (!strcmp("-darkness", argv[i])) {
			if (++i >= argc)
				usage();
			dark = atoi(argv[i]);
			continue;
		}

		usage();
	}

	dpy = XOpenDisplay(display_name);
	if (!dpy) {
		fprintf(stderr, "%s:  unable to open display '%s'\n",
			prog_name, XDisplayName(display_name));
		usage();
	}
	scr = DefaultScreen(dpy);
	root = RootWindow(dpy, scr);

	if (width <= 0) {
		if (width < 0)
			fprintf(stderr, "%s: invalid width, using default.\n",
				prog_name);
		width = DisplayWidth(dpy, scr);
	}
	if (height <= 0) {
		if (height < 0)
			fprintf(stderr, "%s: invalid height, using default.\n",
				prog_name);
		height = DisplayHeight(dpy, scr);
	}
	if (dark < 0)
		dark = 0;
	if (dark > 15)
		dark = 15;

	background(mkrand(dark, width, height), width, height);

	XCloseDisplay(dpy);
	exit(0);
}

usage() {
	fprintf(stderr, "usage: %s [options]\n", prog_name);
	fprintf(stderr, "\twhere options are:\n");
	fprintf(stderr, "\t-display <display>\n");
	fprintf(stderr, "\t-width <N>\n");
	fprintf(stderr, "\t-height <N>\n");
	fprintf(stderr, "\t-darkness <N>\n");
	exit(1);
}

Pixmap
mkrand(dark, width, height) {
	extern long		random();
	extern long		time();
	extern char		*malloc();
	unsigned short		*data;
	register unsigned short	*pd;
	register unsigned short	*data_end;
	int			data_size;
	register int		j;
	register unsigned int	n;

	if ((data = (unsigned short *) malloc(256)) == NULL) {
		perror("malloc");
		exit(1);
	}
	(void) initstate((unsigned int) time(0), (char *) data, 256);
	free(data);

	data_size = ((width * height) / 8);
	if ((data = (unsigned short *) malloc(data_size)) == NULL) {
		perror("malloc");
		exit(1);
	}

	data_end = &data[data_size / sizeof(*data)];

	for (pd = data_end - 1; pd >= &data[0]; pd--)
		*pd = random() & 0xffff;

	if (dark > 0) {
		for (pd = data_end - 1; pd >= &data[0]; pd--) {
			n = random();
			n |= (n & 0x1) << 31; /* high bit = low bit */
			for (j = 0; j < 8; j++) {
				*pd |= ((n & 0x0f) < dark) << j;
				*pd |= ((n & 0x0f) < dark) << (j+8); /*hibyte*/
				n >>= 4;
			}
		}
	}

	return(XCreateBitmapFromData(dpy, root, (char *) data, width, height));
}

/* swiped from xsetroot */
background(bitmap, width, height)
    Pixmap		bitmap;
    unsigned int	width, height;
{
	Pixmap		pix;
	GC		gc;
	XGCValues	gc_init;

	gc_init.foreground = BlackPixel(dpy, scr);
	gc_init.background = WhitePixel(dpy, scr);

	gc = XCreateGC(dpy, root, GCForeground|GCBackground, &gc_init);
	pix = XCreatePixmap(dpy, root, width, height,
			    (unsigned int) DefaultDepth(dpy, scr));

	XCopyPlane(dpy, bitmap, pix, gc, 0, 0, width, height, 0, 0,
		   (unsigned long) 1);
	XSetWindowBackgroundPixmap(dpy, root, pix);

	XFreeGC(dpy, gc);
	XFreePixmap(dpy, bitmap);
	XFreePixmap(dpy, pix);

	XClearWindow(dpy, root);
}
