.ds XW XW\s-2IN\s0
.nr Cl 3
.S 11 14
.SA 1
.ND "June 6, 1988"
.TL
Design of the X Window System Interface Libraries - Xlib, Xt, Xaw, and oldX for
the AT&T \*(XW System.
.AF ""
.AU "R. J. Smolucha" rjs SF XT1112000 6157 "SF G-209"
.AS 2
This document describes the philosophy used and design of
the implementation of the X Window System\(tm
.FS \(tm
X-Window System is a trademark of MIT.
.FE
libraries under UNIX\(rg
.FS \(rg
UNIX is a registered trademark of AT&T.
.FE
System V for the AT&T \*(XW
System.
.AE
.MT 1
.H 1 "Introduction"
This document describes the philosophy used and design of
the implementation of the X Window System\(tm
.FS \(tm
X-Window System is a trademark of MIT.
.FE
libraries under UNIX\(rg
.FS \(rg
UNIX is a registered trademark of AT&T.
.FE
System V for the AT&T \*(XW
System.
In particular it describes the use of the UNIX System V shared library facility
in this implementation; its benefits and limitations, the porting philosophy
used, and a set of new procedures used to implement this philosophy.
.H 1 "X and UNIX System V"
The X Window System is developed at MIT under a variety of non-System V
operating systems (BSD derivatives and VMS).
In developing the "UNIX" version of X some non-System V features of
Berkeley Unix were employed.  Porting the X System to UNIX System V required
either:
.AL
.LI
Replacing the Berkeley functions in the code.  
.P
This alternative was quickly dismissed, since much of the code required 
alteration while the code base was known to be evolving.
.sp
or
.LI
Implementing those BSD functions employed in X.
.P
This philosophy was adopted and a set of BSD functions was
developed to enable the port.
As a result,
we were able to limit the modification of the distributed library code
to the following source files\*F
.FS
Changes were limited to the 5 (of the 230 distributed) files listed.
The BSD subset required the creation of 12 new C source files (less than
600 lines of code)
.FE
(exclusive of bug fixes):
.TS
center allbox tab([);
c c
l l.
File[Description
_
XConnDis.c[Opens the client-server connection
XlibInt.c[Performs I/O between client and server
Xlibint.h[Header for above
Xlibos.h[Operating system dependent header file
Context.c[include for Xlibos.h added
.TE
.P
With the implementation of the BSD subset and modification to the above source
we were able to build useful archive libraries (Xlib, Xt, Xaw, and oldX) 
for the UNIX System V implementation of X.
.H 1 "Shared Libraries"
A brief background, for those unfamiliar with the benefits provided by 
the shared library facilities,
follows.  For more detailed information the reader is directed to
The Shared Libraries section of the UNIX System V Programmer's Guide.
.P
Shared libraries provide these basic benefits:
.BL
.LI
Address binding, through an indirect mechanism, is performed at run-time, 
providing a painless means of implementing library revisions.
.LI
Modules which use a shared library are, generally, much smaller than
those which do not; saving disk space as a result.
.LI
Library code is sharable between processes at run time (i.e., the dynamic
memory needs of processes referencing common library routines is decreased);
reducing the real memory requirements and/or paging of the system.
.LE
.H 2 "Why X is a Good Shared Library Candidate"
The X Window Version 11 libraries from MIT are known to be unstable.
Performance enhancements and feature implementation create this instability.
In addition, bug-fixes are to be expected given the youth of Version 11
of the X Window System and add to the potential for change.
By making Xlib a shared library, client
applications written for X can be sheltered from the effects of change.
This feature alone makes the shared library implementation advantageous.
.P
In addition, the nature of applications running under X and the functionality
provided through its windowing capability make it likely that:
.AL
.LI
Users will execute multiple applications concurrently and
.LI
X applications will reference many common X functions (create window,
select events, etc.)
.LE
.P
Real memory requirements and paging can be optimized by including
these common functions in a shared library.
As can be seen in the above
the use of the shared library
facility with the X Window System is desirable.
.H 3 "Potential for Binary Compatibility"
.sp
By making the specifications of the library public and getting vendor
buy-in to these specifications, it is possible to provide binary compatibility
for applications which use conforming (i.e., compatible) libraries.
.H 2 "Shared Library Design and Limitations"
Several factors required consideration before a particular design was chosen
to implement a sharable X library.
.H 3 "Static Shared Libraries"
.sp
The current facility implements a \fIstatic\fR
shared library mechanism.  The constraints imposed by this facility
include the need to localize external data, to fix in-core
text and data addresses, and to fix the path of the run-time
(target) library component.
.H 4 "Localizing External Data in X"
.sp
To maintain the flexibility provided by the static shared library facility,
it is strongly recommended that external data be defined in a common
file and included as the first member in the library.
The following table describes the external data defined in Xlib and
how these data will be handled (either hidden or relocated).
.TS
center allbox tab([);
c c c c
l l l l.
Datum[Type[Defined In[Relocated To
_
XrmQEyes[XrmQuark[Quarks.c[XExtern.h
XrmQEtrue[XrmQuark[Quarks.c[XExtern.h
XrmQEon[XrmQuark[Quarks.c[XExtern.h
XrmQEoff[XrmQuark[Quarks.c[XExtern.h
XrmQEno[XrmQuark[Quarks.c[XExtern.h
XrmQEfalse[XrmQuark[Quarks.c[XExtern.h
XrmQWindow[XrmQuark[Quarks.c[XExtern.h
XrmQString[XrmQuark[Quarks.c[XExtern.h
XrmQPointer[XrmQuark[Quarks.c[XExtern.h
XrmQPixmap[XrmQuark[Quarks.c[XExtern.h
XrmQPixel[XrmQuark[Quarks.c[XExtern.h
XrmQInt[XrmQuark[Quarks.c[XExtern.h
XrmQGeometry[XrmQuark[Quarks.c[XExtern.h
XrmQFontStruct[XrmQuark[Quarks.c[XExtern.h
XrmQFont[XrmQuark[Quarks.c[XExtern.h
XrmQFile[XrmQuark[Quarks.c[XExtern.h
XrmQDisplay[XrmQuark[Quarks.c[XExtern.h
XrmQDim[XrmQuark[Quarks.c[XExtern.h
XrmQCursor[XrmQuark[Quarks.c[XExtern.h
XrmQColor[XrmQuark[Quarks.c[XExtern.h
XrmQBoolean[XrmQuark[Quarks.c[XExtern.h
_reverse_byte[char array[XPutImage.c[-
_qfree[_XQEvent pointer[XlibInt.c[-
_XHeadOfDisplayList[Display pointer[XOpenDis.c[-
_event_to_mask[long array[evtomask.c[-
_Xdebug[int[XOpenDis.c[XExtern.h
_XErrorFunction[pointer to int function[XlibInt.c[XExtern.h
_XIOErrorFunction[pointer to int function[XlibInt.c[XExtern.h
XErrorList[char pointer array[XErrDes.c[XExtern.h
XErrorListSize[int[XErrDes.c[XExtern.h
.TE
.P
The items which are not referenced outside the library (_qfree, _event_to_mask,
etc.) can be hidden (using the hide directive to mkshlib) as static data.  The
other definitions will be moved to a file Extern.h which is included in
the import file libXi.c inserted as the
first member in the library.
.P
Several steps were taken to facilitate future revisions of the library.  These
include:
.AL
.LI
"Protecting" scalar variables by allocating a flag and pointer for each
variable to be used if changes in the size or contents of the
variable occur in the future.
.LI
Padding array structures to allow for growth.
.LI
Padding the external function pointer block to allow for future extension.
.LI
Moving static text (in the case of strings) to protect addresses in
the event of changes to such text (e.g., lengthening/shortening strings).
.LE
.P
In addition to the above, comments were inserted in the XExtern.h
file to indicate where any future additions of externals can be
safely done without "breaking" upward compatibility.
.P
.H 4 "Text and  Data Segment Addresses"
.sp
The selection of 
addresses requires choosing a contiguous address space
reserved for the shared text and data.  It is imperative that
the addresses chosen do not conflict either directly or through overlap
with other system resources (e.g., shared libraries).
The following addresses have been selected:
.TS
center allbox tab([);
c c c c
l l l l.
Library[System[Text Segment[Data Segment
_
libX11_s[i386[0xA0800000[0xA0C00000
libX11_s[3B2[0x80160000[0x80120000
[[0x80180000[0x80140000
.TE
.H 4 "Target Path Selection"
.sp
The path names for the target shared library components
must be included in the specification file used to build the
shared libraries.  The target name selected is "/usr/X/lib/libX11_s".
.P
.H 4 "Importing Symbols"
.sp
The shared library mechanism requires that all external references be
resolved within the library.  That is, functions and data defined in other
libraries but referenced within the library must be resolved.
This is normally accomplished by
defining these external names in a header (normally <lib>i.h) 
to names of external pointers to types of the actual functions or
data.  This header is included at the beginning of each source file in
the library.  Additionally, these external pointers must themselves
be defined in a new source file (normally <lib>i.c) which is inserted
at the beginning of the library.  The name of this file and the
externs it defines are given in the specification file for the library 
using the init directive.  The names chosen for the pointers also normally
conform to _<lib>_<extern> (e.g., in lib xyz the extern malloc would
require the definition of _xyz_malloc).
.P
For the AT&T \*(XW implementation the following names have been 
selected for the files and variable prefix:
.TS
center allbox tab([);
c c c
l l l.
Import Header[Import Source[Prefix
_
libXi.h[libXi.c[_libX_
.TE
.P
The contents of these files can be found in Attactment A (libXi.h) and
Attachment B (libXi.c).  The external data is defined in XExtern.h.  The
contents of this file can be found in attachment C.
.H 3 "Specification Files"
.sp
Library specification files contain the input used by the mkshlib
tool to construct a shared library.  Some the of components 
(segment addresses, hide/export, init, and target path) have been
addressed above.  The remaining portions are described below.
.H 4 "The Branch Tables"
.sp
The order of the branch table entries is a concern to developers
who wish to create targets compatible with other implementations.
Since (for the initial implementation) 
the ordering of the entries is insignificant, our implementation
ordering will be (arbitrarily) random.  The complete specification
file for libX11_s.a can be found in Attachment D.
.P
Naturally, any future additions to the branch table will need to be coordinated
between implementation of the X library to support the compatibility objective.
.P
.H 4 "Object Ordering"
.sp
Object ordering can effect performance.  The object ordering detailed
in the specification file (Attachment D) will be used for the first
release of the AT&T \*(XW System.  Ongoing analysis may dictate changing
this ordering.  Such changes will not, however, defeat upward
compatibility of the target library.
.H 4 "Object noload directive"
.sp
The objects noload directive is used to specify libraries to be 
searched to resolve any external references which cannot be
handled with the import mechanism.  In particular, references to
the floating point routines must be resolved using the shared C library.
In addition, since the \*(XW makes use of the network shared
library (nsl_s) it needs to named in the specification for Xlib.
.P
It is important to note that application programs which link with Xlib
must also link with the C shared library (libc_s.a) and the network
shared library (libnsl_s.a).
.H 2 "Information Dissemination"
Once the actual specification files have been defined, these specifications
should be advertised to customers to help achieve the binary compatibility
goal.
.H 2 "Tools"
As part of the effort to generate the shared library a tool was created which
analyzes the contents of an archive library and generates the necessary
shared library "source" required (import header, import source, and library
specification file).  This tool was used to determine the
extent of external data use and will be used to complete the
static shared library implementation.
.H 1 "Summary"
Development of a subset of BSD functions was chosen as the design
philosophy for porting the X Window System.  This decision enabled
the port with a minimal amount of source modification.
.P
The X Window System is a good shared library candidate.  The static
shared library mechanism will be used to implement Xlib.
The implementation will facilitate the later use of the dynamic shared
library facility.  The specifications for the library should be advertised
to customers to help acheive the binary compatibility goal.
.SG
.PH "''Attachment A - Page \\\\nP''"
.SK
.ce 1
\fBlibXi.h - Header File for the Xlib Shared Library
.sp
.DS
.ft CW
.* .so libXi.h
#ifndef	NOIDENT
#ident	"@(#)Xlib:libXi.h	1.6"
#endif
/*'copyright	"%c%"'*/
#ifdef SHARELIB
#define fscanf	(*_libX_fscanf)
#define sscanf	(*_libX_sscanf)
#define fgets	(*_libX_fgets)
#define fopen	(*_libX_fopen)
#define fclose	(*_libX_fclose)
#define abs	(*_libX_abs)
#define fwrite	(*_libX_fwrite)
#define fputs	(*_libX_fputs)
#define getpwuid	(*_libX_getpwuid)
#define getuid	(*_libX_getuid)
#define getpwnam	(*_libX_getpwnam)
#define getenv	(*_libX_getenv)
#define ioctl	(*_libX_ioctl)
#define strcpy	(*_libX_strcpy)
#define fcntl	(*_libX_fcntl)
#define _ctype	(*_libX__ctype)
#define memchr	(*_libX_memchr)
#define memccpy	(*_libX_memccpy)
#define strcmp	(*_libX_strcmp)
#define exit	(*_libX_exit)
#define realloc	(*_libX_realloc)
#define calloc	(*_libX_calloc)
#define t_unbind	(*_libX_t_unbind)
#define t_snddis	(*_libX_t_snddis)
#define t_snd	(*_libX_t_snd)
#define t_rcv	(*_libX_t_rcv)
#define t_connect	(*_libX_t_connect)
#define t_free	(*_libX_t_free)
#define t_accept	(*_libX_t_accept)
#define t_close	(*_libX_t_close)
#define t_errno	(*_libX_t_errno)
#define t_listen	(*_libX_t_listen)
#define t_look	(*_libX_t_look)
#define t_bind	(*_libX_t_bind)
#define t_alloc	(*_libX_t_alloc)
#define t_error	(*_libX_t_error)
#define t_open	(*_libX_t_open)
#define alarm	(*_libX_alarm)
#define signal	(*_libX_signal)
#define strlen	(*_libX_strlen)
#define write	(*_libX_write)
#define strcat	(*_libX_strcat)
#define read	(*_libX_read)
#define close	(*_libX_close)
#define chmod	(*_libX_chmod)
#define link	(*_libX_link)
#define ptsname	(*_libX_ptsname)
#define unlink	(*_libX_unlink)
#define sprintf	(*_libX_sprintf)
#define atoi	(*_libX_atoi)
#define unlockpt	(*_libX_unlockpt)
#define grantpt	(*_libX_grantpt)
#define perror	(*_libX_perror)
#define open	(*_libX_open)
#define fprintf	(*_libX_fprintf)
#define _iob	(*_libX__iob)
#define poll	(*_libX_poll)
#define ulimit	(*_libX_ulimit)
#define srand	(*_libX_srand)
#define rand	(*_libX_rand)
#define free	(*_libX_free)
#define malloc	(*_libX_malloc)
#define strrchr	(*_libX_strrchr)
#define strchr	(*_libX_strchr)
#define daylight	(*_libX_daylight)
#define timezone	(*_libX_timezone)
#define strncpy	(*_libX_strncpy)
#define uname	(*_libX_uname)
#define errno	(*_libX_errno)
#define memset	(*_libX_memset)
#define memcmp	(*_libX_memcmp)
#define memcpy	(*_libX_memcpy)

extern int        fscanf();
extern int        sscanf();
extern char *     fgets();
extern int        fclose();
extern int        abs();
extern int        fwrite();
extern int        fputs();
extern unsigned short getuid();
extern char *     getenv();
extern int        ioctl();
extern char *     strcpy();
extern int        fcntl();
extern char *     memchr();
extern char *     memccpy();
extern int        strcmp();
extern void       exit();
extern char *     realloc();
extern char *     calloc();
extern int        t_unbind();
extern int        t_snddis();
extern int        t_snd();
extern int        t_rcv();
extern int        t_connect();
extern int        t_free();
extern int        t_accept();
extern int        t_close();
extern int        t_errno;
extern int        t_listen();
extern int        t_look();
extern int        t_bind();
extern char *     t_alloc();
extern int        t_error();
extern int        t_open();
extern unsigned   alarm();
extern int        strlen();
extern int        write();
extern char *     strcat();
extern int        read();
extern int        close();
extern int        chmod();
extern int        link();
extern char *     ptsname();
extern int        unlink();
extern int        sprintf();
extern int        atoi();
extern void       unlockpt();
extern void       grantpt();
extern void       perror();
extern int        open();
extern int        fprintf();
extern int        poll();
extern long       ulimit();
extern void       srand();
extern int        rand();
extern void       free();
extern char *     malloc();
extern char *     strrchr();
extern char *     strchr();
extern int        daylight;
extern long       timezone;
extern char *     strncpy();
extern int        uname();
extern int        errno;
extern char *     memset();
extern int        memcmp();
extern char *     memcpy();

#endif
.ft P
.DE
.PH "''Attachment B - Page \\\\nP''"
.SK
.ce 1
\fBlibXi.c - Import C Source File for the Xlib Shared Library
.sp
.DS
.ft CW
.* .so libXi.c
#ifndef	NOIDENT
#ident	"@(#)Xlib:libXi.c	1.7"
#endif
#include <stdio.h>
#include <Xlib.h>
#include "Xstreams.h"
#include <sys/tiuser.h>
#include <pwd.h>
 
typedef int  (*PFI)();
typedef void (*PFV)();
#ifdef SHARELIB
int        	(*_libX_fscanf                        )()	= 0;
int        	(*_libX_sscanf                        )()	= 0;
char *     	(*_libX_fgets                         )()	= 0;
FILE *     	(*_libX_fopen                         )()	= 0;
int        	(*_libX_fclose                        )()	= 0;
int        	(*_libX_abs                           )()	= 0;
int        	(*_libX_fwrite                        )()	= 0;
int        	(*_libX_fputs                         )()	= 0;
struct passwd * 	(*_libX_getpwuid                      )()	= 0;
unsigned short 	(*_libX_getuid                        )()	= 0;
struct passwd * 	(*_libX_getpwnam                      )()	= 0;
char *     	(*_libX_getenv                        )()	= 0;
int        	(*_libX_ioctl                         )()	= 0;
char *     	(*_libX_strcpy                        )()	= 0;
int        	(*_libX_fcntl                         )()	= 0;
unsigned char * 	(*_libX__ctype                        )	= 0;
char *     	(*_libX_memchr                        )()	= 0;
char *     	(*_libX_memccpy                       )()	= 0;
int        	(*_libX_strcmp                        )()	= 0;
void       	(*_libX_exit                          )()	= 0;
char *     	(*_libX_realloc                       )()	= 0;
char *     	(*_libX_calloc                        )()	= 0;
int        	(*_libX_t_unbind                      )()	= 0;
int        	(*_libX_t_snddis                      )()	= 0;
int        	(*_libX_t_snd                         )()	= 0;
int        	(*_libX_t_rcv                         )()	= 0;
int        	(*_libX_t_connect                     )()	= 0;
int        	(*_libX_t_free                        )()	= 0;
int        	(*_libX_t_accept                      )()	= 0;
int        	(*_libX_t_close                       )()	= 0;
int        	(*_libX_t_errno                       )	= 0;
int        	(*_libX_t_listen                      )()	= 0;
int        	(*_libX_t_look                        )()	= 0;
int        	(*_libX_t_bind                        )()	= 0;
char *     	(*_libX_t_alloc                       )()	= 0;
int        	(*_libX_t_error                       )()	= 0;
int        	(*_libX_t_open                        )()	= 0;
unsigned   	(*_libX_alarm                         )()	= 0;
PFV        	(*_libX_signal                        )()	= 0;
int        	(*_libX_strlen                        )()	= 0;
int        	(*_libX_write                         )()	= 0;
char *     	(*_libX_strcat                        )()	= 0;
int        	(*_libX_read                          )()	= 0;
int        	(*_libX_close                         )()	= 0;
int        	(*_libX_chmod                         )()	= 0;
int        	(*_libX_link                          )()	= 0;
char *     	(*_libX_ptsname                       )()	= 0;
int        	(*_libX_unlink                        )()	= 0;
int        	(*_libX_sprintf                       )()	= 0;
int        	(*_libX_atoi                          )()	= 0;
void       	(*_libX_unlockpt                      )()	= 0;
void       	(*_libX_grantpt                       )()	= 0;
void       	(*_libX_perror                        )()	= 0;
int        	(*_libX_open                          )()	= 0;
int        	(*_libX_fprintf                       )()	= 0;
FILE *     	(*_libX__iob                          )	= 0;
int        	(*_libX_poll                          )()	= 0;
long       	(*_libX_ulimit                        )()	= 0;
void       	(*_libX_srand                         )()	= 0;
int        	(*_libX_rand                          )()	= 0;
void       	(*_libX_free                          )()	= 0;
char *     	(*_libX_malloc                        )()	= 0;
char *     	(*_libX_strrchr                       )()	= 0;
char *     	(*_libX_strchr                        )()	= 0;
int        	(*_libX_daylight                      )	= 0;
long       	(*_libX_timezone                      )	= 0;
long       	(*_libX_time                          )()	= 0;
char *     	(*_libX_strncpy                       )()	= 0;
int        	(*_libX_uname                         )()	= 0;
int        	(*_libX_errno                         )	= 0;
char *     	(*_libX_memset                        )()	= 0;
int        	(*_libX_memcmp                        )()	= 0;
char *     	(*_libX_memcpy                        )()	= 0;
void *          (*_libX_reserved1                     )()       = 0;
void *          (*_libX_reserved2                     )()       = 0;
void *          (*_libX_reserved3                     )()       = 0;
void *          (*_libX_reserved4                     )()       = 0;
void *          (*_libX_reserved5                     )()       = 0;
void *          (*_libX_reserved6                     )()       = 0;
void *          (*_libX_reserved7                     )()       = 0;
void *          (*_libX_reserved8                     )()       = 0;
void *          (*_libX_reserved9                     )()       = 0;
void *          (*_libX_reserved10                    )()       = 0;
void *          (*_libX_reserved11                    )()       = 0;
void *          (*_libX_reserved12                    )()       = 0;
void *          (*_libX_reserved13                    )()       = 0;
void *          (*_libX_reserved14                    )()       = 0;
void *          (*_libX_reserved15                    )()       = 0;
void *          (*_libX_reserved16                    )()       = 0;
void *          (*_libX_reserved17                    )()       = 0;
void *          (*_libX_reserved18                    )()       = 0;
void *          (*_libX_reserved19                    )()       = 0;
void *          (*_libX_reserved20                    )()       = 0;
#endif
#include "XExtern.h"
.ft P
.DE
.PH "''Attachment C - Page \\\\nP''"
.SK
.ce 1
\fBXExtern.h - External Definition "Header" for the Xlib Shared Library
.sp
.DS
.ft CW
.* .so XExtern.h
#ifndef NOIDENT
#ident	"@(#)Xlib:XExtern.h	1.6"
#endif
/*'copyright	"%c%"'*/

#include "Xresource.h"
#include <sys/param.h>

#ifdef SHARELIB
extern int _XIOError();
extern int _XDefaultError();

/* from XlibInt.c */

int (*_XIOErrorFunction)() = _XIOError;
int (*_XErrorFunction)()   = _XDefaultError;

/* from XOpenDis.c */

int _Xdebug = 0;
long _XdebugFlag = 0;
void * _XdebugPtr = NULL;

Display *_XHeadOfDisplayList = NULL;
long _HeadOfDisplayListFlag = 0;
void * _XHeadOfDisplayListPtr = NULL;

/* from Quarks.c */

XrmQuark  XrmQBoolean	= NULLQUARK;
long   XrmQBooleanFlag = 0;
void * XrmQBooleanPtr = NULL;
XrmQuark  XrmQColor	= NULLQUARK;
long   XrmQColorFlag = 0;
void * XrmQColorPtr = NULL;
XrmQuark  XrmQCursor	= NULLQUARK;
long   XrmQCursorFlag = 0;
void * XrmQCursorPtr = NULL;
XrmQuark  XrmQDims	= NULLQUARK;
long   XrmQDimsFlag = 0;
void * XrmQDimsPtr = NULL;
XrmQuark  XrmQDisplay	= NULLQUARK;
long   XrmQDisplayFlag = 0;
void * XrmQDisplayPtr = NULL;
XrmQuark  XrmQFile	= NULLQUARK;
long   XrmQFileFlag = 0;
void * XrmQFilePtr = NULL;
XrmQuark  XrmQFont	= NULLQUARK;
long   XrmQFontFlag = 0;
void * XrmQFontPtr = NULL;
XrmQuark  XrmQFontStruct= NULLQUARK;
long   XrmQ7sFontStructFlag = 0;
void * XrmQ7sFontStructPtr = NULL;
XrmQuark  XrmQGeometry	= NULLQUARK;
long   XrmQGeometryFlag = 0;
void * XrmQGeometryPtr = NULL;
XrmQuark  XrmQInt	= NULLQUARK;
long   XrmQIntFlag = 0;
void * XrmQIntPtr = NULL;
XrmQuark  XrmQPixel	= NULLQUARK;
long   XrmQPixelFlag = 0;
void * XrmQPixelPtr = NULL;
XrmQuark  XrmQPixmap	= NULLQUARK;
long   XrmQPixmapFlag = 0;
void * XrmQPixmapPtr = NULL;
XrmQuark  XrmQPointer	= NULLQUARK;
long   XrmQPointerFlag = 0;
void * XrmQPointerPtr = NULL;
XrmQuark  XrmQString	= NULLQUARK;
long   XrmQStringFlag = 0;
void * XrmQStringPtr = NULL;
XrmQuark  XrmQWindow	= NULLQUARK;
long   XrmQWindowFlag = 0;
void * XrmQWindowPtr = NULL;

/* "Enumeration" constants */

XrmQuark  XrmQEfalse	= NULLQUARK;
long   XrmQEfalseFlag = 0;
void * XrmQEfalsePtr = NULL;
XrmQuark  XrmQEno	= NULLQUARK;
long   XrmQEnoFlag = 0;
void * XrmQEnoPtr = NULL;
XrmQuark  XrmQEoff	= NULLQUARK;
long   XrmQEoffFlag = 0;
void * XrmQEoffPtr = NULL;
XrmQuark  XrmQEon	= NULLQUARK;
long   XrmQEonFlag = 0;
void * XrmQEonPtr = NULL;
XrmQuark  XrmQEtrue	= NULLQUARK;
long   XrmQEtrueFlag = 0;
void * XrmQEtruePtr = NULL;
XrmQuark  XrmQEyes	= NULLQUARK;
long   XrmQEyesFlag = 0;
void * XrmQEyesPtr = NULL;

/* from XErrDes.c */

extern char _Err00[];
extern char _Err01[];
extern char _Err02[];
extern char _Err03[];
extern char _Err04[];
extern char _Err05[];
extern char _Err06[];
extern char _Err07[];
extern char _Err08[];
extern char _Err09[];
extern char _Err10[];
extern char _Err11[];
extern char _Err12[];
extern char _Err13[];
extern char _Err14[];
extern char _Err15[];
extern char _Err16[];
extern char _Err17[];

char * XErrorList[] = {
   _Err00,	_Err01,	_Err02,	_Err03,	_Err04,	
   _Err05,	_Err06,	_Err07,	_Err08,	_Err09,	
   _Err10,	_Err11,	_Err12,	_Err13,	_Err14,	
   _Err15,	_Err16,	_Err17,	_Err00,	_Err00,	
   _Err00,	_Err00,	_Err00,	_Err00,	_Err00,	
   _Err00,	_Err00,	_Err00,	_Err00,	_Err00,	
   _Err00,	_Err00,	_Err00,	_Err00,	_Err00,	
   _Err00,	_Err00,	_Err00,	_Err00,	_Err00,	
   _Err00,	_Err00,	_Err00,	_Err00,	_Err00,	
   _Err00,	_Err00,	_Err00,	_Err00,	_Err00,	
   _Err00,	_Err00,	_Err00,	_Err00,	_Err00,	
};
/*
 * NOTE: if you add any entries to the above table
 * you will need to imcrement the factor below.
 */
int XErrorListSize = 18*sizeof(char *);
#endif

char	TypeOfStream[100] =
   {
   0
   };

extern int SetupLocalStream();
extern int ConnectLocalClient();
extern int CallLocalServer();
extern int ReadLocalStream();
extern int ErrorCall();
extern int WriteLocalStream();
extern int CloseLocalStream(); 
extern int SetupTliStream();
extern int ConnectTliClient();
extern int CallTliServer(); 
extern int ReadTliStream(); 
extern int WriteTliStream();
extern int CloseTliStream();
extern int SetupTcpStream();
extern int ConnectTcpClient();
extern int CallTcpServer(); 
extern int ReadTcpStream(); 
extern int ErrorCall(); 
extern int WriteTcpStream();
extern int CloseTcpStream();

Xstream xstream[] = {
    { 
	SetupLocalStream,
	ConnectLocalClient,
	CallLocalServer,
	ReadLocalStream,
	ErrorCall,
	WriteLocalStream,
	CloseLocalStream,
	NULL,
	NULL
    },
    { 
	SetupTliStream,
	ConnectTliClient,
	CallTliServer, 
	ReadTliStream, 
	ErrorCall, 
	WriteTliStream,
	CloseTliStream,
	NULL,
	NULL
    },
    { 
	SetupTcpStream,
	ConnectTcpClient,
	CallTcpServer, 
	ReadTcpStream, 
	ErrorCall, 
	WriteTcpStream,
	CloseTcpStream,
	NULL,
	NULL
    },
    { 
	NULL,
	NULL,
	NULL, 
	NULL, 
	NULL, 
	NULL,
	NULL,
	NULL,
	NULL
    },
    { 
	NULL,
	NULL,
	NULL, 
	NULL, 
	NULL, 
	NULL,
	NULL,
	NULL,
	NULL
    },
    { 
	NULL,
	NULL,
	NULL, 
	NULL, 
	NULL, 
	NULL,
	NULL,
	NULL,
	NULL
    }
};

/*
 * NOTE: any additional external definition NEED
 * to be inserted BELOW this point!!!
 */

/*
 * NOTE: any additional external definition NEED
 * to be inserted ABOVE this point!!!
 */
#ifdef SHARELIB
char _Err00[] = /* No error	*/"";
char _Err01[] = /* BadRequest	*/"bad request code";
char _Err02[] = /* BadValue	*/"integer parameter out of range";
char _Err03[] = /* BadWindow	*/"parameter not a Window";
char _Err04[] = /* BadPixmap	*/"parameter not a Pixmap";
char _Err05[] = /* BadAtom	*/"parameter not an Atom";
char _Err06[] = /* BadCursor	*/"parameter not a Cursor";
char _Err07[] = /* BadFont	*/"parameter not a Font";
char _Err08[] = /* BadMatch	*/"parameter mismatch";
char _Err09[] = /* BadDrawable	*/"parameter not a Pixmap or Window";
char _Err10[] = /* BadAccess	*/"attempt to access private resource"; 
char _Err11[] = /* BadAlloc	*/"insufficient resources";
char _Err12[] = /* BadColor   	*/"no such colormap";
char _Err13[] = /* BadGC   	*/"parameter not a GC";
char _Err14[] = /* BadIDChoice  */"invalid resource ID for this connection";
char _Err15[] = /* BadName	*/"font or color name does not exist";
char _Err16[] = /* BadLength	*/"request length incorrect, internal Xlib error";
char _Err17[] = /* BadImplementation */	"server does not implement function";
#endif
.ft P
.DE
.PH "''Attachment D - Page \\\\nP''"
.SK
.ce 1
\fBSpecification File for the Xlib Shared Library (i386)\fR
.sp
.DS
.ft CW
.* .so libX.sl
#target /usr/X/lib/libX11_s

#address .text 0xA0800000
#address .data 0xA0C00000

#branch
	XrmQGetResource                        1
	XrmPutFileDatabase                     2
	XrmPutStringResource                   3
	XrmPutResource                         4
	XrmQPutResource                        5
	XrmQGetSearchResource                  6
	XrmQGetSearchList                      7
	XrmStringToQuarkList                   8
	XFree                                  9
	XWriteBitmapFile                      10
	XCreateWindow                         11
	XWindowEvent                          12
	XWarpPointer                          13
	XMatchVisualInfo                      14
	XGetVisualInfo                        15
	XUnmapWindow                          16
	XUnmapSubwindows                      17
	XUninstallColormap                    18
	XUngrabServer                         19
	XUngrabPointer                        20
	XUngrabKey                            21
	XUngrabKeyboard                       22
	XUngrabButton                         23
	XUndefineCursor                       24
	XTranslateCoordinates                 25
	XTextWidth16                          26
	XTextWidth                            27
	XDrawString16                         28
	XDrawString                           29
	XSetAfterFunction                     30
	_XSyncFunction                        31
	XKeysymToString                       32
	XStringToKeysym                       33
	XSetIconName                          34
	XStoreNamedColor                      35
	XStoreColors                          36
	XStoreColor                           37
	XStoreBytes                           38
	XStoreBuffer                          39
	XFetchBytes                           40
	XFetchBuffer                          41
	XRotateBuffers                        42
	XSetTSOrigin                          43
	XSetTile                              44
	XSetStandardColormap                  45
	XSetStipple                           46
	XSetState                             47
	XSetScreenSaver                       48
	XSetSelectionOwner                    49
	XChangeKeyboardMapping                50
	XSetPointerMapping                    51
	XSetPlaneMask                         52
	XSetLineAttributes                    53
	XSetInputFocus                        54
	XStoreName                            55
	XSetClassHint                         56
	XSetTransientForHint                  57
	XSetStandardProperties                58
	XSetCommand                           59
	XSetIconSizes                         60
	XSetNormalHints                       61
	XSetZoomHints                         62
	XSetWMHints                           63
	XSetSizeHints                         64
	XSetFunction                          65
	XSetForeground                        66
	XSetFont                              67
	XSetFontPath                          68
	XSetDashes                            69
	XSetClipOrigin                        70
	XSetClipMask                          71
	XSetClipRectangles                    72
	XSetBackground                        73
	XSendEvent                            74
	XSelectInput                          75
	XRotateWindowProperties               76
	XRestackWindows                       77
	XReparentWindow                       78
	_XSetClipRectangles                   79
	XRectInRegion                         80
	XPointInRegion                        81
	XEqualRegion                          82
	XEmptyRegion                          83
	XXorRegion                            84
	XSubtractRegion                       85
	XUnionRegion                          86
	combineRegs                           87
	XIntersectRegion                      88
	XShrinkRegion                         89
	XOffsetRegion                         90
	XDestroyRegion                        91
	XSetRegion                            92
	XUnionRectWithRegion                  93
	XClipBox                              94
	XConfigureWindow                      95
	XRecolorCursor                        96
	XReadBitmapFile                       97
	XRaiseWindow                          98
	XQueryTree                            99
	XQueryBestTile                       100
	XQueryTextExtents                    101
	XQueryTextExtents16                  102
	XQueryBestStipple                    103
	XQueryPointer                        104
	XQueryKeymap                         105
	XQueryBestCursor                     106
	XQueryColors                         107
	XQueryColor                          108
	XQueryBestSize                       109
	_XAllocScratch                       110
	XPutBackEvent                        111
	XDrawText16                          112
	XDrawText                            113
	XCreateRegion                        114
	XPolygonRegion                       115
	XSetWindowBorderPixmap               116
	XSetWindowBackgroundPixmap           117
	XPending                             118
	XEventsQueued                        119
	XPeekIfEvent                         120
	XPeekEvent                           121
	ReadInteger                          122
	XParseColor                          123
	XSynchronize                         124
	_XAllocID                            125
	_XWireToEvent                        126
	XOpenDisplay                         127
	XNextEvent                           128
	XMoveWindow                          129
	XDeleteModifiermapEntry              130
	XInsertModifiermapEntry              131
	XNewModifiermap                      132
	XSetModifierMapping                  133
	XMaskEvent                           134
	XMapWindow                           135
	XMapSubwindows                       136
	XMapRaised                           137
	XNoOp                                138
	XAddPixel                            139
	XSubImage                            140
	XPutPixel                            141
	XGetPixel                            142
	XDestroyImage                        143
	XEventMaskOfScreen                   144
	XDoesBackingStore                    145
	XDoesSaveUnders                      146
	XMaxCmapsOfScreen                    147
	XMinCmapsOfScreen                    148
	XCellsOfScreen                       149
	XPlanesOfScreen                      150
	XHeightMMOfScreen                    151
	XWidthMMOfScreen                     152
	XHeightOfScreen                      153
	XWidthOfScreen                       154
	XDefaultVisualOfScreen               155
	XDefaultGCOfScreen                   156
	XDefaultDepthOfScreen                157
	XDefaultColormapOfScreen             158
	XWhitePixelOfScreen                  159
	XBlackPixelOfScreen                  160
	XRootWindowOfScreen                  161
	XDisplayOfScreen                     162
	XDefaultScreenOfDisplay              163
	XScreenOfDisplay                     164
	XLastKnownRequestProcessed           165
	XNextRequest                         166
	XImageByteOrder                      167
	XBitmapPad                           168
	XBitmapBitOrder                      169
	XBitmapUnit                          170
	XDefaultColormap                     171
	XDefaultDepth                        172
	XDisplayString                       173
	XVendorRelease                       174
	XProtocolRevision                    175
	XProtocolVersion                     176
	XServerVendor                        177
	XScreenCount                         178
	XDisplayCells                        179
	XDisplayPlanes                       180
	XDisplayHeightMM                     181
	XDisplayWidthMM                      182
	XDisplayHeight                       183
	XDisplayWidth                        184
	XQLength                             185
	XAllPlanes                           186
	XWhitePixel                          187
	XBlackPixel                          188
	XDefaultGC                           189
	XDefaultVisual                       190
	XDefaultRootWindow                   191
	XDefaultScreen                       192
	XRootWindow                          193
	XConnectionNumber                    194
	XLowerWindow                         195
	XLookupColor                         196
	XFreeExtensionList                   197
	XListExtensions                      198
	XListProperties                      199
	XListInstalledColormaps              200
	XListHosts                           201
	XKillClient                          202
	XGetModifierMapping                  203
	XFreeModifiermap                     204
	XRebindKeysym                        205
	XLookupString                        206
	MatchEvent                           207
	XUseKeymap                           208
	XRefreshKeyboardMapping              209
	XLookupKeysym                        210
	XKeysymToKeycode                     211
	XKeycodeToKeysym                     212
	XInternAtom                          213
	XInstallColormap                     214
	_XUnknownWireEvent                   215
	XQueryExtension                      216
	XESetErrorString                     217
	XESetError                           218
	XESetEventToWire                     219
	XESetWireToEvent                     220
	XESetCloseDisplay                    221
	XESetFreeFont                        222
	XESetCreateFont                      223
	XESetFreeGC                          224
	XESetFlushGC                         225
	XESetCopyGC                          226
	XESetCreateGC                        227
	XInitExtension                       228
	XTextExtents16                       229
	XDrawImageString16                   230
	XTextExtents                         231
	XDrawImageString                     232
	_XReportBadImage                     233
	_XInitImageFuncPtrs                  234
	_XAddPixel                           235
	_XSubImage                           236
	_XPutPixel                           237
	_XGetPixel                           238
	_XGetBitsPerPixel                    239
	_XReadEvents                         240
	XIfEvent                             241
	XRemoveHosts                         242
	XAddHosts                            243
	XRemoveHost                          244
	XAddHost                             245
	XGrabServer                          246
	XGrabPointer                         247
	XGrabKeyboard                        248
	XGrabKey                             249
	XGrabButton                          250
	XGetWindowAttributes                 251
	XGetStandardColormap                 252
	XGetScreenSaver                      253
	XGetSelectionOwner                   254
	XGetKeyboardMapping                  255
	XGetPointerMapping                   256
	XGetPointerControl                   257
	XGetMotionEvents                     258
	XGetKeyboardControl                  259
	_XDestroyImage                       260
	_XSetImage                           261
	_XGetScanlinePad                     262
	XCreateImage                         263
	_XVIDtoVisual                        264
	XGetSubImage                         265
	XGetImage                            266
	XGetInputFocus                       267
	XGetClassHint                        268
	XGetTransientForHint                 269
	XGetIconSizes                        270
	XGetNormalHints                      271
	XGetZoomHints                        272
	XGetWMHints                          273
	XGetSizeHints                        274
	XAllocColor                          275
	XGetGeometry                         276
	XGetFontProperty                     277
	XFreeFontPath                        278
	XGetFontPath                         279
	XrmGetStringDatabase                 280
	XGetDefault                          281
	XAllocNamedColor                     282
	XGetAtomName                         283
	XParseGeometry                       284
	XGeometry                            285
	XSetSubwindowMode                    286
	XSetGraphicsExposures                287
	XSetFillStyle                        288
	XSetFillRule                         289
	XSetArcMode                          290
	XForceScreenSaver                    291
	XResetScreenSaver                    292
	XActivateScreenSaver                 293
	XFreePixmap                          294
	XFreeCursor                          295
	XFreeColors                          296
	XFreeColormap                        297
	XFreeFontInfo                        298
	XListFontsWithInfo                   299
	_XReadPad                            300
	XFreeFontNames                       301
	XListFonts                           302
	_XFreeExtData                        303
	XQueryFont                           304
	_XQueryFont                          305
	XFreeFont                            306
	XLoadQueryFont                       307
	XFlush                               308
	XFillRectangles                      309
	XFillRectangle                       310
	XFillPolygon                         311
	XFillArcs                            312
	XFillArc                             313
	XGetWindowProperty                   314
	XGetIconName                         315
	XFetchName                           316
	_XUnknownNativeEvent                 317
	_XEventToWire                        318
	_XIOError                            319
	_XDefaultError                       320
	XSetIOErrorHandler                   321
	XSetErrorHandler                     322
	XrmMergeDatabases                    323
	XrmGetFileDatabase                   324
	XrmInitialize                        325
	XrmGetResource                       326
	_XInitErrorHandling                  327
	XGetErrorDatabaseText                328
	XGetErrorText                        329
	XDrawSegments                        330
	XDrawRectangles                      331
	XDrawRectangle                       332
	XDrawPoints                          333
	XDrawPoint                           334
	XDrawLines                           335
	XDrawLine                            336
	XDrawArcs                            337
	XDrawArc                             338
	XDisplayName                         339
	XDestroyWindow                       340
	XDestroySubwindows                   341
	XDeleteProperty                      342
	XDefineCursor                        343
	XLoadFont                            344
	XUnloadFont                          345
	XCreateFontCursor                    346
	XCreateSimpleWindow                  347
	XCreatePixmapFromBitmapData          348
	XCreateGlyphCursor                   349
	XGContextFromGC                      350
	_XGenerateGCList                     351
	XCreatePixmapCursor                  352
	XCreateColormap                      353
	XPutImage                            354
	XCreateGC                            355
	XCreatePixmap                        356
	XCreateBitmapFromData                357
	XCopyPlane                           358
	XCopyGC                              359
	XCopyColormapAndFree                 360
	XCopyArea                            361
	XConvertSelection                    362
	_XEnq                                363
	_XError                              364
	_BytesReadable                       365
	_XSendClientPrefix                   366
	_XWaitForReadable                    367
	_XWaitForWritable                    368
	_XConnectDisplay                     369
	XMoveResizeWindow                    370
	XClearArea                           371
	XClearWindow                         372
	_XFreeDisplayStructure               373
	_XDisconnectDisplay                  374
	XSync                                375
	XFreeGC                              376
	XCloseDisplay                        377
	XCirculateSubwindowsUp               378
	XCirculateSubwindowsDown             379
	XCirculateSubwindows                 380
	XCheckTypedWindowEvent               381
	XCheckTypedEvent                     382
	XCheckWindowEvent                    383
	XCheckMaskEvent                      384
	_XEventsQueued                       385
	XCheckIfEvent                        386
	XResizeWindow                        387
	_XProcessWindowAttributes            388
	XChangeWindowAttributes              389
	XRemoveFromSaveSet                   390
	XAddToSaveSet                        391
	XChangeSaveSet                       392
	XChangeProperty                      393
	XChangePointerControl                394
	_XSend                               395
	_XFlushGCCache                       396
	_XUpdateGCCache                      397
	XChangeGC                            398
	XSetWindowColormap                   399
	XChangeActivePointerGrab             400
	XSetCloseDownMode                    401
	XSetAccessControl                    402
	XDisableAccessControl                403
	XEnableAccessControl                 404
	XSetWindowBorder                     405
	XBell                                406
	XSetWindowBorderWidth                407
	XSetWindowBackground                 408
	XChangeKeyboardControl               409
	XAutoRepeatOff                       410
	XAutoRepeatOn                        411
	XAllowEvents                         412
	XAllocColorPlanes                    413
	_XRead                               414
	_XReply                              415
	_XFlush                              416
	XAllocColorCells                     417
	XrmQuarkToString                     418
	XrmUniqueQuark                       419
	XrmStringToQuark                     420
	Xpermalloc                           421
	XrmPutLineResource                   422
	XrmQPutStringResource                423
	XrmStringToBindingQuarkList          424
	XrmParseCommand                      425
	XDeleteContext                       426
	XFindContext                         427
	XSaveContext                         428
	CloseTcpStream                       429
	WriteTcpStream                       430
	ReadTcpStream                        431
	CallTcpServer                        432
	ConnectTcpClient                     433
	SetupTcpStream                       434
	CloseTliStream                       435
	WriteTliStream                       436
	ReadTliStream                        437
	CallTliServer                        438
	ConnectTliClient                     439
	SetupTliStream                       440
	CloseLocalStream                     441
	WriteLocalStream                     442
	ReadLocalStream                      443
	CallLocalServer                      444
	ConnectLocalClient                   445
	SetupLocalStream                     446
	ErrorCall                            447
	usleep                               448
	select                               449
	srandom                              450
	random                               451
	writev                               452
	readv                                453
	remque                               454
	insque                               455
	rindex                               456
	index                                457
	gettimeofday                         458
	gethostname                          459
	ffs                                  460
	bzero                                461
	bcmp                                 462
	bcopy                                463

#objects
	libXi.o
	evtomask.o
	Xrm.o
	XlibInt.o
	XWrBitF.o
	XWindow.o
	XWinEvent.o
	XWarpPtr.o
	XVisUtil.o
	XUnmapWin.o
	XUnmapSubs.o
	XUnldFont.o
	XUninsCmap.o
	XUngrabSvr.o
	XUngrabPtr.o
	XUngrabKey.o
	XUngrabKbd.o
	XUngrabBut.o
	XUndefCurs.o
	XTrCoords.o
	XTextExt16.o
	XTextExt.o
	XText16.o
	XText.o
	XSynchro.o
	XSync.o
	XStrKeysym.o
	XStName.o
	XStNColor.o
	XStColors.o
	XStColor.o
	XStBytes.o
	XSetTSOrig.o
	XSetTile.o
	XSetStCmap.o
	XSetStip.o
	XSetState.o
	XSetSSaver.o
	XSetSOwner.o
	XSetPntMap.o
	XSetPMask.o
	XSetLStyle.o
	XSetIFocus.o
	XSetHints.o
	XSetFunc.o
	XSetFore.o
	XSetFont.o
	XSetFPath.o
	XSetDashes.o
	XSetClOrig.o
	XSetClMask.o
	XSetCRects.o
	XSetBack.o
	XSendEvent.o
	XSelInput.o
	XRotProp.o
	XRestackWs.o
	XRepWindow.o
	XRegion.o
	XReconfWin.o
	XRecolorC.o
	XRdBitF.o
	XRaiseWin.o
	XQuTree.o
	XQuTileShp.o
	XQuTextExt.o
	XQuTextE16.o
	XQuStipShp.o
	XQuPntr.o
	XQuKeybd.o
	XQuExt.o
	XQuCurShp.o
	XQuColors.o
	XQuColor.o
	XQuBest.o
	XPutImage.o
	XPutBEvent.o
	XPolyTxt16.o
	XPolyTxt.o
	XPolyReg.o
	XPmapBord.o
	XPmapBgnd.o
	XPending.o
	XPeekIfEv.o
	XPeekEvent.o
	XParseGeom.o
	XParseCol.o
	XOpenDis.o
	XNextEvent.o
	XMoveWin.o
	XModMap.o
	XMaskEvent.o
	XMapWindow.o
	XMapSubs.o
	XMapRaised.o
	XMacros.o
	XLowerWin.o
	XLookupCol.o
	XLoadFont.o
	XListExt.o
	XLiProps.o
	XLiICmaps.o
	XLiHosts.o
	XKillCl.o
	XKeyBind.o
	XIntAtom.o
	XInsCmap.o
	XInitExt.o
	XImText16.o
	XImText.o
	XImUtil.o
	XIfEvent.o
	XHost.o
	XGrServer.o
	XGrPointer.o
	XGrKeybd.o
	XGrKey.o
	XGrButton.o
	XGetWAttrs.o
	XGetStCmap.o
	XGetSSaver.o
	XGetSOwner.o
	XGetProp.o
	XGetPntMap.o
	XGetPCnt.o
	XGetMoEv.o
	XGetKCnt.o
	XGetImage.o
	XGetIFocus.o
	XGetHints.o
	XGetHColor.o
	XGetGeom.o
	XGetFProp.o
	XGetFPath.o
	XGetDflt.o
	XGetColor.o
	XGetAtomNm.o
	XGeom.o
	XGCMisc.o
	XFSSaver.o
	XFreePix.o
	XFreeGC.o
	XFreeEData.o
	XFreeCurs.o
	XFreeCols.o
	XFreeCmap.o
	XFontInfo.o
	XFontNames.o
	XFont.o
	XFlush.o
	XFillRects.o
	XFillRect.o
	XFillPoly.o
	XFillArcs.o
	XFillArc.o
	XFetchName.o
	XEvToWire.o
	XErrHndlr.o
	XErrDes.o
	XDrSegs.o
	XDrRects.o
	XDrRect.o
	XDrPoints.o
	XDrPoint.o
	XDrLines.o
	XDrLine.o
	XDrArcs.o
	XDrArc.o
	XDisName.o
	XDestWind.o
	XDestSubs.o
	XDelProp.o
	XDefCursor.o
	XCursor.o
	XCrWindow.o
	XCrPixmap.o
	XCrPFBData.o
	XCrGlCur.o
	XCrGC.o
	XCrCursor.o
	XCrCmap.o
	XCrBFData.o
	XCopyPlane.o
	XCopyGC.o
	XCopyCmap.o
	XCopyArea.o
	XConvSel.o
	XConnDis.o
	XConfWind.o
	XClearArea.o
	XClear.o
	XClDisplay.o
	XCirWinUp.o
	XCirWinDn.o
	XCirWin.o
	XChkTypWEv.o
	XChkTypEv.o
	XChkWinEv.o
	XChkMaskEv.o
	XChkIfEv.o
	XChWindow.o
	XChWAttrs.o
	XChSaveSet.o
	XChProp.o
	XChPntCon.o
	XChKeyCon.o
	XChGC.o
	XChCmap.o
	XChActPGb.o
	XChClMode.o
	XChAccCon.o
	XBorder.o
	XBell.o
	XBdrWidth.o
	XBackgnd.o
	XAutoRep.o
	XAllowEv.o
	XAllPlanes.o
	XAllCells.o
	Quarks.o
	ParseCmd.o
	Context.o
	Xstreams.o
	usleep.o
	select.o
	random.o
	iovec.o
	insque.o
	index.o
	gettimeofday.o
	gethostname.o
	bstring.o


#init	libXi.o
	_libX_fscanf                        	fscanf
	_libX_sscanf                        	sscanf
	_libX_fgets                         	fgets
	_libX_fopen                         	fopen
	_libX_fclose                        	fclose
	_libX_abs                           	abs
	_libX_fwrite                        	fwrite
	_libX_fputs                         	fputs
	_libX_getpwuid                      	getpwuid
	_libX_getuid                        	getuid
	_libX_getpwnam                      	getpwnam
	_libX_getenv                        	getenv
	_libX_ioctl                         	ioctl
	_libX_strcpy                        	strcpy
	_libX_fcntl                         	fcntl
	_libX__ctype                        	_ctype
	_libX_memchr                        	memchr
	_libX_memccpy                       	memccpy
	_libX_strcmp                        	strcmp
	_libX_exit                          	exit
	_libX_realloc                       	realloc
	_libX_calloc                        	calloc
	_libX_t_unbind                      	t_unbind
	_libX_t_snddis                      	t_snddis
	_libX_t_snd                         	t_snd
	_libX_t_rcv                         	t_rcv
	_libX_t_connect                     	t_connect
	_libX_t_free                        	t_free
	_libX_t_accept                      	t_accept
	_libX_t_close                       	t_close
	_libX_t_errno                       	t_errno
	_libX_t_listen                      	t_listen
	_libX_t_look                        	t_look
	_libX_t_bind                        	t_bind
	_libX_t_alloc                       	t_alloc
	_libX_t_error                       	t_error
	_libX_t_open                        	t_open
	_libX_alarm                         	alarm
	_libX_signal                        	signal
	_libX_strlen                        	strlen
	_libX_write                         	write
	_libX_strcat                        	strcat
	_libX_read                          	read
	_libX_close                         	close
	_libX_chmod                         	chmod
	_libX_link                          	link
	_libX_ptsname                       	ptsname
	_libX_unlink                        	unlink
	_libX_sprintf                       	sprintf
	_libX_atoi                          	atoi
	_libX_unlockpt                      	unlockpt
	_libX_grantpt                       	grantpt
	_libX_perror                        	perror
	_libX_open                          	open
	_libX_fprintf                       	fprintf
	_libX__iob                          	_iob
	_libX_poll                          	poll
	_libX_ulimit                        	ulimit
	_libX_srand                         	srand
	_libX_rand                          	rand
	_libX_free                          	free
	_libX_malloc                        	malloc
	_libX_strrchr                       	strrchr
	_libX_strchr                        	strchr
	_libX_daylight                      	daylight
	_libX_timezone                      	timezone
	_libX_time                          	time
	_libX_strncpy                       	strncpy
	_libX_uname                         	uname
	_libX_errno                         	errno
	_libX_memset                        	memset
	_libX_memcmp                        	memcmp
	_libX_memcpy                        	memcpy
#objects noload
	-lc_s
	-lnsl_s
#hide linker *
#export linker
	_Xdebug
	_XHeadOfDisplayList
	XErrorList
	XErrorListSize
	_XIOErrorFunction
	_XErrorFunction
	XrmQEyes
	XrmQEtrue
	XrmQEon
	XrmQEoff
	XrmQEno
	XrmQEfalse
	XrmQWindow
	XrmQString
	XrmQPointer
	XrmQPixmap
	XrmQPixel
	XrmQInt
	XrmQGeometry
	XrmQFontStruct
	XrmQFont
	XrmQFile
	XrmQDisplay
	XrmQDims
	XrmQCursor
	XrmQColor
	XrmQBoolean
	TypeOfStream
	xstream
.ft P
.DE
.TC

