/* 
 * cabinet.c - Our stupid client program.
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#include <stdio.h>
#include <math.h>
#include "pexDICE.h"

Ppoint3 origSquare[] = { 
    -5.0, -4.0, 0.0,
    -5.0, 4.0, 0.0, 
    -5.9, 4.0, 0.0, 
    -5.9, -4.0, 0.0,
    -5.0, -4.0, 0.0, 
};

Ppoint3 square[] = { 
    -5.0, 0.0, 0.0, 
    -5.9, 0.0, 0.0,
    -5.9, 8.0, 0.0, 
    -5.0, 8.0, 0.0, 
    -5.0, 0.0, 0.0
};

char *colorStr[] = {
    "0",
    "1",
    "2",
    "3",
    "4",
    "5",
    "6",
    "7",
    "8",
    "9",
};

pexCoord3D textPt = { -5.4, -5.0, 0.0 };
pexCoord3D origTextPt = { -5.4, -5.0, 0.0 };
pexCoord3D textOff = { 0.0, 0.0, 0.0 };


main(argc, argv)
int     argc;
char    *argv[];
{
    int i, j;

    XEvent pe;
    XExposeEvent *ee;
    XConfigureEvent *ce;

    /* Phigs variables */
    Ppoint3     vrp;        /* view reference point */
    Pvector3    vpn, nvpn;  /* view plane normal    */
    Pvector3    vup;        /* view up vector   */
    Pint        error;      /* error indicator  */
    Pmatrix3    roty;       /* y rotation matrix    */
    Pviewmapping3 map;      /* view mapping structure */
    Pviewrep3 viewrep;      /* Phigs view representation */
    XButtonPressedEvent *buttonEvent;
    int rotateCube = False;

    pexC *pexi;		/* pexi globals */

    solidflag = 1;

    /* Open phigs and one workstation */
    pexi = popenphigs(0, 0, argc, argv );  
    popenws(pexi, 0, 0, 0);

    /*
     * Set up X for MouseButton Events.
     */
    XSelectInput(pexi->phigsDisplay, pexi->phigsWindow, 
		 ExposureMask | StructureNotifyMask | ButtonPressMask );
    
    /* Set up the PHIGS view */
    vrp.x = 0.0; vrp.y = 0.0; vrp.z = 0.0;
    vpn.x = 0.0; vpn.y = 0.0; vpn.z = 1.0;
    vup.x = 0.0; vup.y = 1.0; vup.z = 0.0;

    pevalvieworientationmatrix3(&vrp, &vpn, &vup, 
        &error, viewrep.orientation_matrix);

    map.window.xmin = -2.0; map.window.ymin = -2.0;
    map.window.xmax =  10.0; map.window.ymax =  10.0;
    map.view_plane = 20.0;
    map.back_plane = -10.0;
    map.front_plane = 10.0;

    map.viewport.xmin= 0.0; map.viewport.ymin= 0.0; map.viewport.zmin= -1.0;
    map.viewport.xmax= 1.0; map.viewport.ymax= 1.0; map.viewport.zmax= 0.0;
    map.proj = PPARALLEL; 
    
    map.prp.x = 0.0;
    map.prp.y = 0.0;
    map.prp.z = 2.0;

    pevalviewmappingmatrix3(&map, &error, viewrep.mapping_matrix);

    viewrep.clip_xy = PCLIP;
    viewrep.clip_back = PCLIP;
    viewrep.clip_front = PCLIP;
    viewrep.clip_limit.xmin = map.viewport.xmin;
    viewrep.clip_limit.xmax = map.viewport.xmax;
    viewrep.clip_limit.ymin = map.viewport.ymin;
    viewrep.clip_limit.ymax = map.viewport.ymax;
    viewrep.clip_limit.zmin = map.viewport.zmin;
    viewrep.clip_limit.zmax = map.viewport.zmax;

    psetviewrep3(pexi, 1, &viewrep );

    SetPexSurfaceFlags(pexi);
    
    while(1) {

        XNextEvent(pexi->phigsDisplay, &pe);
	
        switch( pe.type ) {
	    
	case Expose:
	    ee = (XExposeEvent *) &pe;
	    while (ee->count) {
		XNextEvent(pexi->phigsDisplay, &pe);       
		ee = (XExposeEvent *) &pe;
 	    }
	    break;
		
	case NoExpose:
	    continue;

	case ConfigureNotify:
	    ce = (XConfigureEvent *)&pe;
	    pexi->winx = ce->x;
	    pexi->winy = ce->y;
	    pexi->winw = ce->width;
	    pexi->winh = ce->height;
	    break;

	case ButtonPress:
	    buttonEvent = (XButtonPressedEvent *) &pe;
	    switch (buttonEvent->button)
	    {
	    case 1:
		protatey(10.0 * 3.1415 / 180.0, &error, roty );
		rotateCube = True;
		break;
	    case 2:
		rotateCube = False;
		break;
	    case 3:
		protatey(-10.0 * 3.1415 / 180.0, &error, roty );
		rotateCube = True;
		break;
	    }
	    break;
	}

	if (rotateCube)
	    PexLocalTransform(pexi, PostConcatenate, roty);

	PexBeginRendering(pexi);
	
	psetviewind(pexi, 1); 		/* Set to view index 1 */

	PexRenderOutputCommands(pexi);
	PexLineColorIndex(pexi, pexi->lineColorIndex);

	for ( i = 0; i < 5; i++ )
	    square[i] = origSquare[i];
	textPt = origTextPt;

	for ( i = 0; i < 8; i++ )
	{
	    PexSurfaceColorIndex(pexi, i);
	    PexFillAreaWithData(pexi, Unknown, RgbFloat,
				SurfaceEdgeSolid, 5, square,
				NULL, NULL, NULL, NULL);

	    PexAnnoText(pexi, colorStr[i], &textPt, &textOff);
	    

	    for ( j = 0; j < 5; j++ )
		square[j].x += 1.25;
	    textPt.x += 1.25;
	}


	PexEndRendComm(pexi);
	
	PexEndRendering(pexi);
	
	/* Flush X */
	XFlush(pexi->phigsDisplay);
	
    }
}
