/* 
 * PView.c - View stuff, I dunno
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *			   All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#include "phigserr.h"
#include "X.h"
#include "PEX.h"
#include "pexDICE.h"

/*
 ******************************************************************************
 *
 *	Function:	psetviewrep3(ws, index, rep)
 *
 *	On Entry:
 *
 *	On Exit:
 *
 *	Notes:
 *
 *
 ******************************************************************************
 */
void
psetviewrep3(pexi, index, rep)
    register pexC *pexi;
    pexTableIndex	index;		/* view index	*/
    Pviewrep3	*rep;	/* view representation	*/
{
    
    
    PexSetViewRep(pexi,
		  index,
		  rep->clip_xy,
		  rep->clip_back,
		  rep->clip_front,
		  rep->orientation_matrix,
		  rep->mapping_matrix,
		  rep->clip_limit.xmin,
		  rep->clip_limit.xmax,
		  rep->clip_limit.ymin,
		  rep->clip_limit.ymax,
		  rep->clip_limit.zmin,
		  rep->clip_limit.zmax
		  );
    
}

/*
 ******************************************************************************
 *
 *	Function:	pevalvieworientationmatrix3(vrp, vpn, vup, error_ind, matrix)
 *
 *	On Entry:	vrp			View Reference Point.
 *				vpn			View Plane Normal.
 *				vup			View Up Vector.
 *
 *	On Exit:
 *				error_ind	Error Indicator.
 *				matrix		Orientation Matrix.
 *
 *	Notes:
 *
 *
 ******************************************************************************
 */
void
pevalvieworientationmatrix3(vrp, vpn, vup, error_ind, matrix)
    Ppoint3 *vrp;		/* view reference point	*/
    Pvector3 *vpn;		/* view plane normal	*/
    Pvector3 *vup;		/* view up vector	*/
    Pint *error_ind;		/* OUT error indicator	*/
    Pmatrix3 matrix;		/* OUT view orientation matrix	*/
{
    int i;
    Pmatrix3	mx, my, mz, mt;
    Ppoint3	t, nvup;
    float	phix, phiy, phiz; /* Rotation angles */
    Pint	error;
    double	atan3();

    /* Rotate view plane normal onto the z-axis */
    pident3(matrix);
    phiy = (float) -atan3( vpn->x, vpn->z );
    
    /* rot_y( phiy, matrix ); */
    protatey(phiy, &error, my);
    
    phix = (float) atan3( vpn->y, 
			 sqrt( vpn->x*vpn->x + vpn->z*vpn->z ));
    protatex(phix, &error, mx);
    
    /* matrix =  my * mx */
    pcomposematrix3(my, mx, error_ind, matrix);
    
    /* Rotate up-vector by matrix */
    ptranvc3(vup, matrix, error_ind, &nvup);
    
    /* Calculate up-vector rotation */
    phiz = (float) atan3( nvup.x, nvup.y );
    protatez(phiz, &error, mz);
    
    /* Now, build the view matrix */
    t.x = -vrp->x;
    t.y = -vrp->y;
    t.z = -vrp->z;
    ptranslate3(&t, &error, mt);
    
    pcomposematrix3(mt, my, error_ind, matrix);
    pcomposematrix3(matrix, mx, error_ind, mt);
    pcomposematrix3(mt, mz, error_ind, matrix);
    
}


void
pevalvieworientationmatrix(vrp, vup, error_ind, matrix)
    Ppoint	*vrp;			/* view reference point	*/
    Pvector	*vup;			/* view up vector	*/
    Pint	*error_ind;		/* OUT error indicator	*/
    Pmatrix	matrix;			/* OUT view orientation matrix	*/
{
}


/*
 ******************************************************************************
 *
 *	Function:	pevalviewmappingmatrix3(mapping, error_ind, matrix)
 *
 *	Creates the matrix which maps the view volume (specified in VRC
 *	coordinates) onto the view clipping limits (specified in NPC
 *	coordinates).
 *
 *	On Entry:	
 *		Pviewmapping3	*mapping;	View mapping	
 *
 *	On Exit:
 *		Pint		*error_ind;	Error indicator
 *		Pmatrix		matrix;		View mapping matrix
 *
 *	Notes:
 *		Could be made much more efficient.
 *
 *
 ******************************************************************************
 */
void
pevalviewmappingmatrix3(mapping, error_ind, matrix)
    Pviewmapping3 *mapping;	/* view mapping	*/
    Pint *error_ind;		/* OUT error indicator	*/
    Pmatrix3 matrix;		/* OUT view mapping matrix	*/
{
    int error;
    float F;
    float a1, b1;
    float cx, cy;
    float tx, ty, tz;
    float zvmin;
    float front, back;
    float xmin0, xmax0, ymin0, ymax0;
    Pmatrix3 mt, rtol, mtmp1, mshear, mtmp2, mscale, mper, mnpc;
    
    float llx    = mapping->window.xmin;
    float lly    = mapping->window.ymin;
    float llz    = mapping->front_plane;
    float urx    = mapping->window.xmax;
    float ury    = mapping->window.ymax;
    float urz    = mapping->back_plane;
    float hither = mapping->prp.z - mapping->front_plane;
    float yon    = mapping->prp.z - mapping->back_plane;
    float view   = mapping->prp.z - mapping->view_plane;
    
    float xmin = mapping->viewport.xmin; 
    float ymin = mapping->viewport.ymin; 
    float zmin = mapping->viewport.zmin;
    float xmax = mapping->viewport.xmax;
    float ymax = mapping->viewport.ymax;
    float zmax = mapping->viewport.zmax;
    
    pident3(matrix);
    
    if( mapping->proj == PPERSPECTIVE ) {
	
	/*	The matrix is created from a concatenation of several
	 *  sub-matrices.  First we translate the perspective reference
	 *  point to the origin.  Then we switch from right to left
	 *  handed coordinate systems.	From this point on, we follow
	 *  Foley and VanDam section 8.4.2 very closely.  We shear
	 *  to align the view volume center line with the z-axis.
	 *  This is followed by a scale to the canonical view volume.
	 *  Then we multiply by the perspective transformation matrix,
	 *  this gives a cube -1->1, -1->1, 0->1.  We then scale and
	 *  translate to the npc subvolume.
	 *
	 */
	
	/* Create the translation matrix */
	pident3(mt );
	mt[3][0] = -mapping->prp.x;
	mt[3][1] = -mapping->prp.y;
	mt[3][2] = -mapping->prp.z;
	
	/* Create the right to left xform */
	pident3(rtol );
	rtol[2][2] = -1.0;
	
	/* Create the Shear matrix */
	pident3(mshear );
	mshear[2][0] = -(-mapping->prp.x + 0.5*(llx+urx)) / mapping->prp.z;
	mshear[2][1] = -(-mapping->prp.y + 0.5*(lly+ury)) / mapping->prp.z;
	
	/* Create the Scale matrix */
	pident3(mscale );
	mscale[0][0] = 2.0 * view / ( (urx-llx) * yon );
	mscale[1][1] = 2.0 * view / ( (ury-lly) * yon );
	mscale[2][2] = 1.0 / yon;
	
	/* Create the perspective transformation matrix */
	zvmin = (mapping->prp.z - mapping->front_plane) / 
	    (mapping->prp.z - mapping->back_plane);
	pident3(mper );
	mper[3][3] = 0.0;
	mper[2][3] = 1.0;
	mper[2][2] = 1.0 / ( 1.0 - zvmin );
	mper[3][2] = -zvmin / (1.0 - zvmin);
	
	/* Create the mnpc matrix which maps -1->1, -1->1, 0->1 cube
	 * to the npc subvolume.
	 */
	pident3(mnpc);
	mnpc[0][0] = (xmax - xmin) / 2.0;
	mnpc[1][1] = (ymax - ymin) / 2.0;
	mnpc[2][2] = (zmax - zmin) / -1.0;
	mnpc[3][0] = (xmax + xmin) / 2.0;
	mnpc[3][1] = (ymax + ymin) / 2.0;
	mnpc[3][2] = -0.5 * mnpc[2][2] + (zmax + zmin) / 2.0;
	
	pcomposematrix3(mt, rtol, &error, mtmp1);
	pcomposematrix3(mtmp1, mshear, &error, mtmp2);
	pcomposematrix3(mtmp2, mscale, &error, mtmp1);
	pcomposematrix3(mtmp1, mper, &error, mtmp2);
	pcomposematrix3(mtmp2, mnpc, &error, matrix);
	
    }
    else {
	
	/*
	 *	Concatenation of a shear, so that the direction of projection 
	 *  is aligned with the z-axis, a translate to the center
	 *  of the window, a scale to the size of the npc sub-volume,
	 *  and a translate by center of ndc subvolume.	 Again, See Foley 
	 *  and VanDam, section 8.4.1.
	 */
	
	front = mapping->front_plane;
	back  = mapping->back_plane;
	
	/* Calculate the center of the window */
	cx = (llx + urx) / 2.0;
	cy = (lly + ury) / 2.0;
	
	/* Calculate the shear coefficients */
	a1 = (cx - mapping->prp.x ) / (mapping->prp.z - mapping->view_plane);
	b1 = (cy - mapping->prp.y ) / (mapping->prp.z - mapping->view_plane);
	
	/* Find window at the z=0 plane */
	xmin0 = llx + a1 * mapping->view_plane;
	xmax0 = urx + a1 * mapping->view_plane;
	ymin0 = lly + b1 * mapping->view_plane;
	ymax0 = ury + b1 * mapping->view_plane;
	
	/* Create the Shear matrix */
	pident3(mshear );
	mshear[2][0] = a1;
	mshear[2][1] = b1;
	
	/* Create the matrix to translate by -center of window */
	pident3(mt );
	mt[3][0] = -(xmin0 + xmax0) / 2.0;
	mt[3][1] = -(ymin0 + ymax0) / 2.0;
	mt[3][2] = -(back  + front) / 2.0;
	
	/* Create the Scale matrix */
	pident3(mscale );
	mscale[0][0] = (xmax - xmin) / (xmax0 - xmin0);
	mscale[1][1] = (ymax - ymin) / (ymax0 - ymin0);
	mscale[2][2] = (zmax - zmin) / (front - back);
	
	/* Create the mnpc matrix which translates by the center of
	 * the npc subvolume.
	 */
	pident3(mnpc);
	mnpc[3][0] = (xmax + xmin) / 2.0;
	mnpc[3][1] = (ymax + ymin) / 2.0;
	mnpc[3][2] = (zmax + zmin) / 2.0;
	
	/* Build the required matrix */
	pcomposematrix3(mshear, mt, &error, mtmp1);
	pcomposematrix3(mtmp1, mscale, &error, mtmp2);
	pcomposematrix3(mtmp2, mnpc, &error, matrix);
    }
}

/*
 ******************************************************************************
 *
 *	Function:	psetviewind
 *
 *	On Entry:	
 *
 *	On Exit:
 *
 *	Notes:
 *
 *
 ******************************************************************************
 */
psetviewind(pexi, index )
    register pexC *pexi;
    pexTableIndex	index;
{
    register Display *dpy = pexi->phigsDisplay;
    register pexRenderOutputCommandsReq *req;
    pexViewIndex oc;
    int one_shot = 0;
    
    if( ( req = pexi->curRenderOut ) == 0 )
    {
	PexRenderOutputCommands(pexi);
	one_shot++;
	req = pexi->curRenderOut;
    }

    oc.head.elementType = OCViewIndex;
    oc.head.length = sizeof(pexViewIndex)>>2;
    oc.index = index;

    req->numCommands++;

    pexPackData (pexi, (char *)(&oc), sizeof(pexViewIndex));
    req->length	+= sizeof (pexViewIndex)>>2;

    if ( one_shot )
	PexEndRendComm(pexi);
}
