/* 
 * pexDICE.h - Includes everything needed to compile DICE library.
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/****************************************************************************
 *	Notes:
 *		include file for files in the PEX DICE library
 *		this file should include EVERYTHING needed to
 *		compile itself
 *
 ****************************************************************************
 */

#ifndef PEXDICE_H
#define PEXDICE_H

#include "PEX.h"
#include "PEXproto.h"
/*
 * #include "PEXprotostr.h"
 */
#include "PEXpacket.h"

#include <stdio.h>
#include "phigs.h"
#include "Xlib.h"
#include "Xproto.h"
#include "Xatom.h"
#include "Xlibint.h"



struct SDICEGlobals
{                    /* PEXReqCode is major PEX opcode for X message packets */
   Psystemstate               sysstate;
   Pwsstate                   wsstate;
   Pstructstate               structstate;
   Parchivestate              archivestate;
   int                        PEXReqCode;
   Display                   *phigsDisplay;
   Window                     phigsWindow;
   XID			      renderer;
   int                        winx, winy, winw, winh;
   pexRenderOutputCommandsReq *curRenderOut;
   int			      lineColorIndex;
   char			      *buf_begin;
   char			      *buf_current;
   char 		      *buf_maximum;
   int			       buf_len;		
   int			      surfaceColorIndex;
};

#define pexPackData(pexi, data, len) \
    if (pexi->buf_current + (len) <= pexi->buf_maximum) {\
    bcopy(data, pexi->buf_current, (int)len);\
    pexi->buf_current += ((len) + 3) & ~3;\
}\
else\
{\
    while(pexi->buf_current + (len) > pexi->buf_maximum)\
    {\
	char *tempshit = pexi->buf_begin;\
	pexi->buf_len *= 2;\
	pexi->buf_begin = realloc(pexi->buf_begin, pexi->buf_len);\
	if (!pexi->buf_begin)\
	    abort();\
	pexi->buf_maximum=pexi->buf_begin + pexi->buf_len;\
	pexi->buf_current = (pexi->buf_current - tempshit) + pexi->buf_begin;\
    }\
    bcopy(data, pexi->buf_current, (int)len);\
    pexi->buf_current += ((len) + 3) & ~3;\
    }


typedef struct SDICEGlobals pexC;
 
pexC *popenphigs();	/* This now allocates the global for you. */
pexC *popenphigsextra();	/* A different version of above. */


#ifdef EXTERN

int smoothflag = 0;
int wireflag = 0;
int solidflag = 0;
int zbufferflag = 0;
int cullflag = 0;
int paintflag = 0; 

#else

extern int smoothflag;
extern int wireflag;
extern int solidflag;
extern int zbufferflag;
extern int cullflag;
extern int paintflag; 

#endif

#ifdef EXTERN
#undef EXTERN
#endif

#endif
