/* 
 * p1tst.c - Our other stupid client
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#include <stdio.h>
#include "X11/Xlib.h"
#include "X11/Xatom.h"
#include "PEXcolors.h"

#undef min
#undef max

#include "phigs.h"
#include "pexDICE.h"

Ppoint3 front[] = { 
    -4.0, -4.0, 4.0, 
    4.0, -4.0, 4.0,
    4.0,  4.0, 4.0, 
    -4.0,  4.0, 4.0, 
    -4.0, -4.0, 4.0,
};

Ppoint3 back[] = {
    -4.0, -4.0, 0.0,
    4.0, -4.0, 0.0,
    4.0,  4.0, 0.0,
    -4.0,  4.0, 0.0,
    -4.0, -4.0, 0.0
};

Ppoint3 edge1[] = {
    -4.0, -4.0, 4.0,
    -4.0, -4.0, 0.0
};

Ppoint3 edge2[] = {
    4.0, -4.0, 4.0,
    4.0, -4.0, 0.0
};

Ppoint3 edge3[] = {
    4.0, 4.0, 4.0,
    4.0, 4.0, 0.0
};

Ppoint3 edge4[] = {
    -4.0, 4.0, 4.0,
    -4.0, 4.0, 0.0
};

main(argc, argv)
int     argc;
char    *argv[];
{
    XEvent pe;
    XExposeEvent *ee;
    XConfigureEvent *ce;
    XColor clr, hukairz;
    
    /* Phigs variables */
    Ppoint3     vrp;        /* view reference point */
    Pvector3    vpn, nvpn;  /* view plane normal    */
    Pvector3    vup;        /* view up vector   */
    Pint        error;      /* error indicator  */
    Pmatrix3    roty;       /* y rotation matrix    */
    Pviewmapping3 map;      /* view mapping structure */
    Pviewrep3 viewrep;      /* Phigs view representation */
    pexC *pexi;

    /* Open phigs and one workstation */
    pexi = popenphigs(0, 0, argc, argv );   
    popenws(pexi, 0, 0, 0);

    /* Set up the PHIGS view */
    vrp.x = 0.0; vrp.y = 0.0; vrp.z = 0.0;
    vpn.x = 1.0; vpn.y = 2.0; vpn.z = 4.0;
    vup.x = 0.0; vup.y = 1.0; vup.z = 0.0;

    pevalvieworientationmatrix3(&vrp, &vpn, &vup, 
        &error, viewrep.orientation_matrix);

    map.window.xmin = -5.0; map.window.ymin = -5.0;
    map.window.xmax =  5.0; map.window.ymax =  5.0;
    map.view_plane = 0.0;
    map.back_plane = -10.0;
    map.front_plane = 10.0;

    map.viewport.xmin= 0.0; map.viewport.ymin= 0.0; map.viewport.zmin= -1.0;
    map.viewport.xmax= 1.0; map.viewport.ymax= 1.0; map.viewport.zmax= 0.0;
    map.prp.x = 0.0; map.prp.y = 0.0; map.prp.z = 20.0;
    map.proj = PPARALLEL; 

    pevalviewmappingmatrix3(&map, &error, viewrep.mapping_matrix);

    viewrep.clip_xy = PCLIP;
    viewrep.clip_back = PCLIP;
    viewrep.clip_front = PCLIP;
    viewrep.clip_limit.xmin = map.viewport.xmin;
    viewrep.clip_limit.xmax = map.viewport.xmax;
    viewrep.clip_limit.ymin = map.viewport.ymin;
    viewrep.clip_limit.ymax = map.viewport.ymax;
    viewrep.clip_limit.zmin = map.viewport.zmin;
    viewrep.clip_limit.zmax = map.viewport.zmax;
    
    psetviewrep3(pexi, 1, &viewrep );

    protatey(10.0 * 3.1415 / 180.0, &error, roty );

    clr.pixel = clr.red = clr.green = clr.blue = 0;
    clr.blue = 0xffff;

/* ***    XAllocColor(pexi->phigsDisplay,
		DefaultColormap(pexi->phigsDisplay,
				DefaultScreen(pexi->phigsDisplay)),
		&clr);
*** */

    while(1) {

       /* This should get first exposure event */    
        XNextEvent(pexi->phigsDisplay, &pe);

        switch( pe.type ) {

            case Expose:
                ee = (XExposeEvent *) &pe;
                while (ee->count) {
                    XNextEvent(pexi->phigsDisplay, &pe);       
                    ee = (XExposeEvent *) &pe;
                }
                break;

            case ConfigureNotify:
                ce = (XConfigureEvent *)&pe;
                pexi->winx = ce->x;
                pexi->winy = ce->y;
                pexi->winw = ce->width;
                pexi->winh = ce->height;
                break;
        }

        while (! XPending(pexi->phigsDisplay)) {

	    PexBeginRendering(pexi);
	
            /* Set view index 1 */
            psetviewind(pexi, 1);

	    PexRenderOutputCommands(pexi);

	    PexLineColorIndex(pexi, pexMagenta);
	    
	    PexPolyline(pexi, 5, front);
	    PexPolyline(pexi, 5, back);
	    PexPolyline(pexi, 2, edge1);
	    PexPolyline(pexi, 2, edge2);
	    PexPolyline(pexi, 2, edge3);
	    PexPolyline(pexi, 2, edge4);
	    
	    PexEndRendComm(pexi);
	    
	    PexEndRendering(pexi);
	    
            /* Flush X and wait a bit */
            XFlush(pexi->phigsDisplay);
	    XSync(pexi->phigsDisplay);
	    
	    PexLocalTransform (pexi, PostConcatenate, roty);
        }
    }
}
