/* 
 * PexFormMain.c - Xt widget crap...
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* 
 * PexFormMain.c - Mainline for PEX transform demo.
 * 
 */

#include <stdio.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/Command.h>
#include <X11/Label.h>
#include "Xswt/CScroll.h"
#include "Xswt/Slate.h"
#include <X11/Cardinals.h>
#include <Xw/Xw.h>
#include <Xw/Form.h>

#include "pexDICE.h"

int pexfg = 0;

#ifdef sun
String machine_type = "Running on Sun";
#endif
#ifdef vax
String machine_type = "Running on Vax";
#endif
#ifdef hpux
String machine_type = "Running on HP";
#endif

void rotatex(), rotatey(), rotatez(), translatex(), translatey(), translatez();
void (*scroll_fn[6])() = {
    rotatex,		translatex,
    rotatey,		translatey,
    rotatez,		translatez,
};

char * label_text[6] = {
    "X Rotate",         "X Translate",
    "Y Rotate",         "Y Translate",
    "Z Rotate",         "Z Translate",
};
Widget scrollbars[6];
Widget toplevel, form, scrollform, buttonform, modebutton, quitbutton;
Widget slatetop, slate;


#define TIMEOUT_INTERVAL	100
int redisp = 0;
void Timeout()
{
    if ( redisp ) DrawTheThing();
    (void)XtAddTimeOut( TIMEOUT_INTERVAL, Timeout, NULL );
}


Boolean ScrollMode = False;     /* continuous scroll is default */

void ToggleMode( w, closure, call_data )
Widget w;
caddr_t closure;
caddr_t call_data;
{
    Arg comarg[1], scrollarg[3];
    int i;

    ScrollMode = !ScrollMode;
    if ( ScrollMode )
    {
	XtSetArg( comarg[0], XtNlabel, "Discrete" );
	XtSetArg( scrollarg[0], XtNrelative, False );
	XtSetArg( scrollarg[1], XtNrecenter, True );
	XtSetArg( scrollarg[2], XtNdiscrete, True );
    }
    else
    {
	XtSetArg( comarg[0], XtNlabel, "Continuous" );
	XtSetArg( scrollarg[0], XtNrelative, True );
	XtSetArg( scrollarg[1], XtNrecenter, False );
	XtSetArg( scrollarg[2], XtNdiscrete, False );
    }

    XtSetValues( w, comarg, ONE );

    for ( i = 0; i < 6; i++ )
	XtSetValues( scrollbars[i], scrollarg, THREE );
}

void Quit( w, closure, call_data )
    Widget w;
    caddr_t closure;
    int call_data;
{
    exit( 0 );
}


void Scrolled(w, closure, call_data)
    Widget w;
    caddr_t closure;
    int call_data;
{
    static int scroll_len;
    static float shown;
    static Arg args[] = {
	{ XtNlength, (XtArgVal)&scroll_len },
	{ XtNshown, (XtArgVal)&shown }
    };

    XtGetValues( w, args, XtNumber(args) );
    
    if ( call_data > 0 && shown > 0.05 )
	shown /= 2.0;
    if ( call_data < 0 && shown < 0.25 )
	shown *= 2.0;
    if ( shown == 0.0 )
	shown = 0.1;

    XtCScrollBarSetThumb( w, -1.0, shown );
}


void Thumbed(w, closure, top)
    Widget w;
    caddr_t closure;
    float *top;
{
    if ( (int)closure < 0 || (int)closure >= 6 )
	printf( "Bad scrollbar %d\n", (int)closure );
    (*scroll_fn[(int)closure])(top[0] * top[1] / 0.1);
}

void Redisp(w, closure, call_data)
Widget w;
caddr_t closure;
caddr_t call_data;
{
    DrawTheThing();
}

main( argc, argv )
char ** argv;
{
    Arg arg[30];
    int i, n;
    Widget machlabel;
    static XtCallbackRec scrollCallbacks[] = {
      { Scrolled, NULL },
      { NULL, NULL },
    };
    static XtCallbackRec thumbCallbacks[] = {
      { Thumbed, NULL },
      { NULL, NULL },
    };
    static XtCallbackRec modeCallbacks[] = {
      { ToggleMode, NULL },
      { NULL, NULL },
    };
    static XtCallbackRec quitCallbacks[] = {
      { Quit, NULL },
      { NULL, NULL },
    };
    static XrmOptionDescRec options[] = {
	{ "-pexfg", "*Slate.highlight", XrmoptionSepArg, "red" },
	{ "-pexbg", "*Slate.background", XrmoptionSepArg, "black" },
    };

    toplevel = XtInitialize( NULL, "XForm", options, XtNumber(options),
			     &argc, argv );

    XtSetArg( arg[0], XtNheight, 300 );
    XtSetArg( arg[1], XtNwidth, 400 );
    form = XtCreateManagedWidget( "form", XwformWidgetClass, toplevel,
				  arg, THREE );

    /* Make form to put scrollbars in */
    n = 0;
    XtSetArg( arg[n], XtNborderWidth, 0 );		n++;
    XtSetArg( arg[n], XtNxResizable, True );		n++;
    XtSetArg( arg[n], XtNyResizable, True );		n++;
    XtSetArg( arg[n], XtNxRefWidget, form );		n++;
    XtSetArg( arg[n], XtNyRefWidget, form );		n++;
    XtSetArg( arg[n], XtNxAttachRight, True );		n++;
    scrollform = XtCreateManagedWidget( "scrollform", XwformWidgetClass,
					form, arg, n );

    for ( i = 0; i < 6; i++ )
    {
	n = 0;
	XtSetArg( arg[n], XtNlabel, label_text[i] );            n++;
	XtSetArg( arg[n], XtNxResizable, True );		n++;
	XtSetArg( arg[n], XtNyResizable, True );		n++;
	XtSetArg( arg[n], XtNxOffset, 10 );			n++;
	XtSetArg( arg[n], XtNyOffset, 10 );			n++;
	XtSetArg( arg[n], XtNxAttachOffset, 10 );		n++;
	XtSetArg( arg[n], XtNyAttachOffset, 10 );		n++;
	XtSetArg( arg[n], XtNxVaryOffset, False );		n++;
	XtSetArg( arg[n], XtNyVaryOffset, False );		n++;
	/* Now, figure out positioning */
	if ( i >= 2 )           /* Not At top */
	{
	    XtSetArg( arg[n], XtNyRefWidget, scrollbars[i-2] );	n++;
	    XtSetArg( arg[n], XtNyAddHeight, True );		n++;
	}
	else
	{
	    XtSetArg( arg[n], XtNyRefWidget, scrollform );	n++;
	}
	if ( i % 2 )            /* Right */
	{
/*	    XtSetArg( arg[n], XtNxAttachRight, True );		n++;*/
	    XtSetArg( arg[n], XtNxRefWidget, scrollbars[i-1] );	n++;
	    XtSetArg( arg[n], XtNxAddWidth, True );		n++;
	}
	else                    /* Left */
	{
	    XtSetArg( arg[n], XtNxRefWidget, scrollform );	n++;
	    XtSetArg( arg[n], XtNxAddWidth, True );		n++;
	}
	XtSetArg( arg[n], XtNorientation, XtorientHorizontal ); n++;
	XtSetArg( arg[n], XtNlength, 100 );                     n++;
	XtSetArg( arg[n], XtNthickness, 30 );                   n++;
	XtSetArg( arg[n], XtNscrollProc, scrollCallbacks );     n++;
	XtSetArg( arg[n], XtNthumbProc, thumbCallbacks );       n++;
	thumbCallbacks[0].closure = (caddr_t)i;
	XtSetArg( arg[n], XtNrelative, True );                  n++;

	scrollbars[i] = XtCreateManagedWidget( "scrollbar",
					       cScrollbarWidgetClass,
					       scrollform, arg, n );
	XtCScrollBarSetThumb( scrollbars[i], 0.5, 0.1 );
    }

    /* Make form to put buttons in */
    n = 0;
    XtSetArg( arg[n], XtNborderWidth, 0 );		n++;
    XtSetArg( arg[n], XtNxResizable, True );		n++;
    XtSetArg( arg[n], XtNyResizable, True );		n++;
    XtSetArg( arg[n], XtNxRefWidget, form );		n++;
    XtSetArg( arg[n], XtNyRefWidget, scrollform );		n++;
    XtSetArg( arg[n], XtNyAddHeight, True );		n++;
    XtSetArg( arg[n], XtNxAttachRight, True );		n++;
    XtSetArg( arg[n], XtNyAttachBottom, True );		n++;
    buttonform = XtCreateManagedWidget( "buttonform", XwformWidgetClass,
					form, arg, n );
    n = 0;
    XtSetArg( arg[n], XtNlabel, machine_type );                 n++;
    XtSetArg( arg[n], XtNxResizable, True );			n++;
    XtSetArg( arg[n], XtNyResizable, True );			n++;
    XtSetArg( arg[n], XtNxOffset, 10 );				n++;
    XtSetArg( arg[n], XtNyOffset, 0 );				n++;
    XtSetArg( arg[n], XtNxAttachOffset, 10 );			n++;
    XtSetArg( arg[n], XtNyAttachOffset, 10 );			n++;
    XtSetArg( arg[n], XtNxVaryOffset, False );			n++;
    XtSetArg( arg[n], XtNyVaryOffset, False );			n++;
    XtSetArg( arg[n], XtNyRefWidget, buttonform );		n++;
    XtSetArg( arg[n], XtNxRefWidget, buttonform );			n++;
    machlabel = XtCreateManagedWidget( "scrollmode", labelWidgetClass,
					buttonform, arg, n );

    n = 0;
    XtSetArg( arg[n], XtNlabel, "Continuous" );                 n++;
    XtSetArg( arg[n], XtNxResizable, True );			n++;
    XtSetArg( arg[n], XtNyResizable, True );			n++;
    XtSetArg( arg[n], XtNxOffset, 10 );				n++;
    XtSetArg( arg[n], XtNyOffset, 0 );				n++;
    XtSetArg( arg[n], XtNxAttachOffset, 10 );			n++;
    XtSetArg( arg[n], XtNyAttachOffset, 10 );			n++;
    XtSetArg( arg[n], XtNxVaryOffset, False );			n++;
    XtSetArg( arg[n], XtNyVaryOffset, False );			n++;
    XtSetArg( arg[n], XtNyRefWidget, buttonform );		n++;
    XtSetArg( arg[n], XtNxRefWidget, machlabel );		n++;
    XtSetArg( arg[n], XtNxAddWidth, True );			n++;
    XtSetArg( arg[n], XtNcallback, modeCallbacks );             n++;
    modebutton = XtCreateManagedWidget( "scrollmode", commandWidgetClass,
					buttonform, arg, n );
    n = 0;
    XtSetArg( arg[n], XtNlabel, "Quit" );                       n++;
    XtSetArg( arg[n], XtNxResizable, True );			n++;
    XtSetArg( arg[n], XtNyResizable, True );			n++;
    XtSetArg( arg[n], XtNxOffset, 10 );				n++;
    XtSetArg( arg[n], XtNyOffset, 0 );				n++;
    XtSetArg( arg[n], XtNxAttachOffset, 10 );			n++;
    XtSetArg( arg[n], XtNyAttachOffset, 10 );			n++;
    XtSetArg( arg[n], XtNxVaryOffset, False );			n++;
    XtSetArg( arg[n], XtNyVaryOffset, False );			n++;
    XtSetArg( arg[n], XtNxRefWidget, modebutton );		n++;
    XtSetArg( arg[n], XtNxAddWidth, True );			n++;
    XtSetArg( arg[n], XtNyRefWidget, buttonform );		n++;
    XtSetArg( arg[n], XtNcallback, quitCallbacks );             n++;
    quitbutton = XtCreateManagedWidget( "quit", commandWidgetClass,
					buttonform, arg, n );

    /* Create slate window */
    slatetop = XtCreateApplicationShell( "PEX", topLevelShellWidgetClass,
					 NULL, 0 );
    n = 0;
    slate = XtCreateManagedWidget( "pexSlate", slateWidgetClass, slatetop,
				   arg, n );
    XtAddCallback( slate, XtNredisplayProc, Redisp, NULL );

    XtRealizeWidget( toplevel );
    XtRealizeWidget( slatetop );

    XtSetArg( arg[0], XtNhighlight, &pexfg );
    XtGetValues( slate, arg, 1 );

    PexFormInit( XtDisplay(slate), XtWindow(slate), argc, argv );

    XtAddTimeOut( TIMEOUT_INTERVAL, Timeout, NULL );

    XtMainLoop();
}
