/* 
 * pexpoingStuff.h - Definitions for things used in pexpoing.
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */
 
#ifndef PEXPOINGSTUFF_H
#define PEXPOINGSTUFF_H

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif


/* Stuff for the score board. */
#define SCORE_TITLE_X 20
#define SCORE_TITLE_Y 20

#define SCORE_X_START 20
#define SCORE_Y_START 50
#define SCORE_Y_OFFSET 15


/* This is the distance (world coords) that the lines drawn to highlight a 
   plane are drawn from the inside of the plane. */
#define HIGHLIGHT_DISTANCE .04

/* Distance (world coords) of the sides of X drawn to show intersections. */
#define X_SIDE_SIZE .08


/* This is how big the ball is. */
#define BALL_RADIUS 0.065

/* This is the distance that the walls are from the origin (a cube with the
   walls this distance in the + and - direction. */
#define BOUNCE_DISTANCE 1.0

#define WALL_DISTANCE (BOUNCE_DISTANCE+BALL_RADIUS)
/* This defines how far from edge of window (in pixels) the walls are 
   to be drawn. */

#define EDGE_DISTANCE 15

/* This is used as a top bound for the velocity. */
/* ***#define VELOCITY_SCALE 0.2 */
#define VELOCITY_SCALE 0.015 

/* Paddle dimensions (in World Coords). */
#define PADDLE_HEIGHT 0.02
#define PADDLE_WIDTH 0.6
#define PADDLE_INSET_DISTANCE 0.1

/* This gets the number of the intersect item for the paddle for player i 
   (there are the six planes for the walls (0 - 5) followed by paddles. */
#define PaddleIntersectItemIndex(i)	(i + 6)
#define IntersectItemPaddleIndex(i)	(i - 6)

/* Paddle numbers in the intersect list. */
#define PADDLE1 6
#define PADDLE2 7
#define PADDLE3 8
#define PADDLE4 9
#define PADDLE5 10
#define PADDLE6 11

/* This defines the number of loops used for 1 time unit (in KillTime). */
#define NUMBER_TIME_LOOPS 150

/* Some simple math functions. */
#define Minimum(i, j)     ((i) < (j) ? (i) : (j))
#define Maximum(i, j)     ((i) > (j) ? (i) : (j))

#define Abs(i)            ((i) < 0 ? (-1 * (i)) : (i))

/* Structures for stuff used in pexpoing. */

typedef struct {
    int x, y, z;
} IntegerCoord3D;

typedef struct {
    int x, y, z;
} IntegerVector3D;
   
/* This is the info for the current state of the ball. */
typedef struct {
    int id;
    pexCoord3D position, previousPosition;
    pexVector3D velocity;
} BallInfo;

/* This is the list of items that can possibly intersect the path
   of the ball as it is bouncing around. */

/* Typedef and values for PlaneKind.  These are the planes for the intersect
   list (all the items are assumed to be planes that are perpendicular to 
   an axis. */
typedef int PlaneKind;

#define XPLANE 1
#define YPLANE 2
#define ZPLANE 3
	    
typedef struct {
    PlaneKind planeKind;
    Bool isPaddle;
    int showBounce;	/* Number of turns to show an intersection mark. */
    pexCoord3D interPt;
    float minX, maxX, minY, maxY, minZ, maxZ;
} IntersectItem;

/* This is the number of iterations to show the echo of a bounce on a plane. */
#define TIMES_TO_SHOW_BOUNCE 4

#endif /* PEXPOINGSTUFF_H */
