/* 
 * polyinfo.h - This is the description of one polyhedron file
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* This is based on the ico X demo program. */

/* polyinfo.h
 * This is the description of one polyhedron file
 */

/* One extra on these for safety. */
#define MAXVERTS 13
	/* icosahedron has 12 vertices */
#define MAXNV MAXVERTS
#define MAXFACES 21
	/* icosahedron has 20 faces */
#define MAXEDGES 31
	/* icosahedron has 30 edges */
#define MAXEDGESPERPOLY 4


/* structure of the include files which define the polyhedra */
typedef struct {
	char *longname;		/* long name of object */
	char *shortname;	/* short name of object */
	char *dual;		/* long name of dual */
	int numverts;		/* number of vertices */
	int numedges;		/* number of edges */
	int numfaces;		/* number of faces */
	pexCoord3D v[MAXVERTS];	/* the vertices */
	int f[MAXEDGES*2+MAXFACES];	/* the faces */
} Polyinfo;

/* end */
