/* 
 * um.c - A simple thing...
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */



#include "um.h"

#define StartCol(txt) 5\
  
#define PutUpText\
    XDrawImageString(dpy, winder, \
		   DefaultGC(dpy, DefaultScreen(dpy)), \
		   StartCol(str1), 10, str1, stringLen(str1));\
  XDrawImageString(dpy, winder, \
		   DefaultGC(dpy, DefaultScreen(dpy)), \
		   StartCol(str2), 25, str2, stringLen(str2));\
  XDrawImageString(dpy, winder, \
		   DefaultGC(dpy, DefaultScreen(dpy)), \
		   StartCol(str3), 40, str3, stringLen(str3));\
  XDrawImageString(dpy, winder, \
		   DefaultGC(dpy, DefaultScreen(dpy)), \
		   StartCol(str4), 55, str4, stringLen(str4));\
  XDrawImageString(dpy, winder, \
		   DefaultGC(dpy, DefaultScreen(dpy)), \
		   StartCol(str5), 70, str5, stringLen(str5));\
  XDrawImageString(dpy, winder, \
		   DefaultGC(dpy, DefaultScreen(dpy)), \
		   StartCol(str6), 85, str6, stringLen(str6));\
  XDrawImageString(dpy, winder, \
		   DefaultGC(dpy, DefaultScreen(dpy)), \
		   StartCol(str7), 100, str7, stringLen(str7));\
  XDrawImageString(dpy, winder, \
		   DefaultGC(dpy, DefaultScreen(dpy)), \
		   StartCol(str8), 115, str8, stringLen(str8));


/*****************************************************************
 * TAG( main )
 * 
 * 	The main driving loop for the xpong routines.
 *
 * Inputs:
 *	[None]
 * Outputs:
 *	[None]
 * Assumptions:
 *	[None]
 * Algorithm:
 *	[None]
 */

  int winx, winy, winw, winh;

main(argc, argv)
int     argc;
char    *argv[];
{ 

  static char str1[] = "      * X3D-PEX *";
  static char str2[] = "    Demonstrated by";
  static char str3[] = "        C I T I";
  static char str4[] = "        at the";
  static char str5[] = " University of Michigan";
  static char str6[] = "  in cooperation with";
  static char str7[] = "Digital   Hewlett-Packard ";
  static char str8[] = "    Sun Microsystems";

  register Window winder;
  register Display *dpy;
  register int scrn;
  char *display;
  XGCValues xgcv;
  Font font;

  display = (char *)getenv("DISPLAY");
  if ( display != NULL )
    {
      if ( !(dpy = XOpenDisplay(display)) )
	{
	  perror("Cannot open display\n");
	  exit(-1);
	}
    
    }
  else
    {
      printf("No DISPLAY variable set.\n");
      exit;
    }

  scrn = DefaultScreen( dpy );

  winder = XCreateSimpleWindow( dpy, DefaultRootWindow( dpy ),
724, 15, 
			       300, 125, 1, BlackPixel( dpy, scrn ),
			       WhitePixel( dpy, scrn ) );

  XSelectInput( dpy, winder, ExposureMask );
  XMapWindow( dpy, winder );
  
  XChangeProperty(dpy, winder, XA_WM_NAME, XA_STRING, 8, 
		  PropModeReplace, " X3D-PEX ", 9);
  XChangeProperty(dpy, winder, XA_WM_ICON_NAME, XA_STRING, 8, 
		  PropModeReplace, " UM NAME ", 9);
  
  XSelectInput(dpy, winder, ExposureMask | StructureNotifyMask );
  
#ifdef USEFONTS
  font = XLoadFont(dpy, "V-20");
  if ( font != NULL )
    {
      xgcv.font = font;
      XChangeGC(dpy, DefaultGC(dpy, scrn), GCFont, &xgcv);
    }
  else
    {
      printf("Can't load font\n");
    }
#endif

  {
    PutUpText
    }
    
  while ( 1 )
    {
      /* Get the next X event (if there is one). */
	{
	  XEvent xEvent;
	  XNextEvent(dpy, &xEvent); 
	  if (xEvent.type == KeyPress)
	    {
	      XKeyPressedEvent *xKeyPressedEventPtr;
	      xKeyPressedEventPtr = (XKeyPressedEvent *) &xEvent;
	    }
	  else if (xEvent.type == ButtonPress)
	    {
	      XButtonPressedEvent *xButtonPressedEventPtr;
	      xButtonPressedEventPtr = (XButtonPressedEvent *) &xEvent;
	    }
	  else if (xEvent.type == Expose)
	    {
	      XExposeEvent *xExposeEventPtr;
	      xExposeEventPtr = (XExposeEvent *) &xEvent;
	      while (xExposeEventPtr->count)
		{
		  XNextEvent(dpy, &xEvent);	    
		  xExposeEventPtr = (XExposeEvent *) &xEvent;
		}
	    }
	  else if (xEvent.type == ConfigureNotify)
	    {
	      XConfigureEvent *xConfigureEventPtr = 
		(XConfigureEvent *)&xEvent;
	      winx = xConfigureEventPtr->x;
	      winy = xConfigureEventPtr->y;
	      winw = xConfigureEventPtr->width;
	      winh = xConfigureEventPtr->height;
	    }
	  else if ( xEvent.type == MotionNotify )
	    {
	      XMotionEvent *xMotionEventPtr = 
		(XMotionEvent *)&xEvent;
	      
	    }
	  else 
	    {
	      /* #####printf("Window %d -- Unknown event type: %d\n",
		 i, xEvent.type);  ##### */
	    }
	  
	  {
	    PutUpText
	    }

	  XFlush(dpy);
 	}
      
    } /* while */
}

stringLen(s)
    char *s;
{
    register int i = 0;
    while ( s[i] != '\0' ) 
	i++;
    return i;
}


