/* 
 * colortable.h - External definition of the Colortable.
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#include "Xproto.h"
#include "pixmapstr.h"

#ifndef COLORTABLE_H
#define COLORTABLE_H


#ifndef EXT
#define EXT extern
#endif

#define MAX_PEX_COLOR 8
#define NUM_PIXMAPS 17
#define NUM_SHADES 32
#define TRUE_COLOR_SHADE  26

/* For your information an xColorItem looks like this!
 * 
 * typedef struct {        
 * 	CARD32 pixel B32;   		        index for the GC man!! 
 *  	CARD16 red B16, green B16, blue B16;    from 0 - 65535!!  
 *  	CARD8 flags;    		        DoRed, DoGreen, DoBlue booleans
 *  	CARD8 pad;
 * } xColorItem;
 */

#define mipexColorTableData(color, shade, data)\
    ((shade) == 0 ? PexColorTable[0].data :\
     PexColorTable[(color)*(NUM_SHADES-1)+(shade)-1].data)
    
#define PexColorTableIndex(color, shade)\
    mipexColorTableData(color, shade, pixel)

#define mipexColorTableRed(color, shade)\
    mipexColorTableData(color, shade, red)

#define mipexColorTableGreen(color, shade)\
    mipexColorTableData(color, shade, green)

#define mipexColorTableBlue(color, shade)\
    mipexColorTableData(color, shade, blue)


EXT xColorItem PexColorTable[MAX_PEX_COLOR*NUM_SHADES];
EXT PixmapPtr PexMonochromePixmaps[NUM_PIXMAPS];

#undef EXT
#endif
