/* 
 * pc.h - definition of the pipeline context structure
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#ifndef PIPECNTXT_H
#define PIPECNTXT_H

#include "PEXprotostr.h"
#include "pubstr.h"


typedef struct _pexPipelineContextStr {
    /*
     * Marker Attributes...
     */
    
    /* Text Attributes... */
    pexColorSpecifier  textColor;

    /* Line and Curve Attributes... */
    pexColorSpecifier  lineColor;
    pexCurveApprox     curveApprox;
    
    /* Surface Attributes... */
    pexEnumTypeIndex   interiorStyle;
    pexColorSpecifier  surfaceColor;
    pexReflectionAttr  reflectionAttr;
    pexEnumTypeIndex   surfaceInterp;
    pexSurfaceApprox   surfaceApprox;
    pexCullMode        cullMode;
    Bool               distinguish;
    Bool               normalFlip;

    /*
     * Surface Edge Attributes...
     */
    
    /* Geometry Attributes... */
    pexMatrix          localTransform;
    pexMatrix          globalTransform;
    CARD16             viewIndex;

    /* Color Transformation Attributes... */
    pexBitmask         lightState;

    /*
     * ASF Attributes...
     * Miscellaneous Attributes...
     */

    /*
     * pipeline context chain:
     */
    pexPipelineContextPtr OldPC;
} ;

#endif /* PIPECNTXT_H */
