/* 
 * pexmath.h - simple vector junk.  #defines
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/*****************************************************************
 * TAG( PexVectorCrossProduct )
 * 
 *  cross product of two vectors
 * Inputs:
 * 	*pexVector3D v1
 * 	*pexVector3D v2
 * 	*pexVector3D v3
 * Outputs:
 * 	cross product is returned in the third vector parameter
 * Assumptions:
 *	[None]
 * Algorithm:
 *	[None]
 */


#define PexVectorCrossProduct( v1, v2, v3 )\
    (v3).x = ((v1).y * (v2).z) - ((v1).z * (v2).y);\
    (v3).y = ((v1).z * (v2).x) - ((v1).x * (v2).z);\
    (v3).z = ((v1).x * (v2).y) - ((v1).y * (v2).x);

/*****************************************************************
 * TAG( PexFacetCullingVectorCrossProduct )
 * 
 * z value cross product of two vectors
 * Inputs:
 * 	*pexVector3D v1
 * 	*pexVector3D v2
 * 	*pexVector3D v3
 * Outputs:
 * 	cross product is returned in the third vector parameter
 * Assumptions:
 *	[None]
 * Algorithm:
 *	[None]
 */


#define PexFacetCullingVectorCrossProduct( v1, v2, v3 )\
    (v3).z = ((v1).x * (v2).y) - ((v1).y * (v2).x);

/*****************************************************************
 * TAG( PexVectorDotProduct )
 * 
 *  
 * Inputs:
 * 	pexVector3D
 * 	pexVector3D
 * Outputs:
 * 	retruns value of dot product
 * Assumptions:
 *	[None]
 * Algorithm:
 *	[None]
 */

#define PexVectorDotProduct(v1, v2)\
    (FLOAT) ( (v1).x * (v2).x + (v1).y * (v2).y + (v1).z * (v2).z );

/*****************************************************************
 * TAG( PexClipPoint )
 * 
 * Returns boolean if perspective point needs to be clipped.
 * Inputs:
 * 	4D Point (pexCoord4D).
 * Outputs:
 * 	Boolean TRUE if point needs clipping.
 * Assumptions:
 *	[None]
 * Algorithm:
 *	[None]
 */
#define PexClipPoint(pt) ((pt.y >  pt.w) | (pt.y < -pt.w)  << 1 | \
    (pt.x >  pt.w)  << 2 | (pt.x < -pt.w)  << 3 | (pt.z >  pt.w)  << 4 | \
    (pt.z < 0.0) << 5)
