/* 
 * renderer.h - render attribute definition
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#ifndef PEXRENDER_H
#define PEXRENDER_H

#include "gcstruct.h"
#include "PEXproto.h"
#include "pexmisc.h"
#include "pc.h"
#include "pixmap.h"
#include "pubstr.h"

#define NUM_VIEWS 10
#define NUM_LIGHT_SOURCES 2
#define NumColors 10

    
struct _pexRendererStr {
    pexRenderer        rID;
    pexPC              pcID;
    pexPipelineContextPtr     pPC;
    /*
     * we don't care about this since none of our clients will ever request it.
     * LISTofELEMENT_REF    currentPath;
     */
    CARD32             rendererState;
    /*
     * stuff not implemented right now:
     * pexLookupTable     *markerBundle;
     * pexLookupTable     *textBundle;
     * pexLookupTable     *lineBundle;
     * pexLookupTable     *interiorBundle;
     * pexLookupTable     *edgeBundle;
     */
    pexViewEntry       viewTable[NUM_VIEWS];
    pexMatrix	       clipMatrix[NUM_VIEWS];
    pexRgbFloatColor   colorTable[NumColors];
    pexLookupTable     depthCueTable;
    pexLightEntry      lightTable[NUM_LIGHT_SOURCES];
    pexLookupTable     colorApproxTable;
    pexLookupTable     patternTable;
    /*
     * stuff not implemented right now:
     * pexLookupTable     textFontTable;
     * pexNameSet         highlightInclusion;
     * pexNameSet         highlightExclusion;
     * pexNameSet         invisibilityInclusion;
     * pexNameSet         invisibilityExclusion;
     */
    CARD32             HLHSRMode;
    pexNpcSubvolume    npcSubvolume;
    pexViewport        viewport;
    /*
     * The following was once known as a RenderDrawable:
     */
    Drawable           drawID;
    DrawablePtr        pDraw;
    GCPtr              pGC;
    CARD32             deviceDep;
    /* what follows is our procedure vector */
    FUNCTION	       *Polygon3D;
    FUNCTION           *Polygon2DFlat;
    FUNCTION	       *Polygon2DSmoothh;
    FUNCTION           *Polyline3D;
    FUNCTION	       *Polyline2D;
    FUNCTION	       *Polyline2DZ;
    FUNCTION	       *AnnotationText3D;
    FUNCTION	       *AnnotationText2D;
    FUNCTION	       *QuadMesh3D;
    FUNCTION	       *QuadMesh2DFlat;
    FUNCTION	       *QuadMesh2DSmooth;
    FUNCTION	       *NurbSurface;
    FUNCTION           *NurbCurve;
    FUNCTION           *Pixel8;
    FUNCTION           *PixelZ8;
    FUNCTION           *PixelZRGB;
    FUNCTION           *BeginStructure;
    FUNCTION           *EndStructure;
    FUNCTION           *LocalTransform3D;
    FUNCTION           *GlobalTransform3D;
    FUNCTION	       *BeginRenderOutput;
    FUNCTION	       *EndRenderOutput;
} ;

#endif /* PEXRENDER_H */
