/* 
 * validate.c - machine independant function to validate a renderer
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */
/*****************************************************************
 * TAG( DDPEXValidate )
 * 
 * Takes a pointer to a renderer and fills in the procedure vector.
 * Also gets a GC and validates it as well.
 * 
 * Inputs:
 * 	a pointer to a renderer to be validated
 * Outputs:
 * 	the renderer pointed to by the input ptr is validated.
 * Assumptions:
 * 	...
 * Algorithm:
 * 	...
 */

#include "pubstr.h"
#include "renderer.h"
#include "pexmisc.h"

void
DDPEXValidate(pRend, rChanges, pChanges)
    register pexRendererPtr pRend;
    register CARD32 rChanges, pChanges[2];
{
    miPexValidate (pRend, rChanges, pChanges);
};
