/* 
 * extension.c - extension init code.
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#include <stdio.h>
#include "X.h"
#include "PEX.h"
/* #include "Xproto.h" */
#include "PEXproto.h"
#include "misc.h"
#include "os.h"
#include "pixmapstr.h"
#include "gcstruct.h"  /* should be able to get GCInterestRec without GC */
#include "extnsionst.h"
#include "dixstruct.h"
#include "resource.h"
#include "opaque.h"
#include "windowstr.h"
#include "miscstruct.h"
#include "regionstr.h"

#define PEXEXT
#include "pexextensn.h"
#undef PEXEXT


PexExtensionInit()
{
	ExtensionEntry *AddExtension();
	int ProcPEXDispatch(), sProcPEXDispatch();
	void PEXSwapReplyProc(), PEXResetProc();
	unsigned short CreateNewResourceType();
	short CreateNewResourceClass();

	PexExtensionEntry = AddExtension(PEXNAME, 0, MaxPEXError+1, ProcPEXDispatch,
					 sProcPEXDispatch,
					 PEXSwapReplyProc,
					 PEXResetProc);

	if (PexExtensionEntry)
	{
	    PexReqCode = PexExtensionEntry->base;
	    (void)MakeAtom(PEXNAME, strlen(PEXNAME), TRUE);
	    PexType        = CreateNewResourceType();
	    /*	PexLutClass    = CreateNewResourceClass(); */
	    PexPipeClass   = CreateNewResourceClass();
	    PexRendClass   = CreateNewResourceClass();
	    /*	PexStructClass = CreateNewResourceClass(); */
	    /*	PexEditClass   = CreateNewResourceClass(); */
	    /*	PexNameClass   = CreateNewResourceClass(); */
	    /*	PexSearchClass = CreateNewResourceClass(); */
	    /*	PexWksClass    = CreateNewResourceClass(); */
	} 
	else
	{
	    FatalError("PexExtensionInit: AddExtensions failed\n");
	}
	DDPEXInitGraphics();
	
	PexInitGraphicsHowever = TRUE;
}




/*
 * I'm not really sure what the hell this next stuff is for.
 */
void PEXSwapReplyProc()
{
}

void PEXResetProc()
{
}

void PexFreeState()
{
}

void PexDeleteState()
{
}
