/* 
 * renderreq.c - functions to handle renderer requests
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */
#include <stdio.h>
#include <X.h>
#include <PEX.h>
#include <PEXproto.h>
#include <pixmap.h>
#include <window.h>
#include <renderer.h>
#include <pubstr.h>
#include <pexextensn.h>
#include <resource.h>

/* all of the below came from sample/src/pexExt.c */

#include "pixmapstr.h"
#include "gcstruct.h"  /* should be able to get GCInterestRec without GC */
#include "extnsionst.h"
#include "dixstruct.h"
#include "opaque.h"
#include "windowstr.h"
#include "miscstruct.h"
#include "regionstr.h"
#include "scrnintstr.h"


#define CREATE_REND 1
#define CHANGE_REND 0
#define SWAP_FILE "renderreq.ci"
#include "scgen.ci"
#undef SWAP_FILE
#undef CREATE_REND
#undef CHANGE_REND

/*
 * These two routines belong here, not in EndRend.ci, which is where
 * they were before. Having them here prevents them from being
 * multiply defined (since a .ci file can be included up to 4 times).
 */

/*****************************************************************
 * TAG( pexEndRenderingID )
 * 
 * This is a sub-layer of PexEndRenderingHandler. This can be called
 * by the PexBeginRenderingHandler, in the event that an
 * implicit End Rendering needs to be done. The difference is that
 * this function takes merely the renderer id as a parameter, whereas
 * PexEndRenderingHandler takes an entire packet.
 * 
 * Inputs:
 * 	a renderer id.
 * Outputs:
 * 	an integer error code or zero.
 * Assumptions:
 * 	...
 * Algorithm:
 * 	...
 */

int
pexEndRenderingID(rID)
    pexRenderer rID;
{
    pexRendererPtr pRend;

    pRend = (pexRendererPtr) LookupID (rID, PexType, PexRendClass);

    if (!pRend)
	return (RendererError);
    
    /*
     * unlock the renderer and drawable: pRend (a ptr), and 
     * pRend -> drawable (an ID), respetively.
     */
    
    pRend -> rendererState = Idle;

    DDPEXEndRendering(pRend);
    DoPexEndStructure (pRend);

    return(Success);
}


/*****************************************************************
 * TAG( pexEndRenderingVAL )
 * 
 * Same as the above function, but takes a pointer to the renderer
 * as a ptr, not a renderer ID.
 * 
 * Inputs:
 * 	a pointer to a renderer.
 * Outputs:
 * 	an integer error code or zero.
 * Assumptions:
 * 	...
 * Algorithm:
 * 	...
 */

int
pexEndRenderingVAL(pRend)
    pexRendererPtr pRend;
{
    if (!pRend)
	return (RendererError);
    
    /*
     * unlock the renderer and drawable: pRend (a ptr), and
     * pRend -> drawable (an ID), respetively.
     */


    pRend -> rendererState = Idle;

    DDPEXEndRendering(pRend);
    DoPexEndStructure (pRend);

    return(Success);
}

