/* 
 * structreq.c - Handles begin/end structure requests
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#include <stdio.h>

#include "PEXproto.h"
#include "pexextensn.h"
#include "pubstr.h"
#include "renderer.h"

#define SWAP_FILE "structreq.ci"
#include "sgen.ci"
#undef SWAP_FILE


/*****************************************************************
 * TAG( DoPexBeginStructure )
 * 
 * Sub layer of the begin structure request, callable by both
 * PexBeginStructureHandler and PexBeginRenderingHandler.
 * 
 * Inputs:
 * 	a swapped renderer id;
 * 	an sid
 * Outputs:
 * 	refer to PexBeginStructureHandler
 * Assumptions:
 *	[None]
 * Algorithm:
 *	[None]
 */

int
DoPexBeginStructure (pRend, sID)
    pexRendererPtr pRend;
    CARD32 sID;
{
    pexPipelineContextPtr pPC;
    pexMatrix tempMat;
    extern pexPipelineContextPtr CopyPexPC ();

    if (!pRend)
	return (RendererError);
    if (!(pPC = pRend->pPC))
	return (RendererError);

    /*
     * push the pipeline context stack, placing a copy on top.
     */
    if ( !( pRend->pPC = CopyPexPC (pPC) ) )
	return (BadRequest);
    pRend->pPC->OldPC = pPC;
    pPC = pRend->pPC;

    /*
     * The new globalTransform matrix is the old localTransform concatenated with the old
     * glbTrans. The new localTransform is the identity.
     */
    multm44 (pPC->localTransform, pPC->globalTransform, tempMat);
    bcopy (tempMat, (pPC->globalTransform), sizeof (pexMatrix));

    identm44 (pPC->localTransform);

    /*
     * dd stuff.
     */
    (void)(pRend->BeginStructure(pRend, sID));


    return (Success);
}


/*****************************************************************
 * TAG( DoPexEndStructure )
 * 
 * Sub layer of the End Structure request, callable by both
 * PexEndStructureHandler and PexEndRenderingHandler.
 * 
 * Inputs:
 * 	a swapped renderer id
 * Outputs:
 * 	refer to PexEndStructureHandler
 * Assumptions:
 *	[None]
 * Algorithm:
 *	[None]
 */

int
DoPexEndStructure (pRend)
    pexRendererPtr pRend;
{
    pexPipelineContextPtr pPC;

    if (!pRend)
	return (RendererError);
    if (!(pPC = pRend->pPC))
	return (RendererError);

    /*
     * pop the pc stack and xfree the old pc.
     */
    if (!(pRend->pPC = pPC->OldPC))
    {
	fprintf (stderr, "Serious internal error in PexEndStructureHandler:\nCannot pop pipeline stack.\n");
	pRend->pPC = pPC;
	return (1);
    }
    else
	Xfree (pPC);
    
    /*
     * dd stuff.
     */
    (void)(pRend->EndStructure(pRend));


    return (Success);
}
