/* 
 * Polyline.c - Unpack routine for a swapped polyline request packet.
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#include "PEX.h"
#include "swapmacros.h"
#include "polyline.h"


#define ExtraSpace(n)\
    (sizeof(pexCoord3D) * n)

pexPolylinePtr
NewPexPolyline(nPoints)
    CARD32 nPoints;		

{
    pexPolylinePtr NewPoly;

    /* printf("NewPolygon %d points, ", nPoints); */

    NewPoly = (pexPolylinePtr)xalloc(sizeof(pexPolylineRec) +
					(ExtraSpace(nPoints)));

    /* printf("%d + %d = %d bytes allocated at %x", sizeof(pexPolylineRec),
       ExtraSpace(nPoints),
       sizeof(pexPolylineRec) + ExtraSpace(nPoints),
       NewPoly);
       */   

    NewPoly->head.length = (sizeof(pexPolylineRec) +
			    (ExtraSpace(nPoints)) ) >> 2;
    NewPoly->head.elementType = OCPolyline;
    return (NewPoly);
};

#define SWAP_FILE "polyline.ci"
#include "scgen.ci"
#undef SWAP_FILE

/*****************************************************************
 * TAG( FreePexPolyline ErrorCheckPexPolyline )
 * 
 * Inputs:
 *	pexPolylinePtr
 * Outputs:
 *	ErrorChecker:
 *		true - Error exists.
 *		false- No error detected.
 *	       
 * Assumptions:
 *	Polyline is byteSwapped properly.
 * Algorithm:
 *	[None]
 */

void
FreePexPolyline(Poly)
    pexPolylinePtr Poly;
{
    xfree(Poly);
};


Bool
ErrorCheckPexPolyline(Poly)
    pexPolylinePtr Poly;
{
    CARD32 VariablePartLength = (Poly->head.length -
				 (sizeof(pexPolylineRec)>>2)) * 4;
    CARD32 nPoints = (CARD32)VariablePartLength/sizeof(pexCoord3D);

    /* Check that Variable Part Length is divisable by sizeof(pexCoord3D) */

    if (nPoints * sizeof(pexCoord3D) != VariablePartLength)
	return TRUE;
    return FALSE;
};
