#ifndef lint
static char rcsid[] = "$Header: CScroll.c,v 1.29 88/02/26 12:14:36 swick Exp $";
#endif lint

/***********************************************************
Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/* CScrollBar.c */
/* created by weissman, Mon Jul  7 13:20:03 1986 */
/* converted by swick, Thu Aug 27 1987 */
/* converted by SW Thomas to Centered scrollbar Wed Apr 27 1988 */

#define XtStrlen(s)		((s) ? strlen(s) : 0)

#include <X11/Xos.h>
#include <X11/IntrinsicP.h>
#include <X11/Xresource.h>
#include <X11/StringDefs.h>
#include "CScrollP.h"

/* Private definitions. */

static char defaultTranslations[] =
    "<Btn1Down>:   StartScroll(Forward) \n\
     <Btn2Down>:   StartScroll(Continuous) MoveThumb() NotifyThumb(First) \n\
     <Btn3Down>:   StartScroll(Backward) \n\
     <Btn2Motion>: MoveThumb() NotifyThumb() \n\
     <BtnUp>:      NotifyScroll(Proportional) EndScroll()";

#ifdef bogusScrollKeys
    /* examples */
    "<KeyPress>f:  StartScroll(Forward) NotifyScroll(FullLength) EndScroll()"
    "<KeyPress>b:  StartScroll(Backward) NotifyScroll(FullLength) EndScroll()"
#endif

static float floatZero = 0.0;
static int DEFAULTVALUE = ~0;
static Boolean FalseValue = False;

#define Offset(field) XtOffset(CScrollbarWidget, field)

static XtResource resources[] = {
  {XtNwidth, XtCWidth, XtRInt, sizeof(int),
	     Offset(core.width), XtRInt, (caddr_t)&DEFAULTVALUE},
  {XtNheight, XtCHeight, XtRInt, sizeof(int),
	     Offset(core.height), XtRInt, (caddr_t)&DEFAULTVALUE},
  {XtNlength, XtCLength, XtRInt, sizeof(int),
	     Offset(c_scrollbar.length), XtRString, "1"},
  {XtNthickness, XtCThickness, XtRInt, sizeof(int),
	     Offset(c_scrollbar.thickness), XtRString, "14"},
  {XtNorientation, XtCOrientation, XtROrientation, sizeof(XtOrientation),
	     Offset(c_scrollbar.orientation), XtRString, "vertical"},
  {XtNscrollProc, XtCCallback, XtRCallback, sizeof(caddr_t),
	     Offset(c_scrollbar.scrollProc), XtRCallback, NULL},
  {XtNthumbProc, XtCCallback, XtRCallback, sizeof(caddr_t),
	     Offset(c_scrollbar.thumbProc), XtRCallback, NULL},
  {XtNthumb, XtCThumb, XtRPixmap, sizeof(Pixmap),
	     Offset(c_scrollbar.thumb), XtRPixmap, NULL},
  {XtNforeground, XtCForeground, XtRPixel, sizeof(Pixel),
	     Offset(c_scrollbar.foreground), XtRString, "black"},
  {XtNrecenter, XtCRecenter, XtRBoolean, sizeof(Boolean),
       	     Offset(c_scrollbar.recenter), XtRBoolean, (caddr_t)&FalseValue},
  {XtNrelative, XtCRelative, XtRBoolean, sizeof(Boolean),
       	     Offset(c_scrollbar.relative), XtRBoolean, (caddr_t)&FalseValue},
  {XtNdiscrete, XtCDiscrete, XtRBoolean, sizeof(Boolean),
       	     Offset(c_scrollbar.discrete), XtRBoolean, (caddr_t)&FalseValue},
  {XtNshown, XtCShown, XtRFloat, sizeof(float),
	     Offset(c_scrollbar.shown), XtRFloat, (caddr_t)&floatZero},
  {XtNtop, XtCTop, XtRFloat, sizeof(float),
	     Offset(c_scrollbar.top), XtRFloat, (caddr_t)&floatZero},
  {XtNscrollVCursor, XtCScrollVCursor, XtRCursor, sizeof(Cursor),
	     Offset(c_scrollbar.verCursor), XtRString, "sb_v_double_arrow"},
  {XtNscrollHCursor, XtCScrollHCursor, XtRCursor, sizeof(Cursor),
	     Offset(c_scrollbar.horCursor), XtRString, "sb_h_double_arrow"},
  {XtNscrollUCursor, XtCScrollUCursor, XtRCursor, sizeof(Cursor),
	     Offset(c_scrollbar.upCursor), XtRString, "sb_up_arrow"},
  {XtNscrollDCursor, XtCScrollDCursor, XtRCursor, sizeof(Cursor),
	     Offset(c_scrollbar.downCursor), XtRString, "sb_down_arrow"},
  {XtNscrollLCursor, XtCScrollLCursor, XtRCursor, sizeof(Cursor),
	     Offset(c_scrollbar.leftCursor), XtRString, "sb_left_arrow"},
  {XtNscrollRCursor, XtCScrollRCursor, XtRCursor, sizeof(Cursor),
	     Offset(c_scrollbar.rightCursor), XtRString, "sb_right_arrow"},
  {XtNfont,  XtCFont, XtRFontStruct, sizeof(XFontStruct *),
       	     Offset(c_scrollbar.font),XtRString, "Fixed"},
  {XtNlabel, XtCLabel, XtRString, sizeof(String),
       	     Offset(c_scrollbar.label), XtRString, NULL},
};

static void ClassInitialize();
static void Initialize();
static void Realize();
static void Resize();
static void Redisplay();
static Boolean SetValues();

static void StartScroll();
static void MoveThumb();
static void NotifyThumb();
static void NotifyScroll();
static void EndScroll();

static XtActionsRec actions[] = {
	{"StartScroll",		StartScroll},
	{"MoveThumb",		MoveThumb},
	{"NotifyThumb",		NotifyThumb},
	{"NotifyScroll",	NotifyScroll},
	{"EndScroll",		EndScroll},
	{NULL,NULL}
};


static CScrollbarClassRec cScrollbarClassRec = {
/* core fields */
    /* superclass       */      (WidgetClass) &widgetClassRec,
    /* class_name       */      "CScrollbar",
    /* size             */      sizeof(CScrollbarRec),
    /* class_initialize	*/	ClassInitialize,
    /* class_part_init  */	NULL,
    /* class_inited	*/	FALSE,
    /* initialize       */      Initialize,
    /* initialize_hook  */	NULL,
    /* realize          */      Realize,
    /* actions          */      actions,
    /* num_actions	*/	XtNumber(actions),
    /* resources        */      resources,
    /* num_resources    */      XtNumber(resources),
    /* xrm_class        */      NULLQUARK,
    /* compress_motion	*/	TRUE,
    /* compress_exposure*/	TRUE,
    /* compress_enterleave*/	TRUE,
    /* visible_interest */      FALSE,
    /* destroy          */      NULL,
    /* resize           */      Resize,
    /* expose           */      Redisplay,
    /* set_values       */      SetValues,
    /* set_values_hook  */	NULL,
    /* set_values_almost */	XtInheritSetValuesAlmost,
    /* get_values_hook  */	NULL,
    /* accept_focus     */      NULL,
    /* version          */	XtVersion,
    /* callback_private */      NULL,
    /* tm_table         */      defaultTranslations,
    /* query_geometry	*/	NULL,
};

WidgetClass cScrollbarWidgetClass = (WidgetClass)&cScrollbarClassRec;

#define MINBARHEIGHT	7     /* How many pixels of scrollbar to always show */
#define NoButton -1
#define PICKLENGTH(widget, x, y) \
    ((widget->c_scrollbar.orientation == XtorientHorizontal) ? x : y)
#define MIN(x,y)	((x) < (y) ? (x) : (y))
#define MAX(x,y)	((x) > (y) ? (x) : (y))


/* Orientation enumeration constants */

static	XrmQuark  XtQEhorizontal;
static	XrmQuark  XtQEvertical;

/*ARGSUSED*/
#define	done(address, type) \
	{ (*toVal).size = sizeof(type); (*toVal).addr = (caddr_t) address; }

extern void LowerCase();

/* ARGSUSED */
static void CvtStringToOrientation(args, num_args, fromVal, toVal)
    XrmValuePtr *args;		/* unused */
    Cardinal	*num_args;	/* unused */
    XrmValuePtr	fromVal;
    XrmValuePtr	toVal;
{
    static XtOrientation orient;
    XrmQuark	q;
    char	lowerName[1000];

/* ||| where to put LowerCase */
    LowerCase((char *) fromVal->addr, lowerName);
    q = XrmStringToQuark(lowerName);
    if (q == XtQEhorizontal) {
    	orient = XtorientHorizontal;
	done(&orient, XtOrientation);
	return;
    }
    if (q == XtQEvertical) {
    	orient = XtorientVertical;
	done(&orient, XtOrientation);
	return;
    }
};


static void ClassInitialize()
{
    XtQEhorizontal = XrmStringToQuark(XtEhorizontal);
    XtQEvertical   = XrmStringToQuark(XtEvertical);
    XtAddConverter( XtRString, XtROrientation, CvtStringToOrientation,
		    NULL, (Cardinal)0 );
}



/*
 * Make sure the first number is within the range specified by the other
 * two numbers.
 */

static int InRange(num, small, big)
int num, small, big;
{
    return (num < small) ? small : ((num > big) ? big : num);
}

/*
 * Same as above, but for floating numbers. 
 */

static float FloatInRange(num, small, big)
float num, small, big;
{
    return (num < small) ? small : ((num > big) ? big : num);
}


/* Fill the area specified by top and bottom with the given pattern. */
static float FractionLoc(w, x, y)
  CScrollbarWidget w;
  int x, y;
{
    float   result;

    result = PICKLENGTH(w, (float) x/w->core.width,
			(float) y/w->core.height);
    return FloatInRange(result, 0.0, 1.0);
}


static FillArea(w, top, bottom, thumb)
  CScrollbarWidget w;
  Position top, bottom;
  int thumb;
{
    Dimension length = bottom-top;

    switch(thumb) {
	/* Fill the new Thumb location */
      case 1:
	if (w->c_scrollbar.orientation == XtorientHorizontal) 
	    XFillRectangle(XtDisplay(w), XtWindow(w),
			   w->c_scrollbar.gc, top, 1, length,
			   w->core.height-2);
	
	else XFillRectangle(XtDisplay(w), XtWindow(w), w->c_scrollbar.gc,
			    1, top, w->core.width-2, length);

	break;
	/* Clear the old Thumb location */
      case 0:
	if (w->c_scrollbar.orientation == XtorientHorizontal) 
	    XClearArea(XtDisplay(w), XtWindow(w), top, 1,
		       length, w->core.height-2, FALSE);
	
	else XClearArea(XtDisplay(w), XtWindow(w), 1,
			top, w->core.width-2, length, FALSE);

    }  
}


/* Paint the thumb in the area specified by w->top and
   w->shown.  The old area is erased.  The painting and
   erasing is done cleverly so that no flickering will occur. */

static void PaintThumb( w )
  CScrollbarWidget w;
{
    int oldloc, oldtop, oldbot, newloc, newtop, newbot;

    oldloc = w->c_scrollbar.centerLoc;
    oldtop = w->c_scrollbar.topLoc;
    oldbot = oldtop + w->c_scrollbar.shownLength;
    newloc = w->c_scrollbar.length * w->c_scrollbar.top;
    newtop = newloc - (int)(w->c_scrollbar.length * w->c_scrollbar.shown / 2);
    newbot = newtop + (int)(w->c_scrollbar.length * w->c_scrollbar.shown);
    if (newbot < newtop + MINBARHEIGHT)
    {
	newtop = newloc - MINBARHEIGHT/2;
	newbot = newtop + MINBARHEIGHT;
    }
    w->c_scrollbar.centerLoc = newloc;
    w->c_scrollbar.topLoc = newtop;
    w->c_scrollbar.shownLength = newbot - newtop;

    if (XtIsRealized((Widget)w)) {
	if ( (oldloc >= newtop) && (oldloc <= newbot) )
	    FillArea(w, oldloc, oldloc+1, 1);
	if (newtop < oldtop) FillArea(w, newtop, MIN(newbot, oldtop), 1);
	if (newtop > oldtop) FillArea(w, oldtop, MIN(newtop, oldbot), 0);
	if (newbot < oldbot) FillArea(w, MAX(newbot, oldtop), oldbot, 0);
	if (newbot > oldbot) FillArea(w, MAX(newtop, oldbot), newbot, 1);
	FillArea(w, newloc, newloc+1, 0);

	if ( w->c_scrollbar.label )
	    XDrawString( XtDisplay(w), XtWindow(w),
			 w->c_scrollbar.lgc,
			 2, 2 + w->c_scrollbar.font->max_bounds.ascent,
			 w->c_scrollbar.label,
			 w->c_scrollbar.label_len );
    }
}


static void SetDimensions(w)
    CScrollbarWidget w;
{
    if (w->c_scrollbar.orientation == XtorientVertical) {
	w->c_scrollbar.length = w->core.height;
	w->c_scrollbar.thickness = w->core.width;
    }
    else {
	w->c_scrollbar.length = w->core.width;
	w->c_scrollbar.thickness = w->core.height;
    }
}


/* ARGSUSED */
static void Initialize( request, new )
   Widget request;		/* what the client asked for */
   Widget new;			/* what we're going to give him */
{
    CScrollbarWidget w = (CScrollbarWidget) new;
    XGCValues gcValues;

    if (w->c_scrollbar.thumb == NULL) {
        w->c_scrollbar.thumb = XtGrayPixmap( XtScreen(w) );
    }

    if ( w->c_scrollbar.label != NULL )
    {
	w->c_scrollbar.label_len = XtStrlen(w->c_scrollbar.label);
	w->c_scrollbar.label = strcpy( XtMalloc(w->c_scrollbar.label_len + 1),
				       w->c_scrollbar.label );
    }

    gcValues.foreground = w->c_scrollbar.foreground;
    gcValues.fill_style = FillTiled;
    gcValues.tile = w->c_scrollbar.thumb;
    gcValues.font = w->c_scrollbar.font->fid;
    w->c_scrollbar.gc = XtGetGC( new,
			       GCForeground | GCFillStyle | GCTile,
			       &gcValues);
    w->c_scrollbar.lgc = XtGetGC( new, GCForeground | GCFont,
				  &gcValues);


    if (w->core.width == DEFAULTVALUE)
	w->core.width = (w->c_scrollbar.orientation == XtorientVertical)
	    ? w->c_scrollbar.thickness : w->c_scrollbar.length;

    if (w->core.height == DEFAULTVALUE)
	w->core.height = (w->c_scrollbar.orientation == XtorientHorizontal)
	    ? w->c_scrollbar.thickness : w->c_scrollbar.length;

    SetDimensions( w );
    w->c_scrollbar.direction = 0;
    w->c_scrollbar.topLoc = 0;
    w->c_scrollbar.shownLength = 0;
    if ( w->c_scrollbar.recenter )
	w->c_scrollbar.top = 0.5;
}

static void Realize( gw, valueMask, attributes )
   Widget gw;
   Mask *valueMask;
   XSetWindowAttributes *attributes;
{
    CScrollbarWidget w = (CScrollbarWidget) gw;

    w->c_scrollbar.inactiveCursor =
      (w->c_scrollbar.orientation == XtorientVertical)
	? w->c_scrollbar.verCursor
	: w->c_scrollbar.horCursor;

    attributes->cursor = w->c_scrollbar.inactiveCursor;
    *valueMask |= CWCursor;
    
    XtCreateWindow( gw, InputOutput, (Visual *)CopyFromParent,
		    *valueMask, attributes );
}


/* ARGSUSED */
static Boolean SetValues( current, request, desired )
   Widget current,		/* what I am */
          request,		/* what he wants me to be */
          desired;		/* what I will become */
{
    CScrollbarWidget w = (CScrollbarWidget) current;
    CScrollbarWidget rw = (CScrollbarWidget) request;
    CScrollbarWidget dw = (CScrollbarWidget) desired;
    Boolean redraw = FALSE;

    if ( w->c_scrollbar.label != dw->c_scrollbar.label )
	XtFree( (char *)w->c_scrollbar.label );
    if ( dw->c_scrollbar.label != NULL )
    {
	dw->c_scrollbar.label_len = XtStrlen(dw->c_scrollbar.label);
	dw->c_scrollbar.label = strcpy( XtMalloc(dw->c_scrollbar.label_len+1),
					dw->c_scrollbar.label );
	redraw = TRUE;
    }
	

    if (w->c_scrollbar.foreground != rw->c_scrollbar.foreground ||
	w->core.background_pixel != rw->core.background_pixel)
        redraw = TRUE;

    if (dw->c_scrollbar.recenter != w->c_scrollbar.recenter)
	if(dw->c_scrollbar.recenter)
	    dw->c_scrollbar.top = 0.5;

    if (dw->c_scrollbar.top < 0.0 || dw->c_scrollbar.top > 1.0)
        dw->c_scrollbar.top = w->c_scrollbar.top;

    if (dw->c_scrollbar.shown < 0.0 || dw->c_scrollbar.shown > 1.0)
        dw->c_scrollbar.shown = w->c_scrollbar.shown;

    if (w->c_scrollbar.top != dw->c_scrollbar.top ||
        w->c_scrollbar.shown != dw->c_scrollbar.shown)
	redraw = TRUE;

    if (w->c_scrollbar.font != dw->c_scrollbar.font)
	redraw = TRUE;

    /* Properly handle change to inactive cursor */
    if (w->c_scrollbar.verCursor != dw->c_scrollbar.verCursor ||
	w->c_scrollbar.horCursor != dw->c_scrollbar.horCursor ||
	w->c_scrollbar.orientation != dw->c_scrollbar.orientation)
    {
	dw->c_scrollbar.inactiveCursor =
	    (dw->c_scrollbar.orientation == XtorientVertical)
		? dw->c_scrollbar.verCursor
		    : dw->c_scrollbar.horCursor;
	/* If currently inactive, change cursor */
	if (dw->c_scrollbar.direction == 0)
	    XDefineCursor(XtDisplay(dw), XtWindow(dw),
			  dw->c_scrollbar.inactiveCursor);
    }
    /* Ignore changes to active cursor during scrolling. */

    return( redraw );
}

/* ARGSUSED */
static void Resize( gw )
   Widget gw;
{
    /* ForgetGravity has taken care of background, but thumb may
     * have to move as a result of the new size. */
    SetDimensions( (CScrollbarWidget)gw );
    Redisplay( gw, (XEvent*)NULL );
}


/* ARGSUSED */
static void Redisplay( gw, event, region )
   Widget gw;
   XEvent *event;		/* unused, NULL if called from Resize() */
   Region region;		/* unused, NULL if called from Resize() */
{
    CScrollbarWidget w = (CScrollbarWidget) gw;

    w->c_scrollbar.topLoc = -1000; /* Forces entire thumb to be painted. */
    PaintThumb( w ); 
}


/* ARGSUSED */
static void StartScroll( gw, event, params, num_params )
  Widget gw;
  XEvent *event;
  String *params;		/* direction: Back|Forward|Smooth */
  Cardinal *num_params;		/* we only support 1 */
{
    CScrollbarWidget w = (CScrollbarWidget) gw;
    Cursor cursor;
    char direction;

    if (w->c_scrollbar.direction != 0) return; /* if we're already scrolling */
    if (*num_params > 0) direction = *params[0];
    else		 direction = 'C';

    w->c_scrollbar.direction = direction;

    switch( direction ) {
	case 'B':
	case 'b':	cursor = (w->c_scrollbar.orientation == XtorientVertical)
				   ? w->c_scrollbar.downCursor
				   : w->c_scrollbar.rightCursor; break;

	case 'F':
	case 'f':	cursor = (w->c_scrollbar.orientation == XtorientVertical)
				   ? w->c_scrollbar.upCursor
				   : w->c_scrollbar.leftCursor; break;

	case 'C':
	case 'c':	cursor = (w->c_scrollbar.orientation == XtorientVertical)
				   ? w->c_scrollbar.rightCursor
				   : w->c_scrollbar.upCursor; break;

	default:	return; /* invalid invocation */
    }

    XDefineCursor(XtDisplay(w), XtWindow(w), cursor);

    XFlush(XtDisplay(w));
}


static Boolean CompareEvents( oldEvent, newEvent )
    XEvent *oldEvent, *newEvent;
{
#define Check(field) if (newEvent->field != oldEvent->field) return False;

    Check(xany.display);
    Check(xany.type);
    Check(xany.window);

    switch( newEvent->type ) {
      case MotionNotify:
		Check(xmotion.state); break;
      case ButtonPress:
      case ButtonRelease:
		Check(xbutton.state);
		Check(xbutton.button); break;
      case KeyPress:
      case KeyRelease:
		Check(xkey.state);
		Check(xkey.keycode); break;
      case EnterNotify:
      case LeaveNotify:
		Check(xcrossing.mode);
		Check(xcrossing.detail);
		Check(xcrossing.state); break;
    }
#undef Check

    return True;
}

struct EventData {
	XEvent *oldEvent;
	int count;
};

static Boolean PeekNotifyEvent( dpy, event, args )
    Display *dpy;
    XEvent *event;
    char *args;
{
    struct EventData *eventData = (struct EventData*)args;

    return ((++eventData->count == QLength(dpy)) /* since PeekIf blocks */
	    || CompareEvents(event, eventData->oldEvent));
}


static Boolean LookAhead( w, event )
    Widget w;
    XEvent *event;
{
    XEvent newEvent;
    struct EventData eventData;

    if (QLength(XtDisplay(w)) == 0) return False;

    eventData.count = 0;
    eventData.oldEvent = event;

    XPeekIfEvent(XtDisplay(w), &newEvent, PeekNotifyEvent, (char*)&eventData);

    if (CompareEvents(event, &newEvent))
	return True;
    else
	return False;
}


static void ExtractPosition( event, x, y )
    XEvent *event;
    int *x, *y;			/* RETURN */
{
    switch( event->type ) {
      case MotionNotify:
		*x = event->xmotion.x;	 *y = event->xmotion.y;	  break;
      case ButtonPress:
      case ButtonRelease:
		*x = event->xbutton.x;   *y = event->xbutton.y;   break;
      case KeyPress:
      case KeyRelease:
		*x = event->xkey.x;      *y = event->xkey.y;	  break;
      case EnterNotify:
      case LeaveNotify:
		*x = event->xcrossing.x; *y = event->xcrossing.y; break;
      default:
		*x = 0; *y = 0;
    }
}

static void NotifyScroll( gw, event, params, num_params   )
   Widget gw;
   XEvent *event;
   String *params;		/* style: Proportional|FullLength */
   Cardinal *num_params;	/* we only support 1 */
{
    CScrollbarWidget w = (CScrollbarWidget) gw;
    int call_data;
    char style;
    int x, y;
    float val[2];

    if (w->c_scrollbar.direction == 0) return; /* if no StartScroll */

    if (LookAhead(gw, event)) return;

    if (*num_params > 0) style = *params[0];
    else		 style = 'P';

    switch( style ) {
        case 'P':    /* Proportional */
        case 'p':    ExtractPosition( event, &x, &y );
		     call_data = InRange( PICKLENGTH( w, x, y ),
					  0,
					  w->c_scrollbar.length); break;

        case 'F':    /* FullLength */
        case 'f':    call_data = w->c_scrollbar.length; break;
    }

    switch( w->c_scrollbar.direction ) {
        case 'B':
        case 'b':    call_data = -call_data;
	  	     /* fall through */
        case 'F':
	case 'f':    XtCallCallbacks( gw, XtNscrollProc, (caddr_t)call_data );
	             break;

        case 'C':
	case 'c':    /* NotifyThumb has already called the thumbProc(s) */
	    	     /* Except in discrete mode */
	    	     if ( w->c_scrollbar.discrete )
		     {
			 val[0] = w->c_scrollbar.top - w->c_scrollbar.startLoc;
			 val[1] = w->c_scrollbar.shown;
			 XtCallCallbacks( gw, XtNthumbProc, val );
		     }
		     break;
    }
}

/* ARGSUSED */
static void EndScroll(gw, event, params, num_params )
   Widget gw;
   XEvent *event;		/* unused */
   String *params;		/* unused */
   Cardinal *num_params;	/* unused */
{
    CScrollbarWidget w = (CScrollbarWidget) gw;

    if ( w->c_scrollbar.recenter )
    {
	w->c_scrollbar.top = 0.5;
	PaintThumb( w );
    }
    XDefineCursor(XtDisplay(w), XtWindow(w), w->c_scrollbar.inactiveCursor);
    XFlush(XtDisplay(w));

    w->c_scrollbar.direction = 0;
}


/* ARGSUSED */
static void MoveThumb( gw, event, params, num_params )
   Widget gw;
   XEvent *event;
   String *params;		/* unused */
   Cardinal *num_params;	/* unused */
{
    CScrollbarWidget w = (CScrollbarWidget) gw;
    Position x, y;

    if (w->c_scrollbar.direction == 0) return; /* if no StartScroll */

    if (LookAhead(gw, event)) return;

    ExtractPosition( event, &x, &y );
    w->c_scrollbar.top = FractionLoc(w, x, y);
    PaintThumb(w);
    XFlush(XtDisplay(w));	/* re-draw it before Notifying */
}


/* ARGSUSED */
static void NotifyThumb( gw, event, params, num_params )
   Widget gw;
   XEvent *event;
   String *params;		/* unused */
   Cardinal *num_params;	/* unused */
{
    register CScrollbarWidget w = (CScrollbarWidget) gw;
    float val[2];

    if (w->c_scrollbar.direction == 0) return; /* if no StartScroll */

    if (LookAhead(gw, event)) return;

    /*
     * If relative mode is on,
     * don't send first event, but do record position
     * On subsequent events, send difference.
     * For simplicity, set startloc to 0 when not relative, then
     * can just subtract it always.
     */
    if ( *num_params > 0 && *params[0] == 'F' )
	if ( w->c_scrollbar.relative )
	{
	    w->c_scrollbar.startLoc = w->c_scrollbar.top;
	    return;
	}
	else if ( w->c_scrollbar.recenter )
	    w->c_scrollbar.startLoc = 0.5;
	else
	    w->c_scrollbar.startLoc = 0.0;
    /* If discrete mode is on don't send any thumb events */
    if ( !w->c_scrollbar.discrete )
    {
	val[0] = w->c_scrollbar.top - w->c_scrollbar.startLoc;
	val[1] = w->c_scrollbar.shown;
	if ( val[0] != 0.0 )
	    XtCallCallbacks( gw, XtNthumbProc, val );
	/* In relative mode, always remember previous position */
	if ( w->c_scrollbar.relative )
	    w->c_scrollbar.startLoc = w->c_scrollbar.top;
    }
}



/* Public routines. */

/* Set the scroll bar to the given location. */
extern void XtCScrollBarSetThumb( gw, top, shown )
  Widget gw;
  float top, shown;
{
    CScrollbarWidget w = (CScrollbarWidget)gw;

    if (w->c_scrollbar.direction == 'c') return; /* if still thumbing */

    w->c_scrollbar.top = (top > 1.0) ? 1.0 :
		       (top >= 0.0) ? top :
			   w->c_scrollbar.top;

    w->c_scrollbar.shown = (shown > 1.0) ? 1.0 :
			 (shown >= 0.0) ? shown :
			     w->c_scrollbar.shown;

    PaintThumb( w );
}
