#include	<stdio.h>
#include	<vfont.h>
#include	<sys/types.h>

#define		NCHARS	256

struct header	vhdr;
struct dispatch	vd[NCHARS];

initialize(argc, argv)
	int		argc;
	char		*argv[];
{
	if (argc < 2)
		fatal("Usage: bdf2vf vf");

	if (freopen(argv[1], "w", stdout) == NULL)
		fatal("Cannot open output file");
}

storeglyph(n, bbx, bby, offx, offy)
	int		n, bbx, bby, offx, offy;
{
	register struct dispatch	*d;

	d = &vd[n];
	d->nbytes = (bbx + 7) / 8 * bby;
	d->right = bbx + offx;
	d->left = -offx;
	d->up = bby + offy;
	d->down = -offy;
	d->width = bbx;
	if (bbx > vhdr.maxx)
		vhdr.maxx = bbx;
	if (bby > vhdr.maxy)
		vhdr.maxy = bby;
}

dumpfont(bitmaps)
	u_char	*bitmaps[NCHARS];
{
	register int	c, bitbytes = 0;
	register struct dispatch	*d;

	if (fseek(stdout, (long)(sizeof(vhdr) + sizeof(vd)), 0) < 0)
		fatal("Cannot seek on output");
	for (c = 0; c < NCHARS; ++c)
	{
		if (bitmaps[c] != NULL)
		{
			d = &vd[c];
			d->addr = bitbytes;
			if (fwrite((char *)bitmaps[c], d->nbytes, 1, stdout) != 1)
				fatal("Cannot write glyph");
			bitbytes += d->nbytes;
		}
	}
	vhdr.magic = VFONT_MAGIC;
	vhdr.size = bitbytes;
	if (fseek(stdout, 0L, 0) < 0)
		fatal("Cannot seek to beginning on output");
	if (fwrite((char *)&vhdr, sizeof(vhdr), 1, stdout) != 1)
		fatal("Cannot write header");
	if (fwrite((char *)vd, sizeof(vd), 1, stdout) != 1)
		fatal("Cannot write dispatch table");
}
