#include "gfto.h"
/*
 * Copyright 1988 Barry Shein
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Barry Shein not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  Barry Shein makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 * 
 * BARRY SHEIN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL BARRY SHEIN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Barry Shein, Encore Computer Corporation, BZS@ENCORE.COM
 */



/*
 * Dump as Adobe BDF format file
 */
dumpbdf() {
  struct perchar **pp;
  register struct perchar *p;
  int i,j,k,l,m;
  char *bp;
  long pts;
  int hpxpi;
  long w,h;
  int b;

  printf("STARTFONT 2.1\n");
  printf("COMMENT This font image translated from Metafont GF format\n");
  printf("COMMENT Input file was: %s\n",gffile);
  bp = basename(gffile);
  printf("FONT %s:%s\n",
	 (family == NULL) ? bp : family,
	 (face == NULL) ? bp : face);
  printf("SIZE %d %d %d\n",
	 pts = pa.ds/(TWOTO16*16),	  /* Point size 	*/
	 hpxpi = (((double)(PTPI*pa.hppp))/((double)TWOTO16))+0.5,
	 (int)((((double)(PTPI*pa.vppp))/((double)TWOTO16))+0.5));
  printf("FONTBOUNDINGBOX %d %d %d %d\n",
	 pa.max_m-pa.min_m+1,		  /* width	*/
	 pa.max_n-pa.min_n+1,		  /* height	*/
	 pa.min_m,			  /* x offset	*/
	 pa.min_n);			  /* y offset	*/

  /* These follow the X-windows conventions */
  printf("STARTPROPERTIES 3\n");
  printf("FONT_ASCENT %d\n",pa.max_n);
  printf("FONT_DESCENT %d\n",-pa.min_n);
  printf("COPYRIGHT \"%s\"\n",
	 (copyright == NULL) ? DEFCOPYRIGHT : copyright);
  printf("ENDPROPERTIES\n");
  printf("CHARS %d\n",nchars);

  for(i=0,pp=pc; i < nchars; i++,pp++) {
    p = *pp;
    printf("STARTCHAR C%03d\n",i);
    printf("ENCODING %d\n",i);
    printf("SWIDTH %d %d\n",
	   (p->boc.max_m*72000)/(pts*hpxpi),0);
    printf("DWIDTH %d %d\n",p->boc.max_m,0);
    printf("BBX %d %d %d %d\n",
	   w = p->boc.max_m-p->boc.min_m+1,
	   h = p->boc.max_n-p->boc.min_n+1,
	   p->boc.min_m,
	   p->boc.min_n);
    printf("BITMAP\n");

    for(j=0; j < h; j++) {
      for(b=0,k=0,l=0,m=0x80; k < w; k++) {
	if(l++ == 8) {
	  m = 0x80;
	  l = 1;
	  puthex(b);
	  b = 0;
	}
	if(getpix(p->image,j,k) == BLACK)
	  b |= m;
	m >>= 1;
      }
      if(l != 0)
	puthex(b);
      putchar('\n');
    }
    printf("ENDCHAR\n");
  }
  printf("ENDFONT\n");
}
