#include <stdio.h>
#include <ctype.h>
#ifdef SYSV
#include <string.h>
#define index(s,c) strchr((s),(c))
#define rindex(s,c) strrchr((s),(c))
#else
#include <strings.h>
#endif /* SYSV */
#include <sys/types.h>
#include <sys/stat.h>
/* in.h only included for the ntohl() etc. byte ordering macros */
#include <netinet/in.h>

#ifdef POSTSCRIPT
#include "text.h"
#endif

/*
 * Default place to look for GF files (change this for your site)
 */

#define GFDIR "/usr13/src/TeX2.0-MTPC/cmfonts/gf/gf118/"

/*
 * GFTO...(other format)
 *
 * Reads in a GF file (Generic Font File as produced by Knuth's MetaFont)
 * and writes it back out in other formats.
 *
 *
 * Copyright 1988 Barry Shein
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Barry Shein not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  Barry Shein makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 * 
 * BARRY SHEIN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL BARRY SHEIN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Barry Shein, Encore Computer Corporation, BZS@ENCORE.COM
 *
 *
 * Notes:
 * The description of the GF format I used was a combination of Knuth's
 * MetaFont book (the Orange one, Appendix G) and the GF file format
 * description I found in the source to the program GFTYPE.WEB supplied
 * with the TeX distribution (MFutils).
 *
 * In brief a GF format file consists of:
 *
 *	PREAMBLE
 *	CHARACTER IMAGES
 *	POSTAMBLE
 *	{char locators}
 *	POSTPOSTAMBLE
 *
 * The PREAMBLE basically just tells you that this is really a
 * GF file (magic number.)
 * The POSTPOSTAMBLE locates the POSTAMBLE (you read it backwards
 * from the end of the file.)
 * The POSTAMBLE gives some global character info (max/min height/width etc)
 * (this info is stored in the 'pa' struct)
 * The {char locators} gives per-char information and point back at
 * the actual char images (file seek pointer).
 * The images are stored as a list of commands 'OPCODE [optional data]'
 * such as PAINT the next n bits black.
 *
 * The images are banged into memory bit arrays because I found that the
 * (easier to process) byte arrays easily overflowed reasonable memory
 * units when applied to hi-res fonts (eg. 2602 pixels/point, an MF default,
 * caused 148MB of scratch memory to be asked for, this will still strain
 * many systems by asking for about 20MB as bit arrays but many systems
 * can handle that, hey, tanstaafl.)
 *
 * A lot of the odd looking variable names (particularly terse ones)
 * were chosen to match exactly the GF file format description that comes
 * with the MetaFont stuff (look in MFutils and weave GFtoDVI.)
 *
 * Configuration considerations:
 *
 *	You almost certainly want to change the GFDIR string to someplace
 *	to look for GF files on your system.
 *
 *	The program should be portable to most 8-bit byte machines where
 *	longs are 32-bits. Other architectures may reveal portability problems.
 *	See the routines get4(), get3(), get2(), setpix(), getpix() if you
 *	believe you are having portability problems.
 */

/*
 * Usage notes:
 *
 *	gftobdf [flags] gf-file-name
 *
 *      gf-file-name is a GF file name.
 *
 *	The file name is scanned for a slash (/), if one is found than
 *	it is used literally as a pathname. If no slash is found than
 *	we first see if there is a GFDIR environment variable and if not
 *	use the compiled in default and search there for the GF file named.
 *
 *	FLAGS:
 *
 *	-d:	Enable some debugging output to stderr
 *	-b:	Produce an Adobe BDF file on the stdout
 *	-c:	Produce a character dump (asterisks/dashes) of
 *		character bit images on stdout
 *	-F:	Set family name to following string (used in BDF)
 *	-f:	Set face name to following string (used in BDF)
 *	-C:	Set copyright to following string (used in BDF)
 */

/* Bits per byte */
#define BPERB	8
/*
 * Bits are stored hi-bit first so the Nth bit is found by
 * right shifting this:
 */
#define HIBIT 0x80


/*
 * This is a GF file's "magic number"
 */
#define GF_ID_BYTE	131
/*
 * The POSTPOSTAMBLE will be padded to a multiple
 * of four with 4..7 of these pad bytes
 */
#define GF_PAD		0337

/*
 * These are the opcodes directly from the Generic Font File Format
 * document.
 */
#define PAINT_0		0
#define PAINT_1		1
/* and everthing in between */
#define PAINT_63	63

#define PAINT1		64
#define PAINT2		65
#define PAINT3  	66

#define BOC		67
#define BOC1		68
#define EOC		69

#define SKIP0		70
#define SKIP1		71
#define SKIP2		72
#define SKIP3		73

#define NEW_ROW_0	74
#define NEW_ROW_1       75
/* and everything in between */
#define NEW_ROW_164	238

#define XXX1		239
#define XXX2		240
#define XXX3		241
#define XXX4		242
#define YYY		243

#define NO_OP		244

#define CHAR_LOC	245
#define CHAR_LOC0	246

#define PRE		247
#define POST		248
#define POST_POST	249

/*
 * GF file's name (for error messages etc.)
 */
char gffile[BUFSIZ];
/*
 * The seek value we discovered the postamble at (from POSTPOSTamble)
 */
unsigned long postseek;

/*
 * The global information read from the postamble
 */
struct postamble {
  unsigned int p;	/* points to final EOC or just past preamble if
			   no chars */
  unsigned long ds;	/* design size */
  unsigned long cs;	/* checksum, should match TFM */
  unsigned long hppp;	/* horizontal points per pixel * 2^16 */
  unsigned long vppp;	/* vertical points per pixel * 2^16 */
  /* extremum boundaries of glyph maps */
  int min_m, max_m, min_n, max_n;
} pa;

/*
 * Bounding box size for all glyphs (ie. the max)
 * Note that MF does not guarantee this to be optimal, big deal.
 */
int width, height;	/* in bits */
int widthb;		/* in bytes */

/*
 * The way we allocate perchar info is first allocate an
 * array of INITCHARMAX pointers and allocate them. If that
 * proves to be insufficient we allocate a double sized array
 * and copy the pointers over and continue, if that's not
 * enough we double again (2^N) etc.
 */
#define INITCHARMAX 256
int charmax;		/* current # of allocated pointers in table */
int nchars;		/* # of pointers actually in use */

/*
 * The per char info from the Char locators and the image.
 */
struct perchar {
  /* Char locator info */
  unsigned char residue;
  char exists;
  long dx, dy;
  long w;
  long p;
  struct boc {		/* We just convert boc1's into this format */
    long c;
    long p;
    long min_m;
    long max_m;
    long min_n;
    long max_n;
  } boc;
  char *image;
} **pc;

/*
 * Must be zero and one (we use xor'ing)
 * although you can swap which is which
 * if you like.
 */
#define WHITE 0
#define BLACK 1

/*
 * All diagnostic output will go to this stdio ptr,
 * usually set to stderr but can be redirected easily.
 */
FILE *errout;

/*
 * argv[0] for error messages etc.
 */
char *prog;

#define TRUE 1
#define FALSE 0

/* ya never know, these might be different on Mars */
#define TWOTO16	0x10000
#define PTPI 72.27

int debug;

char *family;
char *face;

#define DEFCOPYRIGHT "NO KNOWN COPYRIGHT ON THIS FONT"
char *copyright;

FILE *Fopen();
char *basename();
