#include "gfto.h"
/*
 * Copyright 1988 Barry Shein
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Barry Shein not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  Barry Shein makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 * 
 * BARRY SHEIN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL BARRY SHEIN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Barry Shein, Encore Computer Corporation, BZS@ENCORE.COM
 */



/*
 * GFTO - translate MetaFont GF (Generic Format) files to
 * other convenient formats.
 *
 * Output formats: Adobe BDF (used by X11) and char dump (asterisks)
 * Postscript download soon.
 *
 * Barry Shein, Boston University
 *
 */
main(argc,argv) int argc; char **argv;
{
  FILE *gfp;
  int bdf, dump;
#ifdef POSTSCRIPT
  int ps;
  int encbynum, encbyname, encbyfile;
  int encnum;
  char *encname, *encfile;
  struct TeXcharmap *tp;
#endif POSTSCRIPT

  errout = stderr;
  prog = *argv++;
  bdf = FALSE;
#ifdef POSTSCRIPT
  ps = encbynum = encbyname = encbyfile = FALSE;
  tp = NULL;
#endif

  while(--argc > 0)
    if(argv[0][0] == '-')
      switch(argv[0][1]) {

      case 'd':
	++debug;
	++argv;
	break;

      case 'b':
	bdf = TRUE;
	++argv;
	break;

      case 'c':
	dump = TRUE;
	++argv;
	break;

      case 'F':
	if(argc < 1)
	  Usage();
	++argv;
	family = *argv;
	++argv;
	--argc;
	break;

      case 'f':
	if(argc < 1)
	  Usage();
	++argv;
	face = *argv;
	++argv;
	--argc;
	break;

      case 'C':
	if(argc < 1)
	  Usage();
	++argv;
	copyright = *argv;
	++argv;
	--argc;
	break;
#ifdef POSTSCRIPT
      case 'p':
	ps = TRUE;
	++argv;
	break;

      case 'e':
	if(argc < 1)
	  Usage();
	++argv;
	if(isdigit(**argv)) {
	  encbynum = TRUE;
	  encnum = atoi(*argv);
	}
	else {
	  encbyname = TRUE;
	  encname = *argv;
	}
	++argv;
	--argc;
	break;

      case 'E':
	if(argc < 1)
	  Usage();
	++argv;
	encbyfile = TRUE;
	encfile = *argv;
	++argv;
	--argc;
	break;
#endif POSTSCRIPT
      default:
	Usage();
      }
    else break;

  if(argc < 1)
    Usage();

  if((gfp = Fopen(*argv,"GFDIR",GFDIR,gffile)) == NULL)
    sysfatal(1,gffile);

  GFread(gfp);

  if(dump)
    dumpimages();

  if(bdf)
    dumpbdf();

#ifdef POSTSCRIPT
  if(ps) {
    if(encbyname)
      tp = encodingname(encname);
    else if(encbynum)
      tp = encodingnumber(encnum);
    else if(encbyfile)
      tp = readencoding(encfile,nchars);
    else
      Usage();

    if(tp == NULL)
      exit(1);

    dumpps(tp);
  }
#endif POSTSCRIPT
  exit(0);
}
