
/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/*
 * X11 support and other enhancements added by Jeff Weinstein
 * (jeff@polyslo.calpoly.edu).  Please send all comments, bug
 * reports, fixes, suggestions regarding this version of XTrek
 * to me.  
 */

/*
 * $Header: /blackbird/home/jeff/TAPE2/xtrek.new/RCS/bitmaps.h,v 3.1 88/09/20 00:45:07 jeff Exp $
 */

/**** These are the ships ****/
#define VIEWS		16
#define ship_width	16
#define ship_height	16

static char fed_bits[VIEWS][32] = {
  {		/* fed rotated 0 degrees */
    0xc0, 0x03,  0xe0, 0x07,  0xf0, 0x0f,  0xf0, 0x0f,  0xf0, 0x0f,  0xe0, 0x07,  0xc0, 0x03,  0x90, 0x09,
    0x90, 0x09,  0x90, 0x09,  0xf0, 0x0f,  0x90, 0x09,  0x90, 0x09,  0x10, 0x08,  0x10, 0x08, 0x10,  0x08
  },
  {		/* fed rotated 22.5000 degrees */
    0x00, 0x06,  0xc0, 0x1f,  0xc0, 0x1f,  0xc0, 0x1f,  0xc0, 0x3f,  0x80, 0x1f,  0x90, 0x1f,  0x90, 0x03,
    0x98, 0x09,  0xf8, 0x08,  0xc8, 0x05,  0xe4, 0x06,  0x44, 0x02,  0x02, 0x02,  0x00, 0x02, 0x00,  0x01
  },
  {		/* fed rotated 45.0000 degrees */
    0x00, 0x00,  0x00, 0x1e,  0x00, 0x3f,  0x00, 0x7f,  0x00, 0x7f,  0x20, 0x7f,  0x10, 0x7f,  0x98, 0x3f,
    0xe4, 0x1d,  0xe2, 0x00,  0xf1, 0x04,  0xa0, 0x02,  0x80, 0x01,  0x80, 0x00,  0x40, 0x00, 0x20,  0x00
  },
  {		/* fed rotated 67.5000 degrees */
    0x00, 0x00,  0x00, 0x00,  0x00, 0x08,  0x00, 0x7e,  0xc0, 0x7e,  0x30, 0xfe,  0x1e, 0xff,  0xa1, 0x7f,
    0xf0, 0x7f,  0x78, 0x78,  0x50, 0x00,  0xc0, 0x03,  0xe0, 0x00,  0x18, 0x00,  0x04, 0x00, 0x00,  0x00
  },
  {		/* fed rotated 90.0000 degrees */
    0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0xff, 0x39,  0x20, 0x7c,  0x20, 0xfe,  0xf8, 0xff,
    0xf8, 0xff,  0x20, 0xfe,  0x20, 0x7c,  0xff, 0x39,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00, 0x00,  0x00
  },
  {		/* fed rotated 112.5000 degrees */
    0x00, 0x00,  0x04, 0x00,  0x18, 0x00,  0xe0, 0x00,  0xc0, 0x03,  0x50, 0x00,  0x78, 0x78,  0xf0, 0x7f,
    0xa1, 0x7f,  0x1e, 0xff,  0x30, 0xfe,  0xc0, 0x7e,  0x00, 0x7e,  0x00, 0x08,  0x00, 0x00, 0x00,  0x00
  },
  {		/* fed rotated 135.0000 degrees */
    0x20, 0x00,  0x40, 0x00,  0x80, 0x00,  0x00, 0x01,  0x20, 0x03,  0xf1, 0x04,  0xe2, 0x00,  0xfc, 0x01,
    0x88, 0x3f,  0x10, 0x7f,  0xa0, 0x7f,  0x80, 0x7f,  0x80, 0x7f,  0x00, 0x3f,  0x00, 0x1e, 0x00,  0x00
  },
  {		/* fed rotated 157.5000 degrees */
    0x00, 0x01,  0x00, 0x02,  0x02, 0x02,  0x44, 0x02,  0xe4, 0x06,  0xc8, 0x05,  0xf8, 0x08,  0x98, 0x09,
    0x90, 0x03,  0x90, 0x1f,  0x80, 0x1f,  0xc0, 0x3f,  0xc0, 0x1f,  0xc0, 0x1f,  0xc0, 0x1f, 0x00,  0x06
  },
  {		/* fed rotated 180.0000 degrees */
    0x10, 0x08,  0x10, 0x08,  0x10, 0x08,  0x90, 0x09,  0x90, 0x09,  0xf0, 0x0f,  0x90, 0x09,  0x90, 0x09,
    0x90, 0x09,  0xc0, 0x03,  0xe0, 0x07,  0xf0, 0x0f,  0xf0, 0x0f,  0xf0, 0x0f,  0xe0, 0x07, 0xc0,  0x03
  },
  {		/* fed rotated 202.5000 degrees */
    0x80, 0x00,  0x40, 0x00,  0x40, 0x40,  0x40, 0x22,  0x60, 0x27,  0xa0, 0x13,  0x10, 0x1f,  0x90, 0x19,
    0xc0, 0x09,  0xf8, 0x09,  0xf8, 0x01,  0xfc, 0x03,  0xf8, 0x03,  0xf8, 0x03,  0xf8, 0x03, 0x60,  0x00
  },
  {		/* fed rotated 225.0000 degrees */
    0x00, 0x04,  0x00, 0x02,  0x00, 0x01,  0x80, 0x01,  0x40, 0x05,  0x20, 0x8f,  0x00, 0x47,  0xb8, 0x27,
    0xfc, 0x19,  0xfe, 0x08,  0xfe, 0x04,  0xfe, 0x00,  0xfe, 0x00,  0xfc, 0x00,  0x78, 0x00, 0x00,  0x00
  },
  {		/* fed rotated 247.5000 degrees */
    0x00, 0x00,  0x00, 0x20,  0x00, 0x18,  0x00, 0x07,  0xc0, 0x03,  0x00, 0x0a,  0x1e, 0x1e,  0xfe, 0x0f,
    0xfe, 0x85,  0xff, 0x78,  0x7f, 0x0c,  0x7e, 0x03,  0x7e, 0x00,  0x10, 0x00,  0x00, 0x00, 0x00,  0x00
  },
  {		/* fed rotated 270.0000 degrees */
    0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x9c, 0xff,  0x3e, 0x04,  0x7f, 0x04,  0xff, 0x1f,
    0xff, 0x1f,  0x7f, 0x04,  0x3e, 0x04,  0x9c, 0xff,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00, 0x00,  0x00
  },
  {		/* fed rotated 292.5000 degrees */
    0x00, 0x00,  0x00, 0x00,  0x10, 0x00,  0x7e, 0x00,  0x7e, 0x03,  0x7f, 0x0c,  0xff, 0x78,  0xfe, 0x85,
    0xfe, 0x0f,  0x1e, 0x1e,  0x00, 0x0a,  0xc0, 0x03,  0x00, 0x07,  0x00, 0x18,  0x00, 0x20, 0x00,  0x00
  },
  {		/* fed rotated 315.0000 degrees */
    0x00, 0x00,  0x78, 0x00,  0xfc, 0x00,  0xfe, 0x01,  0xfe, 0x01,  0xfe, 0x05,  0xfe, 0x08,  0xfc, 0x11,
    0x80, 0x3f,  0x00, 0x47,  0x20, 0x8f,  0xc0, 0x04,  0x80, 0x00,  0x00, 0x01,  0x00, 0x02, 0x00,  0x04
  },
  {		/* fed rotated 337.5000 degrees */
    0x60, 0x00,  0xf8, 0x03,  0xf8, 0x03,  0xf8, 0x03,  0xfc, 0x03,  0xf8, 0x01,  0xf8, 0x09,  0xc0, 0x09,
    0x90, 0x19,  0x10, 0x1f,  0xa0, 0x13,  0x60, 0x27,  0x40, 0x22,  0x40, 0x40,  0x40, 0x00, 0x80,  0x00
  },
};

static char rom_bits[VIEWS][32] = {
  {		/* rom rotated 0 degrees */
    0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0xc2, 0x43,  0xe2, 0x47,  0xf2, 0x4f,  0xfa, 0x5f,  0xfa, 0x5f,
    0xfe, 0x7f,  0xfe, 0x7f,  0x0e, 0x70,  0x02, 0x40,  0x02, 0x40,  0x00, 0x00,  0x00, 0x00, 0x00,  0x00
  },
  {		/* rom rotated 22.5000 degrees */
    0x00, 0x00,  0x08, 0x00,  0x08, 0x00,  0x84, 0x03,  0xf4, 0x0f,  0xf6, 0x0f,  0xfe, 0x8f,  0xfe, 0x9f,
    0xf7, 0x5f,  0xc1, 0x5f,  0x00, 0x7e,  0x00, 0x38,  0x00, 0x38,  0x00, 0x10,  0x00, 0x10, 0x00,  0x00
  },
  {		/* rom rotated 45.0000 degrees */
    0x60, 0x00,  0x20, 0x00,  0x10, 0x00,  0xc8, 0x07,  0xfc, 0x0f,  0xff, 0x1f,  0xf9, 0x1f,  0xe0, 0x1f,
    0xc0, 0x1f,  0x80, 0x9f,  0x00, 0xcf,  0x00, 0x2e,  0x00, 0x1e,  0x00, 0x0c,  0x00, 0x04, 0x00,  0x06
  },
  {		/* rom rotated 67.5000 degrees */
    0x00, 0x03,  0xe0, 0x00,  0x38, 0x00,  0xfe, 0x01,  0xf8, 0x0f,  0xe0, 0x0f,  0xe0, 0x1f,  0xc0, 0x1f,
    0xc0, 0x1f,  0xc0, 0x0f,  0x80, 0x0f,  0x80, 0x0f,  0x00, 0x63,  0x80, 0x1f,  0x80, 0x07, 0xc0,  0x00
  },
  {		/* rom rotated 90.0000 degrees */
    0x00, 0x00,  0xf8, 0x1f,  0xe0, 0x00,  0xe0, 0x03,  0xc0, 0x07,  0xc0, 0x0f,  0xc0, 0x1f,  0xc0, 0x1f,
    0xc0, 0x1f,  0xc0, 0x1f,  0xc0, 0x0f,  0xc0, 0x07,  0xe0, 0x03,  0xe0, 0x00,  0xf8, 0x1f, 0x00,  0x00
  },
  {		/* rom rotated 112.5000 degrees */
    0xc0, 0x00,  0x80, 0x07,  0x80, 0x1f,  0x00, 0x63,  0x80, 0x0f,  0x80, 0x0f,  0xc0, 0x0f,  0xc0, 0x1f,
    0xc0, 0x1f,  0xe0, 0x1f,  0xe0, 0x0f,  0xf8, 0x0f,  0xfe, 0x01,  0x38, 0x00,  0xe0, 0x00, 0x00,  0x03
  },
  {		/* rom rotated 135.0000 degrees */
    0x00, 0x06,  0x00, 0x04,  0x00, 0x0c,  0x00, 0x1e,  0x00, 0x2e,  0x00, 0xcf,  0x80, 0x9f,  0xc0, 0x1f,
    0xe0, 0x1f,  0xf9, 0x1f,  0xff, 0x1f,  0xfc, 0x0f,  0xe8, 0x07,  0x10, 0x00,  0x20, 0x00, 0x60,  0x00
  },
  {		/* rom rotated 157.5000 degrees */
    0x00, 0x00,  0x00, 0x10,  0x00, 0x10,  0x00, 0x38,  0x00, 0x38,  0x00, 0x7e,  0xc1, 0x5f,  0xf7, 0x5f,
    0xfe, 0x9f,  0xfe, 0x8f,  0xf6, 0x0f,  0xf4, 0x0f,  0x84, 0x03,  0x08, 0x00,  0x08, 0x00, 0x00,  0x00
  },
  {		/* rom rotated 180.0000 degrees */
    0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x02, 0x40,  0x02, 0x40,  0x0e, 0x70,  0xfe, 0x7f,  0xfe, 0x7f,
    0xfa, 0x5f,  0xfa, 0x5f,  0xf2, 0x4f,  0xe2, 0x47,  0xc2, 0x43,  0x00, 0x00,  0x00, 0x00, 0x00,  0x00
  },
  {		/* rom rotated 202.5000 degrees */
    0x00, 0x00,  0x08, 0x00,  0x08, 0x00,  0x1c, 0x00,  0x1c, 0x00,  0x7e, 0x00,  0xfa, 0x83,  0xfa, 0xef,
    0xf9, 0x7f,  0xf1, 0x7f,  0xf0, 0x6f,  0xf0, 0x2f,  0xc0, 0x21,  0x00, 0x10,  0x00, 0x10, 0x00,  0x00
  },
  {		/* rom rotated 225.0000 degrees */
    0x60, 0x00,  0x20, 0x00,  0x30, 0x00,  0x78, 0x00,  0x74, 0x00,  0xf3, 0x00,  0xf9, 0x01,  0xf8, 0x03,
    0xf8, 0x07,  0xf8, 0x9f,  0xf8, 0xff,  0xf0, 0x3f,  0xe0, 0x13,  0x00, 0x08,  0x00, 0x04, 0x00,  0x06
  },
  {		/* rom rotated 247.5000 degrees */
    0x00, 0x03,  0xe0, 0x01,  0xf8, 0x01,  0xc6, 0x00,  0xf0, 0x01,  0xf0, 0x01,  0xf0, 0x03,  0xf8, 0x03,
    0xf8, 0x03,  0xf8, 0x07,  0xf0, 0x07,  0xf0, 0x1f,  0x80, 0x7f,  0x00, 0x1c,  0x00, 0x07, 0xc0,  0x00
  },
  {		/* rom rotated 270.0000 degrees */
    0x00, 0x00,  0xf8, 0x1f,  0x00, 0x07,  0xc0, 0x07,  0xe0, 0x03,  0xf0, 0x03,  0xf8, 0x03,  0xf8, 0x03,
    0xf8, 0x03,  0xf8, 0x03,  0xf0, 0x03,  0xe0, 0x03,  0xc0, 0x07,  0x00, 0x07,  0xf8, 0x1f, 0x00,  0x00
  },
  {		/* rom rotated 292.5000 degrees */
    0xc0, 0x00,  0x00, 0x07,  0x00, 0x1c,  0x80, 0x7f,  0xf0, 0x1f,  0xf0, 0x07,  0xf8, 0x07,  0xf8, 0x03,
    0xf8, 0x03,  0xf0, 0x03,  0xf0, 0x01,  0xf0, 0x01,  0xc6, 0x00,  0xf8, 0x01,  0xe0, 0x01, 0x00,  0x03
  },
  {		/* rom rotated 315.0000 degrees */
    0x00, 0x06,  0x00, 0x04,  0x00, 0x08,  0xe0, 0x13,  0xf0, 0x3f,  0xf8, 0xff,  0xf8, 0x9f,  0xf8, 0x07,
    0xf8, 0x07,  0xf9, 0x01,  0xf3, 0x00,  0x74, 0x00,  0x78, 0x00,  0x30, 0x00,  0x20, 0x00, 0x60,  0x00
  },
  {		/* rom rotated 337.5000 degrees */
    0x00, 0x00,  0x00, 0x10,  0x00, 0x10,  0xc0, 0x21,  0xf0, 0x2f,  0xf0, 0x6f,  0xf1, 0x7f,  0xf9, 0x7f,
    0xfa, 0xef,  0xfa, 0x83,  0x7e, 0x00,  0x1c, 0x00,  0x1c, 0x00,  0x08, 0x00,  0x08, 0x00, 0x00,  0x00
  },
};

static char kli_bits[VIEWS][32] = {
  {		/* kli rotated 0 degrees */
    0x80, 0x01,  0xc0, 0x03,  0xe0, 0x07,  0xc0, 0x03,  0x80, 0x01,  0x80, 0x01,  0x80, 0x01,  0x84, 0x21,
    0x84, 0x21,  0xfc, 0x3f,  0xfc, 0x3f,  0x8c, 0x31,  0x04, 0x20,  0x04, 0x20,  0x04, 0x20, 0x04,  0x20
  },
  {		/* kli rotated 22.5000 degrees */
    0x00, 0x04,  0x80, 0x0e,  0x00, 0x0f,  0x00, 0x1f,  0x00, 0x0f,  0x08, 0x03,  0x04, 0x03,  0x8c, 0x01,
    0xfe, 0x01,  0xf6, 0x21,  0xc3, 0x17,  0xc1, 0x1e,  0x01, 0x1c,  0x00, 0x08,  0x00, 0x08, 0x00,  0x04
  },
  {		/* kli rotated 45.0000 degrees */
    0x00, 0x00,  0x00, 0x00,  0x00, 0x1c,  0x10, 0x3c,  0x08, 0x3c,  0x0c, 0x3e,  0x1e, 0x07,  0xbd, 0x03,
    0xe0, 0x01,  0xe0, 0x00,  0xe0, 0x01,  0x80, 0x13,  0x00, 0x0f,  0x00, 0x07,  0x00, 0x02, 0x80,  0x01
  },
  {		/* kli rotated 67.5000 degrees */
    0x00, 0x00,  0x00, 0x00,  0x40, 0x00,  0x38, 0x10,  0x1e, 0x78,  0x39, 0xf8,  0x30, 0x7e,  0xe0, 0x3f,
    0xf0, 0x41,  0xf0, 0x00,  0xc0, 0x00,  0xc0, 0x00,  0x80, 0x05,  0xc0, 0x03,  0xe0, 0x00, 0x38,  0x00
  },
  {		/* kli rotated 90.0000 degrees */
    0x00, 0x00,  0x00, 0x00,  0xff, 0x01,  0x70, 0x00,  0x60, 0x00,  0x60, 0x20,  0x60, 0x70,  0xf0, 0xff,
    0xf0, 0xff,  0x60, 0x70,  0x60, 0x20,  0x60, 0x00,  0x70, 0x00,  0xff, 0x01,  0x00, 0x00, 0x00,  0x00
  },
  {		/* kli rotated 112.5000 degrees */
    0x38, 0x00,  0xe0, 0x00,  0xc0, 0x03,  0x80, 0x05,  0xc0, 0x00,  0xc0, 0x00,  0xf0, 0x00,  0xf0, 0x41,
    0xe0, 0x3f,  0x30, 0x7e,  0x39, 0xf8,  0x1e, 0x78,  0x38, 0x10,  0x40, 0x00,  0x00, 0x00, 0x00,  0x00
  },
  {		/* kli rotated 135.0000 degrees */
    0x80, 0x01,  0x00, 0x02,  0x00, 0x07,  0x00, 0x0f,  0x80, 0x13,  0xe0, 0x01,  0xe0, 0x00,  0xf1, 0x01,
    0xbd, 0x03,  0x1e, 0x07,  0x0c, 0x3e,  0x08, 0x3c,  0x10, 0x3c,  0x00, 0x1c,  0x00, 0x00, 0x00,  0x00
  },
  {		/* kli rotated 157.5000 degrees */
    0x00, 0x04,  0x00, 0x08,  0x00, 0x08,  0x01, 0x1c,  0xc1, 0x1e,  0xc3, 0x17,  0xf6, 0x21,  0xfe, 0x01,
    0x8c, 0x01,  0x04, 0x03,  0x08, 0x03,  0x00, 0x0f,  0x00, 0x1f,  0x00, 0x0f,  0x80, 0x0e, 0x00,  0x04
  },
  {		/* kli rotated 180.0000 degrees */
    0x04, 0x20,  0x04, 0x20,  0x04, 0x20,  0x04, 0x20,  0x8c, 0x31,  0xfc, 0x3f,  0xfc, 0x3f,  0x84, 0x21,
    0x84, 0x21,  0x80, 0x01,  0x80, 0x01,  0x80, 0x01,  0xc0, 0x03,  0xe0, 0x07,  0xc0, 0x03, 0x80,  0x01
  },
  {		/* kli rotated 202.5000 degrees */
    0x20, 0x00,  0x10, 0x00,  0x10, 0x00,  0x38, 0x80,  0x78, 0x83,  0xe8, 0xc3,  0x84, 0x6f,  0x80, 0x7f,
    0x80, 0x31,  0xc0, 0x20,  0xc0, 0x10,  0xf0, 0x00,  0xf8, 0x00,  0xf0, 0x00,  0x70, 0x01, 0x20,  0x00
  },
  {		/* kli rotated 225.0000 degrees */
    0x80, 0x01,  0x40, 0x00,  0xe0, 0x00,  0xf0, 0x00,  0xc8, 0x01,  0x80, 0x07,  0x00, 0x07,  0x80, 0x8f,
    0xc0, 0xbd,  0xe0, 0x78,  0x7c, 0x30,  0x3c, 0x10,  0x3c, 0x08,  0x38, 0x00,  0x00, 0x00, 0x00,  0x00
  },
  {		/* kli rotated 247.5000 degrees */
    0x00, 0x1c,  0x00, 0x07,  0xc0, 0x03,  0xa0, 0x01,  0x00, 0x03,  0x00, 0x03,  0x00, 0x0f,  0x82, 0x0f,
    0xfc, 0x07,  0x7e, 0x0c,  0x1f, 0x9c,  0x1e, 0x78,  0x08, 0x1c,  0x00, 0x02,  0x00, 0x00, 0x00,  0x00
  },
  {		/* kli rotated 270.0000 degrees */
    0x00, 0x00,  0x00, 0x00,  0x80, 0xff,  0x00, 0x0e,  0x00, 0x06,  0x04, 0x06,  0x0e, 0x06,  0xff, 0x0f,
    0xff, 0x0f,  0x0e, 0x06,  0x04, 0x06,  0x00, 0x06,  0x00, 0x0e,  0x80, 0xff,  0x00, 0x00, 0x00,  0x00
  },
  {		/* kli rotated 292.5000 degrees */
    0x00, 0x00,  0x00, 0x00,  0x00, 0x02,  0x08, 0x1c,  0x1e, 0x78,  0x1f, 0x9c,  0x7e, 0x0c,  0xfc, 0x07,
    0x82, 0x0f,  0x00, 0x0f,  0x00, 0x03,  0x00, 0x03,  0xa0, 0x01,  0xc0, 0x03,  0x00, 0x07, 0x00,  0x1c
  },
  {		/* kli rotated 315.0000 degrees */
    0x00, 0x00,  0x00, 0x00,  0x38, 0x00,  0x3c, 0x08,  0x3c, 0x10,  0x7c, 0x30,  0xe0, 0x78,  0xc0, 0xbd,
    0x80, 0x8f,  0x00, 0x07,  0x80, 0x07,  0xc8, 0x01,  0xf0, 0x00,  0xe0, 0x00,  0x40, 0x00, 0x80,  0x00
  },
  {		/* kli rotated 337.5000 degrees */
    0x20, 0x00,  0x70, 0x01,  0xf0, 0x00,  0xf8, 0x00,  0xf0, 0x00,  0xc0, 0x10,  0xc0, 0x20,  0x80, 0x31,
    0x80, 0x7f,  0x84, 0x6f,  0xe8, 0xc3,  0x78, 0x83,  0x38, 0x80,  0x10, 0x00,  0x10, 0x00, 0x20,  0x00
  },
};

static char ori_bits[VIEWS][32] = {
  {		/* ori rotated 0 degrees */
    0x80, 0x01,  0xc0, 0x03,  0xc0, 0x03,  0x80, 0x01,  0x80, 0x01,  0x80, 0x01,  0xc0, 0x03,  0xe0, 0x07,
    0xf0, 0x0f,  0xf8, 0x1f,  0xdc, 0x3b,  0x8c, 0x31,  0x8c, 0x31,  0x8c, 0x31,  0x8c, 0x31, 0x8c,  0x31
  },
  {		/* ori rotated 22.5000 degrees */
    0x00, 0x04,  0x00, 0x0e,  0x00, 0x0f,  0x00, 0x0e,  0x00, 0x07,  0x00, 0x03,  0xe0, 0x03,  0xf8, 0x03,
    0xfe, 0x07,  0xe6, 0x0f,  0xc7, 0x07,  0xe3, 0x0c,  0x63, 0x1c,  0x61, 0x0c,  0x30, 0x0c, 0x20,  0x06
  },
  {		/* ori rotated 45.0000 degrees */
    0x00, 0x00,  0x00, 0x00,  0x00, 0x18,  0x00, 0x3c,  0x00, 0x3c,  0x7c, 0x1f,  0xfe, 0x07,  0xe7, 0x03,
    0xe3, 0x07,  0xe1, 0x07,  0xf0, 0x07,  0x38, 0x06,  0x1c, 0x06,  0x08, 0x07,  0x80, 0x03, 0xc0,  0x01
  },
  {		/* ori rotated 67.5000 degrees */
    0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x08, 0x00,  0x5e, 0x70,  0xff, 0xf8,  0xe1, 0x7f,  0xe0, 0x2f,
    0xf0, 0x03,  0xfc, 0x03,  0xdf, 0x03,  0x82, 0x01,  0x80, 0x01,  0xe0, 0x00,  0xf8, 0x00, 0x3c,  0x00
  },
  {		/* ori rotated 90.0000 degrees */
    0x00, 0x00,  0x00, 0x00,  0x3f, 0x00,  0x7f, 0x00,  0xe0, 0x00,  0xc0, 0x01,  0xe0, 0x63,  0xff, 0xff,
    0xff, 0xff,  0xe0, 0x63,  0xc0, 0x01,  0xe0, 0x00,  0x7f, 0x00,  0x3f, 0x00,  0x00, 0x00, 0x00,  0x00
  },
  {		/* ori rotated 112.5000 degrees */
    0x3c, 0x00,  0xf8, 0x00,  0xe0, 0x00,  0x80, 0x01,  0x82, 0x01,  0xdf, 0x03,  0xfc, 0x03,  0xf0, 0x03,
    0xe0, 0x2f,  0xe1, 0x7f,  0xff, 0xf8,  0x5e, 0x70,  0x08, 0x00,  0x00, 0x00,  0x00, 0x00, 0x00,  0x00
  },
  {		/* ori rotated 135.0000 degrees */
    0xe0, 0x01,  0x80, 0x03,  0x08, 0x07,  0x1c, 0x06,  0x38, 0x06,  0x70, 0x07,  0xe1, 0x07,  0xc3, 0x03,
    0xe7, 0x07,  0xfe, 0x07,  0xfc, 0x1e,  0x00, 0x3c,  0x00, 0x3c,  0x00, 0x18,  0x00, 0x00, 0x00,  0x00
  },
  {		/* ori rotated 157.5000 degrees */
    0x20, 0x06,  0x30, 0x0c,  0x61, 0x0c,  0x63, 0x1c,  0xe3, 0x0c,  0xc7, 0x07,  0xe6, 0x0f,  0xfe, 0x07,
    0xf8, 0x03,  0xe0, 0x03,  0x00, 0x03,  0x00, 0x07,  0x00, 0x0e,  0x00, 0x0f,  0x00, 0x0e, 0x00,  0x04
  },
  {		/* ori rotated 180.0000 degrees */
    0x8c, 0x31,  0x8c, 0x31,  0x8c, 0x31,  0x8c, 0x31,  0x8c, 0x31,  0xdc, 0x3b,  0xf8, 0x1f,  0xf0, 0x0f,
    0xe0, 0x07,  0xc0, 0x03,  0x80, 0x01,  0x80, 0x01,  0x80, 0x01,  0xc0, 0x03,  0xc0, 0x03, 0x80,  0x01
  },
  {		/* ori rotated 202.5000 degrees */
    0x60, 0x04,  0x30, 0x0c,  0x30, 0x86,  0x38, 0xc6,  0x30, 0xc7,  0xe0, 0xe3,  0xf0, 0x67,  0xe0, 0x7f,
    0xc0, 0x1f,  0xc0, 0x07,  0xc0, 0x00,  0xe0, 0x00,  0x70, 0x00,  0xf0, 0x00,  0x70, 0x00, 0x20,  0x00
  },
  {		/* ori rotated 225.0000 degrees */
    0x80, 0x07,  0xc0, 0x01,  0xe0, 0x10,  0x60, 0x38,  0x60, 0x1c,  0xe0, 0x8e,  0xe0, 0x87,  0xe0, 0xc3,
    0xc0, 0xe7,  0xe0, 0x7f,  0xf8, 0x3e,  0x3c, 0x00,  0x3c, 0x00,  0x18, 0x00,  0x00, 0x00, 0x00,  0x00
  },
  {		/* ori rotated 247.5000 degrees */
    0x00, 0x3c,  0x00, 0x1f,  0x00, 0x07,  0x80, 0x01,  0x80, 0x41,  0xc0, 0xfb,  0xc0, 0x3f,  0xc0, 0x0f,
    0xf4, 0x07,  0xfe, 0x87,  0x1f, 0xff,  0x0e, 0x7a,  0x00, 0x10,  0x00, 0x00,  0x00, 0x00, 0x00,  0x00
  },
  {		/* ori rotated 270.0000 degrees */
    0x00, 0x00,  0x00, 0x00,  0x00, 0xfc,  0x00, 0xfe,  0x00, 0x07,  0x80, 0x03,  0xc6, 0x07,  0xff, 0xff,
    0xff, 0xff,  0xc6, 0x07,  0x80, 0x03,  0x00, 0x07,  0x00, 0xfe,  0x00, 0xfc,  0x00, 0x00, 0x00,  0x00
  },
  {		/* ori rotated 292.5000 degrees */
    0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x10,  0x0e, 0x7a,  0x1f, 0xff,  0xfe, 0x87,  0xf4, 0x07,
    0xc0, 0x0f,  0xc0, 0x3f,  0xc0, 0xfb,  0x80, 0x41,  0x80, 0x01,  0x00, 0x07,  0x00, 0x1f, 0x00,  0x3c
  },
  {		/* ori rotated 315.0000 degrees */
    0x00, 0x00,  0x00, 0x00,  0x18, 0x00,  0x3c, 0x00,  0x3c, 0x00,  0x78, 0x3f,  0xe0, 0x7f,  0xe0, 0xf7,
    0xc0, 0xc3,  0xe0, 0x87,  0xe0, 0x8e,  0x60, 0x1c,  0xe0, 0x38,  0xe0, 0x10,  0xc0, 0x00, 0x80,  0x03
  },
  {		/* ori rotated 337.5000 degrees */
    0x20, 0x00,  0x70, 0x00,  0xf0, 0x00,  0x70, 0x00,  0xe0, 0x00,  0xc0, 0x00,  0xc0, 0x07,  0xc0, 0x1f,
    0xe0, 0x7f,  0xf0, 0x67,  0xe0, 0xe3,  0x30, 0xc7,  0x38, 0xc6,  0x30, 0x86,  0x30, 0x0c, 0x60,  0x04
  },
};

/**** These are the explosions ****/

#define EX_FRAMES		5
#define ex_width	64
#define ex_height	64

static char ex_bits[5][512] = {
    {
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x80,  0x02, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x10,  0x1a, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x28,  0x1c, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x0b, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x0a,  0x08, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0xe0,  0x0f, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x94,  0x15, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0xd5,  0x75, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x95,  0x22, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x60,  0x1b, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0xf4,  0x1e, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x10,  0x01, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0xa0,  0x26, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x08, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x80,  0x06, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00, 0x00,  0x00
    }, {
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x40,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x04, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x04, 0x01,  0x00, 0x00,  0x00, 0x00,  0x00, 0x02,  0x80, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x40, 0x01,  0x00, 0x00,  0x00, 0x00,  0x80, 0x04,  0x10, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x82, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x44, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x04, 0x00,  0x80, 0x00,  0x00, 0x00,  0x00, 0x00,  0x88, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0xa0,  0xc0, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0xa8,  0x25, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x20, 0x00,  0x12, 0x02,  0x00, 0x00,  0x00, 0x00,  0x00, 0x81,  0x02, 0x02,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x60,  0x12, 0x2c,  0x00, 0x00,  0x00, 0x00,  0x22, 0x92,  0x00, 0x12,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x40,  0x04, 0x00,  0x00, 0x00,  0x00, 0x00,  0x12, 0x42,  0x00, 0x08,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x28,  0x48, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x20,  0x47, 0x02,  0x00, 0x00,
	 0x00, 0x00,  0x20, 0x28,  0x48, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x42,  0x18, 0x01,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x01,  0x02, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x04,  0x00, 0x04,  0x00, 0x00,  0x00, 0x00,  0x00, 0xc0,  0x14, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x40, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x28, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x40,  0x14, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00, 0x00,  0x00
   }, {
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x40,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x10, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x08, 0x20,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x40, 0x00,  0x00, 0x08,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x04,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x80, 0x20,  0x00, 0x00,  0x00, 0x00,  0x84, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x08,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x04, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x08, 0x02,  0x00, 0x00,  0x00, 0x08,  0x00, 0x00,  0x00, 0x08,  0x00, 0x00,
	 0x00, 0x00,  0x04, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x10,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x02,  0x00, 0x00,  0x00, 0x00,  0x00, 0x50,  0x00, 0x09,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x91,  0x09, 0x00,  0x00, 0x00,  0x00, 0x00,  0x01, 0x00,  0x04, 0x20,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x40,  0x44, 0x40,  0x00, 0x00,  0x00, 0x00,  0x10, 0x80,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x30,  0x44, 0x80,  0x10, 0x00,  0x00, 0x04,  0x40, 0x00,  0x00, 0x00,  0x05, 0x00,
	 0x00, 0x00,  0x01, 0x88,  0x00, 0x40,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x08, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x40, 0x40,  0x00, 0x00,  0x00, 0x00,  0x00, 0x44,  0x00, 0x20,  0x00, 0x00,  0x02, 0x00,
	 0x00, 0x00,  0x00, 0x12,  0x00, 0x04,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x22, 0x40,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x08,  0x12, 0x04,  0x00, 0x00,  0x00, 0x00,  0x01, 0x01,  0x00, 0x02,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x10,  0x90, 0x20,  0x00, 0x00,  0x00, 0x00,  0x40, 0x20,  0x30, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x10, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x02, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x80, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x80,  0x00, 0x00,  0x00, 0x00,  0x00, 0xc0,  0x48, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x04,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x02,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x10, 0x01,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x20,  0x08, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x40, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00, 0x00,  0x00
   }, {
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x20,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x20, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x10, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x02, 0x00,
	 0x00, 0x00,  0x08, 0x00,  0x00, 0x80,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x20,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x02, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x02,  0x00, 0x00,  0x00, 0x40,  0x10, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x08, 0x80,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x10,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x10, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x80,  0x00, 0x00,  0x10, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x40,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x40, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x10,  0x00, 0x00,  0x00, 0x00,  0x00, 0x48,  0x00, 0x80,  0x00, 0x00,
	 0x00, 0x00,  0x40, 0x00,  0x00, 0x08,  0x00, 0x00,  0x00, 0x00,  0x00, 0x44,  0x11, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x08, 0x00,  0x00, 0x00,  0x00, 0x08,  0x00, 0x00,  0x00, 0x01,  0x04, 0x00,
	 0x00, 0x00,  0x02, 0x40,  0x08, 0x00,  0x04, 0x00,  0x00, 0x00,  0x00, 0x80,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x20,  0x08, 0x02,  0x10, 0x08,  0x00, 0x00,  0x00, 0x08,  0x00, 0x00,  0x40, 0x00,
	 0x08, 0x00,  0x08, 0x00,  0x00, 0x00,  0x00, 0x01,  0x00, 0x04,  0x00, 0x82,  0x00, 0x00,  0x08, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x10, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x20,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x08, 0x00,  0x00, 0x00,  0x40, 0x00,  0x08, 0x02,  0x00, 0x10,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x08,  0x00, 0x20,  0x00, 0x00,  0x00, 0x00,  0x80, 0x00,  0x80, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x04, 0x00,  0x08, 0x00,  0x00, 0x00,  0x00, 0x04,  0x22, 0x20,  0x00, 0x00,
	 0x00, 0x00,  0x40, 0x00,  0x00, 0x10,  0x00, 0x00,  0x00, 0x04,  0x00, 0x08,  0x40, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x02,  0x02, 0x00,  0x00, 0x00,  0x08, 0x10,  0xc0, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x01, 0x00,  0x04, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x10, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x10, 0x00,
	 0x00, 0x00,  0x00, 0x60,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x10, 0x01,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x20,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x30,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x40, 0x04,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x10,  0x20, 0x01,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00, 0x00,  0x00
   }, {
	 0x00, 0x00,  0x00, 0x00,  0x40, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x20, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x40, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x01, 0x00,  0x00, 0x00,  0x08, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x02, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x40, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x08,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x04,  0x02, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x10, 0x00,  0x08, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x80,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x20, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x08, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x02,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x01, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x80,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x24,  0x00, 0x40,  0x08, 0x00,  0x00, 0x00,  0x10, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x42,  0x21, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x10, 0x00,  0x00, 0x00,
	 0x40, 0x00,  0x00, 0x00,  0x00, 0x00,  0x80, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x04,  0x80, 0x00,
	 0x00, 0x20,  0x00, 0x20,  0x10, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x80,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x10,  0x00, 0x08,  0x00, 0x02,  0x00, 0x00,  0x00, 0x02,  0x08, 0x00,  0x00, 0x10,
	 0x00, 0x80,  0x00, 0x00,  0x00, 0x00,  0x00, 0x40,  0x00, 0x00,  0x80, 0x00,  0x00, 0x00,  0x00, 0x01,
	 0x20, 0x00,  0x00, 0x80,  0x00, 0x00,  0x80, 0x00,  0x00, 0x00,  0x00, 0x00,  0x20, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x01, 0x10,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x10,  0x00, 0x00,  0x00, 0x10,  0x08, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x04,  0x00, 0x00,  0x03, 0x00,  0x00, 0x00,  0x20, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x08, 0x02,  0x00, 0x01,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x02, 0x00,
	 0x00, 0x00,  0x00, 0x01,  0x44, 0x00,  0x00, 0x00,  0x00, 0x00,  0x10, 0x00,  0x00, 0x80,  0x00, 0x00,
	 0x20, 0x00,  0x00, 0x00,  0x00, 0x01,  0x00, 0x00,  0x00, 0x00,  0x00, 0x04,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x09,  0x20, 0x00,  0x00, 0x00,  0x01, 0x08,  0x80, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x20,  0x00, 0x00,  0x04, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x02, 0x00,  0x00, 0x00,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x02,
	 0x00, 0x00,  0x00, 0x50,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x20, 0x08,  0x00, 0x00,
	 0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00, 0x00,  0x00
    }
};

/**** These are the misc things ****/

#define cloud_width 7
#define cloud_height 7
static char cloud_bits[] = {
    0x14, 0x2a, 0x55, 0x2a,
    0x55, 0x2a, 0x14};

#define etorp_width 3
#define etorp_height 3
static char etorp_bits[] = {
    0x05, 0x02, 0x05};

#define mtorp_width 3
#define mtorp_height 3
static char mtorp_bits[] = {
    0x02, 0x07, 0x02};

#define crossw 15
#define crossh 15
static char crossbits[] = {
    0x80, 0x00,  0x80, 0x00,  0x80, 0x00,  0x80, 0x00,
    0x80, 0x00,  0x80, 0x00,  0x80, 0x00,  0xff, 0x7f,
    0x80, 0x00,  0x80, 0x00,  0x80, 0x00,  0x80, 0x00,
    0x80, 0x00,  0x80, 0x00,  0x80, 0x00};

#define crossmask_width 15
#define crossmask_height 15
static char crossmask_bits[] = {
    0xc0, 0x01,  0xc0, 0x01,  0xc0, 0x01,  0xc0, 0x01,
    0xc0, 0x01,  0xc0, 0x01,  0xff, 0x7f,  0xff, 0x7f,
    0xff, 0x7f,  0xc0, 0x01,  0xc0, 0x01,  0xc0, 0x01,
    0xc0, 0x01,  0xc0, 0x01,  0xc0, 0x01};

#define planet_width 30
#define planet_height 30
static char planet0_bits[] = {
    0x00, 0xf8,  0x03, 0x00,  0x00, 0x07,  0x1c, 0x00,
    0xc0, 0x00,  0x60, 0x00,  0x20, 0x00,  0x80, 0x00,
    0x10, 0x00,  0x00, 0x01,  0x08, 0x00,  0x00, 0x02,
    0x04, 0x00,  0x00, 0x04,  0x04, 0x00,  0x00, 0x04,
    0x02, 0x00,  0x00, 0x08,  0x02, 0x00,  0x00, 0x08,
    0x02, 0x00,  0x00, 0x08,  0x01, 0x00,  0x00, 0x10,
    0x01, 0x00,  0x00, 0x10,  0x01, 0x00,  0x00, 0x10,
    0x01, 0x00,  0x00, 0x10,  0x01, 0x00,  0x00, 0x10,
    0x01, 0x00,  0x00, 0x10,  0x01, 0x00,  0x00, 0x10,
    0x02, 0x00,  0x00, 0x08,  0x02, 0x00,  0x00, 0x08,
    0x02, 0x00,  0x00, 0x08,  0x04, 0x00,  0x00, 0x04,
    0x04, 0x00,  0x00, 0x04,  0x08, 0x00,  0x00, 0x02,
    0x10, 0x00,  0x00, 0x01,  0x20, 0x00,  0x80, 0x00,
    0xc0, 0x00,  0x60, 0x00,  0x00, 0x07,  0x1c, 0x00,
    0x00, 0xf8,  0x03, 0x00,  0x00, 0x00,  0x00, 0x00};

static char planet1_bits[] = {
   0x00, 0xf8, 0x03, 0x00, 0x00, 0x57, 0x1d, 0x00, 0xc0, 0xaa, 0x6a, 0x00,
   0x60, 0x55, 0xd5, 0x00, 0xb0, 0xaa, 0xaa, 0x01, 0x58, 0x55, 0x55, 0x03,
   0xac, 0xaa, 0xaa, 0x06, 0x54, 0x55, 0x55, 0x05, 0xaa, 0xaa, 0xaa, 0x0a,
   0x56, 0x55, 0x55, 0x0d, 0xaa, 0xaa, 0xaa, 0x0a, 0x55, 0x55, 0x55, 0x15,
   0xab, 0xaa, 0xaa, 0x1a, 0x55, 0x55, 0x55, 0x15, 0xab, 0xaa, 0xaa, 0x1a,
   0x55, 0x55, 0x55, 0x15, 0xab, 0xaa, 0xaa, 0x1a, 0x55, 0x55, 0x55, 0x15,
   0xaa, 0xaa, 0xaa, 0x0a, 0x56, 0x55, 0x55, 0x0d, 0xaa, 0xaa, 0xaa, 0x0a,
   0x54, 0x55, 0x55, 0x05, 0xac, 0xaa, 0xaa, 0x06, 0x58, 0x55, 0x55, 0x03,
   0xb0, 0xaa, 0xaa, 0x01, 0x60, 0x55, 0xd5, 0x00, 0xc0, 0xaa, 0x6a, 0x00,
   0x00, 0x57, 0x1d, 0x00, 0x00, 0xf8, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00};

static char planet2_bits[] = {
   0x00, 0xf8, 0x03, 0x00, 0x00, 0x07, 0x1c, 0x00, 0xc0, 0xff, 0x7f, 0x00,
   0x20, 0x00, 0x80, 0x00, 0xf0, 0xff, 0xff, 0x01, 0x08, 0x00, 0x00, 0x02,
   0xfc, 0xff, 0xff, 0x07, 0x04, 0x00, 0x00, 0x04, 0xfe, 0xff, 0xff, 0x0f,
   0x02, 0x00, 0x00, 0x08, 0xfe, 0xff, 0xff, 0x0f, 0x01, 0x00, 0x00, 0x10,
   0xff, 0xff, 0xff, 0x1f, 0x01, 0x00, 0x00, 0x10, 0xff, 0xff, 0xff, 0x1f,
   0x01, 0x00, 0x00, 0x10, 0xff, 0xff, 0xff, 0x1f, 0x01, 0x00, 0x00, 0x10,
   0xfe, 0xff, 0xff, 0x0f, 0x02, 0x00, 0x00, 0x08, 0xfe, 0xff, 0xff, 0x0f,
   0x04, 0x00, 0x00, 0x04, 0xfc, 0xff, 0xff, 0x07, 0x08, 0x00, 0x00, 0x02,
   0xf0, 0xff, 0xff, 0x01, 0x20, 0x00, 0x80, 0x00, 0xc0, 0xff, 0x7f, 0x00,
   0x00, 0x07, 0x1c, 0x00, 0x00, 0xf8, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00};

static char planet3_bits[] = {
   0x00, 0xf8, 0x03, 0x00, 0x00, 0x57, 0x1d, 0x00, 0xc0, 0x55, 0x75, 0x00,
   0x60, 0x55, 0xd5, 0x00, 0x50, 0x55, 0x55, 0x01, 0x58, 0x55, 0x55, 0x03,
   0x54, 0x55, 0x55, 0x05, 0x54, 0x55, 0x55, 0x05, 0x56, 0x55, 0x55, 0x0d,
   0x56, 0x55, 0x55, 0x0d, 0x56, 0x55, 0x55, 0x0d, 0x55, 0x55, 0x55, 0x15,
   0x55, 0x55, 0x55, 0x15, 0x55, 0x55, 0x55, 0x15, 0x55, 0x55, 0x55, 0x15,
   0x55, 0x55, 0x55, 0x15, 0x55, 0x55, 0x55, 0x15, 0x55, 0x55, 0x55, 0x15,
   0x56, 0x55, 0x55, 0x0d, 0x56, 0x55, 0x55, 0x0d, 0x56, 0x55, 0x55, 0x0d,
   0x54, 0x55, 0x55, 0x05, 0x54, 0x55, 0x55, 0x05, 0x58, 0x55, 0x55, 0x03,
   0x50, 0x55, 0x55, 0x01, 0x60, 0x55, 0xd5, 0x00, 0xc0, 0x55, 0x75, 0x00,
   0x00, 0x57, 0x1d, 0x00, 0x00, 0xf8, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00};

static char planet4_bits[] = {
   0x00, 0xf8, 0x03, 0x00, 0x00, 0x97, 0x1c, 0x00, 0xc0, 0x49, 0x72, 0x00,
   0xa0, 0x24, 0xc9, 0x00, 0x50, 0x92, 0x24, 0x01, 0x28, 0x49, 0x92, 0x02,
   0x94, 0x24, 0x49, 0x06, 0x4c, 0x92, 0x24, 0x05, 0x26, 0x49, 0x92, 0x0c,
   0x92, 0x24, 0x49, 0x0a, 0x4a, 0x92, 0x24, 0x09, 0x25, 0x49, 0x92, 0x14,
   0x93, 0x24, 0x49, 0x12, 0x49, 0x92, 0x24, 0x19, 0x25, 0x49, 0x92, 0x14,
   0x93, 0x24, 0x49, 0x12, 0x49, 0x92, 0x24, 0x19, 0x25, 0x49, 0x92, 0x14,
   0x92, 0x24, 0x49, 0x0a, 0x4a, 0x92, 0x24, 0x09, 0x26, 0x49, 0x92, 0x0c,
   0x94, 0x24, 0x49, 0x06, 0x4c, 0x92, 0x24, 0x05, 0x28, 0x49, 0x92, 0x02,
   0x90, 0x24, 0x49, 0x01, 0x60, 0x92, 0xa4, 0x00, 0xc0, 0x49, 0x72, 0x00,
   0x00, 0x27, 0x1d, 0x00, 0x00, 0xf8, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00};

#define mplanet_width 16
#define mplanet_height 16
static char mplanet0_bits[] = {
    0xe0, 0x03,  0x18, 0x0c,  0x04, 0x10,  0x02, 0x20,
    0x02, 0x20,  0x01, 0x40,  0x01, 0x40,  0x01, 0x40,
    0x01, 0x40,  0x01, 0x40,  0x02, 0x20,  0x02, 0x20,
    0x04, 0x10,  0x18, 0x0c,  0xe0, 0x03,  0x00, 0x00};

static char mplanet1_bits[] = {
   0xe0, 0x03, 0x58, 0x0d, 0xac, 0x1a, 0x56, 0x35, 0xaa, 0x2a, 0x55, 0x55,
   0xab, 0x6a, 0x55, 0x55, 0xab, 0x6a, 0x55, 0x55, 0xaa, 0x2a, 0x56, 0x35,
   0xac, 0x1a, 0x58, 0x0d, 0xe0, 0x03, 0x00, 0x00};

static char mplanet2_bits[] = {
   0xe0, 0x03, 0x18, 0x0c, 0xfc, 0x1f, 0x02, 0x20, 0xfe, 0x3f, 0x01, 0x40,
   0xff, 0x7f, 0x01, 0x40, 0xff, 0x7f, 0x01, 0x40, 0xfe, 0x3f, 0x02, 0x20,
   0xfc, 0x1f, 0x18, 0x0c, 0xe0, 0x03, 0x00, 0x00};

static char mplanet3_bits[] = {
   0xe0, 0x03, 0x58, 0x0d, 0x54, 0x15, 0x56, 0x35, 0x56, 0x35, 0x55, 0x55,
   0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x56, 0x35, 0x56, 0x35,
   0x54, 0x15, 0x58, 0x0d, 0xe0, 0x03, 0x00, 0x00};

static char mplanet4_bits[] = {
   0xe0, 0x03, 0x58, 0x0e, 0x24, 0x19, 0x92, 0x24, 0x4a, 0x32, 0x25, 0x49,
   0x93, 0x64, 0x49, 0x52, 0x25, 0x49, 0x93, 0x64, 0x4a, 0x32, 0x26, 0x29,
   0x94, 0x14, 0x58, 0x0e, 0xe0, 0x03, 0x00, 0x00};

#define shield_width 20
#define shield_height 20
static char shield_bits[] = {
    0xc0, 0x3f,  0x00,  0x30, 0xc0,  0x00,
    0x08, 0x00,  0x01,  0x04, 0x00,  0x02,
    0x02, 0x00,  0x04,  0x02, 0x00,  0x04,
    0x01, 0x00,  0x08,  0x01, 0x00,  0x08,
    0x01, 0x00,  0x08,  0x01, 0x00,  0x08,
    0x01, 0x00,  0x08,  0x01, 0x00,  0x08,
    0x01, 0x00,  0x08,  0x01, 0x00,  0x08,
    0x02, 0x00,  0x04,  0x02, 0x00,  0x04,
    0x04, 0x00,  0x02,  0x08, 0x00,  0x01,
    0x30, 0xc0,  0x00,  0xc0, 0x3f,  0x00};

#define yshield_width 20
#define yshield_height 20
static char yshield_bits[] = {
   0x80, 0x2a, 0x00, 0x20, 0x80, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x02,
   0x02, 0x00, 0x00, 0x00, 0x00, 0x04, 0x01, 0x00, 0x00, 0x00, 0x00, 0x08,
   0x01, 0x00, 0x00, 0x00, 0x00, 0x08, 0x01, 0x00, 0x00, 0x00, 0x00, 0x08,
   0x01, 0x00, 0x00, 0x00, 0x00, 0x08, 0x02, 0x00, 0x00, 0x00, 0x00, 0x04,
   0x04, 0x00, 0x00, 0x00, 0x00, 0x01, 0x10, 0x40, 0x00, 0x40, 0x15, 0x00};

#define rshield_width 20
#define rshield_height 20
static char rshield_bits[] = {
   0x00, 0x33, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x02,
   0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08,
   0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08,
   0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x04,
   0x04, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0xc0, 0x00, 0xc0, 0x0c, 0x00};

#define icon_width 64
#define icon_height 64
static char icon_bits[] = {
    0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
    0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
    0xf8, 0x83,  0x0f, 0x00,  0x00, 0x00,  0x00, 0x00,
    0xf0, 0x01,  0x03, 0x00,  0x00, 0x00,  0x00, 0x00,
    0xe0, 0x01,  0x03, 0x00,  0x00, 0x00,  0x00, 0x00,
    0xc0, 0x83,  0x01, 0x00,  0x00, 0x00,  0x00, 0x00,
    0xc0, 0x83,  0x01, 0x00,  0x00, 0x00,  0x00, 0x00,
    0x80, 0xc7,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
    0x80, 0x67,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
    0x00, 0x6f,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
    0x00, 0x3f,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
    0x00, 0x1e,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
    0x00, 0x1e,  0xf0, 0xbf,  0x7f, 0xe0,  0x1b, 0x0e,
    0x00, 0x3c,  0xf8, 0x9f,  0xff, 0xf8,  0x19, 0x07,
    0x00, 0x3c,  0x80, 0x81,  0xe1, 0x1c,  0x98, 0x03,
    0x00, 0x7e,  0x80, 0x81,  0x71, 0x0e,  0xd8, 0x01,
    0x00, 0x7b,  0x80, 0x81,  0x39, 0x06,  0xf8, 0x00,
    0x00, 0xf3,  0x80, 0x81,  0x1d, 0xfe,  0xf9, 0x03,
    0x80, 0xf1,  0x80, 0x81,  0x7f, 0xfe,  0xf8, 0x07,
    0xc0, 0xe0,  0x81, 0x81,  0xe1, 0x06,  0x18, 0x0e,
    0xc0, 0xe0,  0x81, 0x81,  0xc1, 0x0e,  0x18, 0x0c,
    0x60, 0xe0,  0x83, 0x81,  0xc1, 0x1c,  0x1a, 0x0c,
    0x70, 0xc0,  0x87, 0x81,  0xc1, 0xf8,  0x1b, 0x7c,
    0xfc, 0xe0,  0xdf, 0xc3,  0xe3, 0xe0,  0x3d, 0x3e,
    0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
    0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
    0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
    0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
    0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
    0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
    0x00, 0x20,  0xe0, 0xff,  0x0f, 0x30,  0x08, 0x06,
    0x00, 0xfc,  0xe1, 0xff,  0x07, 0x30,  0x7f, 0x06,
    0xe0, 0xff,  0x1f, 0x01,  0x00, 0xf8,  0xff, 0x0f,
    0x00, 0xfe,  0x0f, 0x01,  0x00, 0x80,  0xff, 0x00,
    0x00, 0x70,  0x1c, 0x01,  0x00, 0x00,  0x5d, 0x00,
    0x00, 0x00,  0xf0, 0xff,  0x01, 0x00,  0x3e, 0x00,
    0x00, 0x00,  0xe0, 0xff,  0x00, 0x00,  0x36, 0x00,
    0x00, 0x00,  0xf0, 0x3f,  0x00, 0x00,  0x3e, 0x00,
    0x00, 0x00,  0xe0, 0x1f,  0x00, 0x00,  0x1c, 0x00,
    0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
    0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
    0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00,
    0x00, 0x00,  0x00, 0x00,  0x00, 0xff,  0xff, 0x7f,
    0x00, 0x00,  0x00, 0x00,  0x00, 0x01,  0x00, 0x40,
    0x00, 0x00,  0x00, 0x00,  0x00, 0x01,  0x00, 0x40,
    0x00, 0xf8,  0x00, 0x00,  0x00, 0xa1,  0x00, 0x40,
    0x00, 0xfe,  0xe3, 0xff,  0x0f, 0xa1,  0x6e, 0x40,
    0x00, 0xff,  0xe7, 0xff,  0x0f, 0xa1,  0xa2, 0x40,
    0x80, 0xff,  0x0f, 0x01,  0x00, 0xa1,  0x66, 0x40,
    0x80, 0x8f,  0x0f, 0x01,  0x00, 0xa1,  0xa2, 0x40,
    0xc0, 0x77,  0x1f, 0x01,  0x00, 0x41,  0xae, 0x42,
    0xc0, 0xfb,  0xfe, 0xff,  0x01, 0x01,  0x00, 0x40,
    0xc0, 0xdb,  0xfe, 0xff,  0x01, 0x01,  0x00, 0x40,
    0xc0, 0xfb,  0xfe, 0xff,  0x01, 0x01,  0x00, 0x40,
    0xc0, 0x77,  0x1f, 0x01,  0x00, 0x81,  0xc0, 0x43,
    0x80, 0x8f,  0x0f, 0x01,  0x00, 0xc1,  0x20, 0x43,
    0x80, 0xff,  0x0f, 0x01,  0x00, 0xa1,  0xa0, 0x42,
    0x00, 0xff,  0xe7, 0xff,  0x0f, 0x91,  0xa0, 0x42,
    0x00, 0xfe,  0xe3, 0xff,  0x0f, 0xf1,  0xa1, 0x42,
    0x00, 0xf8,  0x00, 0x00,  0x00, 0x81,  0x60, 0x42,
    0x00, 0x00,  0x00, 0x00,  0x00, 0x81,  0xec, 0x41,
    0x00, 0x00,  0x00, 0x00,  0x00, 0x01,  0x00, 0x40,
    0x00, 0x00,  0x00, 0x00,  0x00, 0xff,  0xff, 0x7f,
    0x00, 0x00,  0x00, 0x00,  0x00, 0x00,  0x00, 0x00};

#define stipple_width 16
#define stipple_height 16
static char stipple_bits[] = {
    0x01, 0x01,  0x02, 0x02,  0x04, 0x04,  0x08, 0x08,
    0x10, 0x10,  0x20, 0x20,  0x40, 0x40,  0x80, 0x80,
    0x01, 0x01,  0x02, 0x02,  0x04, 0x04,  0x08, 0x08,
    0x10, 0x10,  0x20, 0x20,  0x40, 0x40,  0x80, 0x80};

