
/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/*
 * X11 support and other enhancements added by Jeff Weinstein
 * (jeff@polyslo.calpoly.edu).  Please send all comments, bug
 * reports, fixes, suggestions regarding this version of XTrek
 * to me.  
 */

static char RCSID[] = "$Header: /blackbird/home/jeff/TAPE2/xtrek.new/RCS/death.c,v 3.1 88/09/20 00:43:52 jeff Exp $";

#include <X11/Xlib.h>
#include <X11/Xos.h>
#include <stdio.h>
#include <signal.h>
#include <setjmp.h>
#include "defs.h"
#include "struct.h"
#include "data.h"

extern jmp_buf env;

static struct itimerval udt;

death()
{
    char buf[80];

    signal(SIGALRM, SIG_IGN);
    udt.it_interval.tv_sec = 0;
    udt.it_interval.tv_usec = 0;
    udt.it_value.tv_sec = 0;
    udt.it_value.tv_usec = 0;
    setitimer(ITIMER_REAL, &udt, 0);
    signal(SIGALRM, SIG_DFL);

    me->p_status = POUTFIT;		/* Stop the ghost buster */

    XClearWindow(dpy, w);
    XSetWindowBorderPixmap(dpy, baseWin, gTile);
    if (showStats)
	closeStats(statwin);
    if (infomapped)
	destroyInfo();
    if (ismapped(playerw))
	XUnmapWindow(dpy, playerw);
    if (ismapped(planetw))
	XUnmapWindow(dpy, planetw);
    if (ismapped(war))
	XUnmapWindow(dpy, war);

    switch (me->p_whydead) {
	case KQUIT:
	    sprintf(buf, "You have self-destructed");
	    XText(w, 50, 250, buf, strlen(buf), dfont, textColor, backColor);
	    mustexit = 1;  /* Hey!  If you quit, you quit */
	    break;
	case KTORP:
	    sprintf(buf, "You were killed by a torp from %s (%c%x)",
		players[me->p_whodead].p_name,
		teamlet[players[me->p_whodead].p_team],
		me->p_whodead);
	    XText(w, 50, 250, buf, strlen(buf), dfont, textColor, backColor);
	    sprintf(buf, "who was %d%% damaged",
		players[me->p_whodead].p_damage);
	    XText(w, 50, 260, buf, strlen(buf), dfont, textColor, backColor);
	    break;
	case KPHASER:
	    sprintf(buf, "You were killed by a phaser shot from %s (%c%x)",
		players[me->p_whodead].p_name,
		teamlet[players[me->p_whodead].p_team],
		me->p_whodead);
	    XText(w, 50, 250, buf, strlen(buf), dfont, textColor, backColor);
	    sprintf(buf, "who was %d%% damaged",
		players[me->p_whodead].p_damage);
	    XText(w, 50, 260, buf, strlen(buf), dfont, textColor, backColor);
	    break;
	case KPLANET:
	    sprintf(buf, "You were killed by planetary fire from %s (%c)",
		planets[me->p_whodead].pl_name,
		teamlet[planets[me->p_whodead].pl_owner]);
	    XText(w, 50, 250, buf, strlen(buf), dfont, textColor, backColor);
	    break;
	case KSHIP:
	    sprintf(buf, "You were killed by an exploding ship formerly owned by %s (%c%x)",
		players[me->p_whodead].p_name,
		teamlet[players[me->p_whodead].p_team],
		me->p_whodead);
	    XText(w, 50, 250, buf, strlen(buf), dfont, textColor, backColor);
	    sprintf(buf, "who was %d%% damaged",
		players[me->p_whodead].p_damage);
	    XText(w, 50, 260, buf, strlen(buf), dfont, textColor, backColor);
	    break;
	case KDAEMON:
	    sprintf(buf, "You were killed by a dying daemon");
	    XText(w, 50, 250, buf, strlen(buf), dfont, textColor, backColor);
	    mustexit = 1;
	    break;
	case KWINNER:
	    sprintf(buf, "Galaxy has been conquered by %s (%c%x)",
		players[me->p_whodead].p_name,
		teamlet[players[me->p_whodead].p_team],
		players[me->p_whodead].p_no);
	    XText(w, 50, 250, buf, strlen(buf), dfont, textColor, backColor);
	    mustexit = 1;
	    break;
	case KGHOST:
	    sprintf(buf, "You were killed by a confused daemon");
	    XText(w, 50, 250, buf, strlen(buf), dfont, textColor, backColor);
	    mustexit = 1;
	    break;
	default:
	    sprintf(buf, "You were killed by something unknown to this game?");
	    XText(w, 50, 250, buf, strlen(buf), dfont, textColor, backColor);
	    mustexit = 1;
	    break;
	}
    if (oldmax < me->p_kills)
	oldmax = me->p_kills;
    mystats->st_kills += me->p_kills;
    /* the exit routine in 'entryWindow' handles reentry now */
    XSync(dpy, 1);
    longjmp(env, 0);
}
